(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1527411,      38553]
NotebookOptionsPosition[   1265008,      35832]
NotebookOutlinePosition[   1265822,      35859]
CellTagsIndexPosition[   1265779,      35856]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This Notebook contains supplementary material related to the paper
\"Arrangement of Central Points on the Faces of a Tetrahedron\" by Stanley \
Rabinowitz,
submitted to the International Journal of Computer Discovered Mathematics 
(http : // www.journal - 1. eu/) in August 2020.
 
This Notebook is Copyright \[Copyright] August 2020 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.\
\>", "Text",
 CellChangeTimes->{{3.8056311537890673`*^9, 3.805631183666998*^9}, {
  3.805631221024912*^9, 3.8056313282165127`*^9}, {3.805643718014955*^9, 
  3.805643719078762*^9}},ExpressionUUID->"371ff2f8-f3d0-420c-b039-\
e77672a2725a"],

Cell[BoxData[
 RowBox[{"(*", "\n", "\t\t\t", 
  RowBox[{
   RowBox[{
   "If", " ", "your", " ", "input", " ", "files", " ", "are", " ", "going", 
    " ", "to", " ", "be", " ", "in", " ", "a", " ", "special", " ", 
    "directory"}], ",", "\[IndentingNewLine]", "            ", 
   RowBox[{
   "you", " ", "should", " ", "add", " ", "that", " ", "directory", " ", "to",
     " ", "the", " ", "$Path", " ", 
    RowBox[{"variable", ".", " ", "For"}], " ", 
    RowBox[{"example", ":", "\[IndentingNewLine]", "          ", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"$Path", ",", 
       RowBox[{"NotebookDirectory", "[", "]"}]}], "]"}]}]}]}], "\n", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.805631006929036*^9, 3.8056310083438387`*^9}, {
  3.805640012619944*^9, 3.8056400427391376`*^9}, {3.805640124611961*^9, 
  3.805640173227358*^9}},ExpressionUUID->"b1163c4e-79d8-4c96-b931-\
923fe0f4dfc2"],

Cell[CellGroupData[{

Cell["\<\
ReadCenters[file_,echo_]:=
Block[{expr,k,state,cname},
\tstate = OpenRead[file];
\tIf[state==$Failed,Return[0]];
\tk = 0;
\tWhile[True,
\t\tcname = Read[file,Word,WordSeparators->\",\"];
\t\tRead[file,Character];
\t\texpr = Read[file,Expression];
\t\tIf[expr==EndOfFile,Break[]];
\t\tIf[expr==$Aborted,Break[]];
\t\tIf[expr==Null,Continue[]];
\t\tk++;
\t\tIf[echo,
\t\t\tPrint[\"\"];
\t\t\tPrint[k,\") \",cname,\": \",expr];
\t\t\t];
\t\tcenterName[k] = cname;
\t\texpr=expr/.{K->(2a^2b^2+2b^2c^2+2c^2a^2-a^4-b^4-c^4)/4};
\t\tTrilinearCenter[k]=Together[expr];
\t];
\tClose[file];
\tReturn[k];
];

SetAttributes[g,Orderless];\t(* Make g commutative *)

numberOfCenters = 0;
numberOfCenters =
\tReadCenters[\"trilinearCenters.txt\",True];
Print[numberOfCenters,\" trilinear centers found.\"];

For[i=1,i<=numberOfCenters,i++,
\t(* Convert Center info into triples *)
\tcoord1 = TrilinearCenter[i];
\tcoord2 = coord1/.{a->b,b->c,c->a};
\tcoord3 = coord2/.{a->b,b->c,c->a};
\tTrilinearCoords[i]={coord1,coord2,coord3};
\t(* Convert to Areal Coordinates *)
\tArealCoords[i]={a coord1,b coord2,c coord3};
\t];\
\>", "Input",
 InitializationCell->True,
 CellChangeTimes->{3.805639037965542*^9},
 AspectRatioFixed->True,
 CellLabel->
  "In[186]:=",ExpressionUUID->"4234ab68-a109-4864-a278-29656578f3a7"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965054262*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"51ccb197-f6cc-4555-8c1a-6e0f71201997"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"incenter\"\>", "\[InvisibleSpace]", "\<\": \"\>",
    "\[InvisibleSpace]", "1"}],
  SequenceForm[1, ") ", "incenter", ": ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965056303*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"76ac379a-1d58-4294-bb88-66de29a0315e"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965057922*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"ee91ec92-eaea-439f-9dc5-4123c0a1f45a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\": \"\>",
    "\[InvisibleSpace]", 
   FractionBox["1", "a"]}],
  SequenceForm[2, ") ", "centroid", ": ", $CellContext`a^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965059495*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"5e85d021-a840-4b44-852d-43cadcdf930b"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965061105*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"405d1c23-165e-4030-8cdf-d0e1667e7907"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"circumcenter\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  3, ") ", "circumcenter", 
   ": ", $CellContext`a (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965062714*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"28daf1c5-1250-42c8-8971-94a3fcf917da"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965064662*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"38078b31-b19c-4f75-aa86-5d920f1e7a70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"orthocenter\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  4, ") ", "orthocenter", 
   ": ", $CellContext`a^(-1)/(-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996506633*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"5fc19aee-aeb8-4081-8562-220f34827195"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965068025*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"5bfc5989-acaa-4c41-9605-74c0159aad6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "5", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"nine point center\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "-", 
     SuperscriptBox["b", "4"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     SuperscriptBox["c", "4"]}], "a"]}],
  SequenceForm[
  5, ") ", "nine point center", 
   ": ", $CellContext`a^(-1) ($CellContext`a^2 $CellContext`b^2 - \
$CellContext`b^4 + $CellContext`a^2 $CellContext`c^2 + 
    2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965069951*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"4cbf2f36-0b25-4eef-b2e9-de5d8e4768b2"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965071851*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"7fdb971a-426d-4eef-94d1-48c9cd03beaf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "6", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"symmedian point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", "a"}],
  SequenceForm[6, ") ", "symmedian point", ": ", $CellContext`a],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399650736227`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"03fc96fc-877f-4642-b2da-e828604f51f6"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965075201*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a6acf05d-f4da-4fab-97a3-a761755d08e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "7", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Gergonne point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}],
  SequenceForm[
  7, ") ", "Gergonne point", 
   ": ", $CellContext`a^(-1)/(-$CellContext`a + $CellContext`b + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965076796*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c4889aab-d6df-433b-90e8-9053ee5bdbc2"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965078375*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"3294a03e-b2b2-4672-90ac-10ee1fb11d5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Nagel point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "a"}], "+", "b", "+", "c"}], "a"]}],
  SequenceForm[
  8, ") ", "Nagel point", 
   ": ", $CellContext`a^(-1) (-$CellContext`a + $CellContext`b + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996508*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a7bc21b2-9c87-47d7-8c04-de889c314ca8"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399650818653`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"82012601-404e-4f94-9c99-a83ef3fa4ad7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "9", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Mittenpunkt\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "b", "+", "c"}]}],
  SequenceForm[
  9, ") ", "Mittenpunkt", 
   ": ", -$CellContext`a + $CellContext`b + $CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996508349*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"30d62214-60aa-430d-8a4e-89a689242e87"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996508503*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"67c0ee30-5d03-4a4c-bea0-4bbab63ea4f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Spieker center\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"b", "+", "c"}], "a"]}],
  SequenceForm[
  10, ") ", "Spieker center", 
   ": ", $CellContext`a^(-1) ($CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399650865993`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"83827553-bdc9-4a65-b70f-3754299f36e8"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965088153*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"f36d9b9f-d255-4ad0-9d57-e4476751bbf1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "11", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Feuerbach point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "b"}], "+", "c"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], "a"]}],
  SequenceForm[
  11, ") ", "Feuerbach point", 
   ": ", $CellContext`a^(-1) (-$CellContext`b + $CellContext`c)^2 \
(-$CellContext`a + $CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965089704*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"6539b65b-0bee-476e-8d4b-cd6cf3d9b136"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399650912733`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"3ad217ac-314c-4ecc-9755-80cd5afc02ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "12", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X12\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}], "2"], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}],
  SequenceForm[
  12, ") ", "X12", 
   ": ", $CellContext`a^(-1) ($CellContext`b + \
$CellContext`c)^2/(-$CellContext`a + $CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399650928164`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"d838eeea-d168-47a6-858c-ebefba39a062"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965094337*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"9ba04be4-0ea3-466d-8d4c-77f99b023caf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "13", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"1st isogonic center (Fermat point)\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{
      SqrtBox["3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], "-", 
     RowBox[{"4", " ", "K"}]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"b", " ", "c"}], "+", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "+", 
       RowBox[{"b", " ", "c"}], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  13, ") ", "1st isogonic center (Fermat point)", 
   ": ", $CellContext`a^(-1) (-$CellContext`a^2 + $CellContext`b^2 - \
$CellContext`b $CellContext`c + $CellContext`c^2)^(-1) (-$CellContext`a^2 + \
$CellContext`b^2 + $CellContext`b $CellContext`c + $CellContext`c^2)^(-1) (
    3^Rational[
       1, 2] (-$CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2) - 4 K)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965095976*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c29c7334-659a-4aa9-99e8-8a3e5c310bf0"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965097721*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"dd834b83-9cda-424c-bcaf-04910a1acb74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "14", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Isogonic center\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{
      SqrtBox["3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], "-", 
     RowBox[{"4", " ", "K"}]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"b", " ", "c"}], "+", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "+", 
       RowBox[{"b", " ", "c"}], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  14, ") ", "2nd Isogonic center", 
   ": ", $CellContext`a^(-1) (-$CellContext`a^2 + $CellContext`b^2 - \
$CellContext`b $CellContext`c + $CellContext`c^2)^(-1) (-$CellContext`a^2 + \
$CellContext`b^2 + $CellContext`b $CellContext`c + $CellContext`c^2)^(-1) (
    3^Rational[1, 2] ($CellContext`a^2 - $CellContext`b^2 - $CellContext`c^2) - 
    4 K)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965099374*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"b95ef58c-a054-47e4-a6e3-c4f7ebfaf660"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965100913*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"dfbda8bb-6e6e-4a53-a1c1-6616d0068ac4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "15", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"1st Isodynamic point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], "+", 
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"4", " ", "K"}]}], ")"}]}]}],
  SequenceForm[
  15, ") ", "1st Isodynamic point", 
   ": ", $CellContext`a (
    3^Rational[
       1, 2] (-$CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2) + 4 K)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965102373*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"83a205bc-954f-4203-9605-f01215db58d3"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651038637`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a75ca343-33c3-421c-b5e9-d16bb20bddf5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "16", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Isodynamic point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"4", " ", "K"}]}], ")"}]}]}],
  SequenceForm[
  16, ") ", "2nd Isodynamic point", 
   ": ", $CellContext`a (
    3^Rational[1, 2] ($CellContext`a^2 - $CellContext`b^2 - $CellContext`c^2) + 
    4 K)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965105359*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"94433305-7375-41ef-8cfc-c06db4084cc8"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965106832*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"259ccaa3-3be7-475e-aad6-140cb05ada63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "17", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"1st Napoleon point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"], "-", 
     RowBox[{"4", " ", 
      SqrtBox["3"], " ", "K"}]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "4"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}], "+", 
       SuperscriptBox["b", "4"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "2"]}], "+", 
       SuperscriptBox["c", "4"]}], ")"}]}]]}],
  SequenceForm[
  17, ") ", "1st Napoleon point", 
   ": ", $CellContext`a^(-1) ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4)^(-1) (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2 - 4 3^Rational[1, 2] K)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965108368*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"2be48901-9118-492c-8884-2c90d2ab8a6f"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965109909*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"1d75df1c-8fdd-4196-959e-9fcf5199e317"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "18", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Napoleon point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"], "-", 
     RowBox[{"4", " ", 
      SqrtBox["3"], " ", "K"}]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "4"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}], "+", 
       SuperscriptBox["b", "4"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "2"]}], "+", 
       SuperscriptBox["c", "4"]}], ")"}]}]]}],
  SequenceForm[
  18, ") ", "2nd Napoleon point", 
   ": ", $CellContext`a^(-1) ($CellContext`a^4 - 
     2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
     2 $CellContext`a^2 $CellContext`c^2 - $CellContext`b^2 $CellContext`c^2 + \
$CellContext`c^4)^(-1) ($CellContext`a^2 - $CellContext`b^2 - \
$CellContext`c^2 - 4 3^Rational[1, 2] K)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965111433*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a3452c6c-ad7c-46c2-b316-5b5d983f43af"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965112966*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a12b56cd-23cd-4847-9117-41231a6c5e2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "19", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Crucial point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}]]}],
  SequenceForm[
  19, ") ", "Crucial point", 
   ": ", (-$CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2)^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965114362*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"87caa698-1893-45e1-8dda-b417a5d5e411"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651157913`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"da77f11a-191a-41fc-8643-962f6f19774a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"De Longchamps point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      SuperscriptBox["a", "4"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "+", 
     SuperscriptBox["b", "4"], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     SuperscriptBox["c", "4"]}], "a"]}],
  SequenceForm[
  20, ") ", "De Longchamps point", 
   ": ", $CellContext`a^(-1) ((-3) $CellContext`a^4 + 
    2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 + 
    2 $CellContext`a^2 $CellContext`c^2 - 
    2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651172657`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"93164cb1-274e-413a-a632-9e745f33bd73"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965118763*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"2c84754f-7736-4ea6-963b-807a5a9345b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "21", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Schiffler point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "a"}], "+", "b", "+", "c"}], 
    RowBox[{"b", "+", "c"}]]}],
  SequenceForm[
  21, ") ", "Schiffler point", 
   ": ", ($CellContext`b + $CellContext`c)^(-1) (-$CellContext`a + \
$CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965120216*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"8a3c5239-f63f-45b6-8d6c-8b330fe03a61"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965121655*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"16f03b13-d528-4b19-8618-296563a17650"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "22", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Exeter point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"]}], ")"}]}]}],
  SequenceForm[
  22, ") ", "Exeter point", 
   ": ", $CellContext`a (-$CellContext`a^4 + $CellContext`b^4 + \
$CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965123205*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"9a6aef59-f2cf-4a6e-aa05-eed7b131d0bc"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996512466*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"d934694e-cf41-41e0-8302-83ad795fe196"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "23", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"far out point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}], ")"}]}]}],
  SequenceForm[
  23, ") ", "far out point", 
   ": ", $CellContext`a (-$CellContext`a^4 + $CellContext`b^4 - \
$CellContext`b^2 $CellContext`c^2 + $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651261053`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"1af41dd6-9647-4076-97d4-49e658cb17bc"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965127556*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"503dfba2-7ebf-4fb6-a4e4-da0a76b17671"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "24", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X24\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}], "-", 
       SuperscriptBox["b", "4"], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["c", "2"]}], "-", 
       SuperscriptBox["c", "4"]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}]]}],
  SequenceForm[
  24, ") ", "X24", 
   ": ", $CellContext`a ($CellContext`a^2 - $CellContext`b^2 - \
$CellContext`c^2)^(-1) (-$CellContext`a^4 + 
    2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + 
    2 $CellContext`a^2 $CellContext`c^2 - $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651290607`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"b8e2960e-67c6-4381-a854-314aa6fa1bfc"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651305656`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"b761960f-2d1b-495a-851f-33ec0d031e67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "25", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X25\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["a", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}]]}],
  SequenceForm[
  25, ") ", "X25", 
   ": ", $CellContext`a/(-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965131978*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"3d4fe4bf-c361-4b53-97d2-3c7b6c73c800"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965133423*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"42d05af0-2716-41a9-aea2-f93a3cdf086e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "26", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Circumcenter of tangential triangle\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "6"]}], "+", 
      SuperscriptBox["b", "8"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      SuperscriptBox["c", "8"]}], ")"}]}]}],
  SequenceForm[
  26, ") ", "Circumcenter of tangential triangle", 
   ": ", $CellContext`a (-$CellContext`a^8 + 
    2 $CellContext`a^6 $CellContext`b^2 - 
    2 $CellContext`a^2 $CellContext`b^6 + $CellContext`b^8 + 
    2 $CellContext`a^6 $CellContext`c^2 - 2 $CellContext`b^6 $CellContext`c^2 + 
    2 $CellContext`b^4 $CellContext`c^4 - 2 $CellContext`a^2 $CellContext`c^6 - 
    2 $CellContext`b^2 $CellContext`c^6 + $CellContext`c^8)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965135003*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"715e642f-7664-4e1f-ade4-bc11107bb36e"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965136676*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"853ebbd0-8b0f-40cb-b550-d374456ae021"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "27", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X27\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  27, ") ", "X27", 
   ": ", $CellContext`a^(-1) ($CellContext`b + \
$CellContext`c)^(-1)/(-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965138137*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"82741e14-875e-4168-a5e7-a2c4e418fb2b"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965139608*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a2782d39-f7a2-4f58-9874-f8d9d64ab97f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "28", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X28\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  28, ") ", "X28", 
   ": ", ($CellContext`b + $CellContext`c)^(-1)/(-$CellContext`a^2 + \
$CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965141049*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"bc4848fd-579d-4122-b051-c62a4a21b57a"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965142509*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"2177ea89-50cf-4339-89c6-1f26c82387b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "29", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X29\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"a", "-", "b", "-", "c"}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  29, ") ", "X29", 
   ": ", $CellContext`a^(-1) ($CellContext`a - $CellContext`b - \
$CellContext`c) ($CellContext`b + $CellContext`c)^(-1)/($CellContext`a^2 - \
$CellContext`b^2 - $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965144011*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"9ab0a8db-45b3-4756-add6-c3251644c1ae"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651454782`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"072f0f3b-0133-46b8-a664-9956acf28719"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "30", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X30\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "a"}], "+", "b", "+", "c"}], "a"]}],
  SequenceForm[
  30, ") ", "X30", 
   ": ", $CellContext`a^(-1) (
    2 $CellContext`a + $CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965146888*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"f9bca379-59d3-4188-aa48-1b489b4c0c00"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965148315*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"77175869-ccc7-4878-b90b-a4f23fb5670c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "31", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"2nd power point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   SuperscriptBox["a", "2"]}],
  SequenceForm[31, ") ", "2nd power point", ": ", $CellContext`a^2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965149694*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"7888a723-7fad-4a12-af78-70504f89f5cd"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965151123*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"4476c4ad-11b4-4a2a-a271-a7d60a708583"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "32", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"3rd power point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   SuperscriptBox["a", "3"]}],
  SequenceForm[32, ") ", "3rd power point", ": ", $CellContext`a^3],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965152564*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"5dbec48a-54c8-48c9-926e-9886004bf610"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965153996*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"63c5b55c-4089-420b-be91-fbf6b2a8489b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "33", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X33\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "a"}], "+", "b", "+", "c"}], 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}]]}],
  SequenceForm[
  33, ") ", "X33", 
   ": ", (-$CellContext`a + $CellContext`b + \
$CellContext`c)/(-$CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965155438*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"9343b70b-968f-417e-a899-c89db675cc2c"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965157048*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"1e910ce5-aacd-4b5e-9f12-9c876b205cac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "34", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X34\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  34, ") ", "X34", 
   ": ", (-$CellContext`a + $CellContext`b + \
$CellContext`c)^(-1)/(-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996515853*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"6b9a8f07-9c32-4d49-a3ca-613138d738c8"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965160007*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"5ccedeeb-1b8b-489e-bb89-b858c3dc6a75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "35", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X35\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      RowBox[{"b", " ", "c"}], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  35, ") ", "X35", 
   ": ", $CellContext`a (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`b $CellContext`c + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651614447`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"e82703f7-d208-4d2b-862a-1226e22bb27f"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651628933`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"6de262f6-da72-4278-a0bd-bad3abf0f4a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "36", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X36\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "+", 
      RowBox[{"b", " ", "c"}], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  36, ") ", "X36", 
   ": ", $CellContext`a ($CellContext`a^2 - $CellContext`b^2 + $CellContext`b \
$CellContext`c - $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651643267`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"4ba353d1-366c-4bde-a55d-83272e3b9c1d"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965165771*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"2fbe6791-e453-42fc-ace2-f4ac098d6beb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "37", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X37\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"b", "+", "c"}]}],
  SequenceForm[37, ") ", "X37", ": ", $CellContext`b + $CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965167285*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"441203b2-dee5-48aa-9618-847560dd972b"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651687202`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"5937fed9-93af-4a3f-9868-334ebb5b1ef0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "38", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X38\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}]}],
  SequenceForm[38, ") ", "X38", ": ", $CellContext`b^2 + $CellContext`c^2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965170192*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"1964eb1b-ac90-4361-a777-972f5fbab02c"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965171605*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"fd9177e1-2467-4c07-a116-074df7baddfa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "39", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Brocard midpoint\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  39, ") ", "Brocard midpoint", 
   ": ", $CellContext`a ($CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965173007*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"15462f16-5795-415a-bfc8-7b7883686b54"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651744623`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"beeeb58a-8aa3-4337-a9fa-e1e3657ba1dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "40", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X40\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "3"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b"}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["b", "3"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "-", 
    RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    SuperscriptBox["c", "3"]}]}],
  SequenceForm[
  40, ") ", "X40", 
   ": ", $CellContext`a^3 + $CellContext`a^2 $CellContext`b - $CellContext`a \
$CellContext`b^2 - $CellContext`b^3 + $CellContext`a^2 $CellContext`c - 
   2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 - $CellContext`c^3],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965176095*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"443e3e9d-c4ab-4553-87ff-318127a9e0c9"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996517761*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"02f07f4d-083f-490f-a402-1bbaa71b1d94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "41", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X41\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}],
  SequenceForm[
  41, ") ", "X41", 
   ": ", $CellContext`a^2 (-$CellContext`a + $CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965179051*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"9a0b4794-bb05-4692-a247-6aab9900004d"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996518047*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"0543221b-70d0-4f60-9332-bb59fa2b404e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "42", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X42\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}]}]}],
  SequenceForm[
  42, ") ", "X42", ": ", $CellContext`a ($CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965181868*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"0fea522d-a925-4652-b019-2937d7a394a5"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965183267*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"64b52802-9e92-4e8b-85aa-536e42b6e363"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "43", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X43\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", " ", "b"}], "+", 
    RowBox[{"a", " ", "c"}], "-", 
    RowBox[{"b", " ", "c"}]}]}],
  SequenceForm[
  43, ") ", "X43", 
   ": ", $CellContext`a $CellContext`b + $CellContext`a $CellContext`c - \
$CellContext`b $CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965184801*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"423b821b-b0de-4163-9f47-c059bf38cf00"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965186282*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"21f40674-62cf-42ef-a9a7-f570cc201290"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "44", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X44\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}]}],
  SequenceForm[
  44, ") ", "X44", 
   ": ", (-2) $CellContext`a + $CellContext`b + $CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965187688*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"3a86ecf2-bcbf-4c18-8177-9dd9a91a2b1c"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965189093*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"1dd0e29a-48f1-4988-a9d6-27144ec6b95e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "45", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X45\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "a"}], "+", 
    RowBox[{"2", " ", "b"}], "+", 
    RowBox[{"2", " ", "c"}]}]}],
  SequenceForm[
  45, ") ", "X45", ": ", -$CellContext`a + 2 $CellContext`b + 
   2 $CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399651905003`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"7669c966-6b91-4332-98d0-bb1f77d87f9c"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965191903*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"756093f6-ecc9-47a5-93ee-b8038f734c4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "46", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X46\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "3"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b"}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["b", "3"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    SuperscriptBox["c", "3"]}]}],
  SequenceForm[
  46, ") ", "X46", 
   ": ", $CellContext`a^3 + $CellContext`a^2 $CellContext`b - $CellContext`a \
$CellContext`b^2 - $CellContext`b^3 + $CellContext`a^2 $CellContext`c + \
$CellContext`b^2 $CellContext`c - $CellContext`a $CellContext`c^2 + \
$CellContext`b $CellContext`c^2 - $CellContext`c^3],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965193474*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"de121f17-6986-45d9-a1b7-81827a96cda1"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965194956*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c1bfd83b-9f3d-4917-bb4c-48bae8ca1a02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "47", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X47\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}], ")"}]}]}],
  SequenceForm[
  47, ") ", "X47", 
   ": ", $CellContext`a^2 ($CellContext`a^4 - 
    2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
    2 $CellContext`a^2 $CellContext`c^2 + $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965196447*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c7d6bae5-d066-476b-8887-e9fb0ba5a0f4"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965197953*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"fef30252-0508-439d-aff7-4bdaaf37ea02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "48", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X48\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  48, ") ", "X48", 
   ": ", $CellContext`a^2 (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996519939*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a4fd87e3-8e46-4430-b110-0b08263f2648"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965200828*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"e75c94a0-2062-4db1-9f32-d5748b725851"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "49", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X49\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ")"}]}]}],
  SequenceForm[
  49, ") ", "X49", 
   ": ", $CellContext`a^3 ($CellContext`a^2 - $CellContext`b^2 - \
$CellContext`c^2) (-$CellContext`a^4 + 
    2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + 
    2 $CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2 - \
$CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965202392*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"71ba4eda-d340-4b3c-b9c0-f434a5f2d248"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965204018*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"52415aa3-90d4-49da-9697-fc3259b816c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "50", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"X50\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"b", " ", "c"}], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "+", 
      RowBox[{"b", " ", "c"}], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  50, ") ", "X50", 
   ": ", $CellContext`a^3 ($CellContext`a^2 - $CellContext`b^2 - \
$CellContext`b $CellContext`c - $CellContext`c^2) ($CellContext`a^2 - \
$CellContext`b^2 + $CellContext`b $CellContext`c - $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965205523*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"547556e0-145c-498a-a010-4dbf4ba00106"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965207073*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"ec7d7278-cbf1-4b0c-a419-5eb211db49bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "51", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Centroid of orthic triangle\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ")"}]}]}],
  SequenceForm[
  51, ") ", "Centroid of orthic triangle", 
   ": ", $CellContext`a ($CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + \
$CellContext`a^2 $CellContext`c^2 + 
    2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996520857*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"256439b8-5060-4eda-91af-0f37bd97a3b9"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965210067*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"51e79423-8e7f-4dda-9a1c-5fdcb7e12406"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "52", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Orthocenter of orthic triangle\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"]}], ")"}]}]}],
  SequenceForm[
  52, ") ", "Orthocenter of orthic triangle", 
   ": ", $CellContext`a ($CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + \
$CellContext`a^2 $CellContext`c^2 + 
    2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4) ($CellContext`a^4 - 
    2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
    2 $CellContext`a^2 $CellContext`c^2 + $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965211619*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"20b64273-2427-4cca-b52a-6371e339016b"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965213166*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"cd2131de-7dac-4002-9c99-5ae348647a56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "53", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Symmedian point of orthic triangle\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "-", 
     SuperscriptBox["b", "4"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     SuperscriptBox["c", "4"]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  53, ") ", "Symmedian point of orthic triangle", 
   ": ", $CellContext`a^(-1) (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2)^(-1) ($CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + \
$CellContext`a^2 $CellContext`c^2 + 
    2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965214679*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"f6f52034-359f-4965-9b39-2e3b4cb051fb"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965216217*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"b29cfa0b-c9e8-4394-8ed6-37c415fe4e6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "54", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Nine point inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["a", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "-", 
     SuperscriptBox["b", "4"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     SuperscriptBox["c", "4"]}]]}],
  SequenceForm[
  54, ") ", "Nine point inv", 
   ": ", $CellContext`a/($CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + \
$CellContext`a^2 $CellContext`c^2 + 
   2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652177687`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a3f56cee-0813-4b1a-9078-7c59937e564a"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965219335*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"ae8b1540-06fc-4e24-a61f-9b2124c87d03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "55", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Gergonne inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}],
  SequenceForm[
  55, ") ", "Gergonne inv", 
   ": ", $CellContext`a (-$CellContext`a + $CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965220745*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c7dbf858-0b2e-4007-b606-1128c4b1dd29"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652221746`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"4ecacb8c-08cd-49e8-9ac7-581d4b11d48d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "56", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Nagel inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["a", 
    RowBox[{
     RowBox[{"-", "a"}], "+", "b", "+", "c"}]]}],
  SequenceForm[
  56, ") ", "Nagel inv", 
   ": ", $CellContext`a/(-$CellContext`a + $CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965223577*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"f0085f72-ea00-4710-9d4d-e3d017a1491a"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965225193*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"61822e1e-863c-484c-99b5-ae1ba703d0d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "57", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Mittenpunkt inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"-", "a"}], "+", "b", "+", "c"}]]}],
  SequenceForm[
  57, ") ", "Mittenpunkt inv", 
   ": ", (-$CellContext`a + $CellContext`b + $CellContext`c)^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965226618*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"3af666fc-9a49-44eb-a06d-6b18e8bbd4c8"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652280607`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"8de2d586-83f3-4664-b094-7c554ec2ddaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "58", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Spieker inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["a", 
    RowBox[{"b", "+", "c"}]]}],
  SequenceForm[
  58, ") ", "Spieker inv", 
   ": ", $CellContext`a/($CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965229465*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"6738566e-0703-4bc1-b987-3c41d317e5eb"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965230898*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"88c3c56b-5c9f-46fe-ab03-488ad4e10f23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "59", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Feuerbach inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["a", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "b"}], "+", "c"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}],
  SequenceForm[
  59, ") ", "Feuerbach inv", 
   ": ", $CellContext`a (-$CellContext`b + \
$CellContext`c)^(-2)/(-$CellContext`a + $CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965232335*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"632c732a-57a1-4201-a13f-43f0a226a9b5"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652337914`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"eea6689a-f702-49e0-a104-7069c39ed328"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "60", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X12 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}], "2"]]}],
  SequenceForm[
  60, ") ", "X12 inv", 
   ": ", $CellContext`a ($CellContext`b + $CellContext`c)^(-2) \
(-$CellContext`a + $CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965235221*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"03c56ae1-02fc-45ab-98b3-e5ba2ef30876"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965236731*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"3f4d7b40-c3d3-4a6a-b86a-9c32e6a79df3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "61", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"1st Napoleon point inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"], "+", 
      RowBox[{"4", " ", 
       SqrtBox["3"], " ", "K"}]}], ")"}]}]}],
  SequenceForm[
  61, ") ", "1st Napoleon point inv", 
   ": ", $CellContext`a (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2 + 4 3^Rational[1, 2] K)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652383842`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"70e60c5c-fc0e-4a6a-81b7-2baaed68f24c"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965239946*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"e2896ab5-d5b0-4129-9e0c-d9393fb8baec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "62", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Napoleon point inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"], "+", 
      RowBox[{"4", " ", 
       SqrtBox["3"], " ", "K"}]}], ")"}]}]}],
  SequenceForm[
  62, ") ", "2nd Napoleon point inv", 
   ": ", $CellContext`a ($CellContext`a^2 - $CellContext`b^2 - \
$CellContext`c^2 + 4 3^Rational[1, 2] K)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965241432*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a56dcfed-ccc5-4724-a3fb-3c5b7e43f32e"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965242936*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a7f618d4-5fb7-4502-bfd7-f7d8ee9bd8f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "63", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Crucial point inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}]}],
  SequenceForm[
  63, ") ", "Crucial point inv", 
   ": ", -$CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965244375*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"e4628727-1bbe-4811-9ca6-a9d758d29dc8"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965245832*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"0bb0720f-e8d2-4cbd-9a37-fad887ee652b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "64", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"De Longchamps point inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["a", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      SuperscriptBox["a", "4"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "+", 
     SuperscriptBox["b", "4"], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     SuperscriptBox["c", "4"]}]]}],
  SequenceForm[
  64, ") ", "De Longchamps point inv", 
   ": ", $CellContext`a/((-3) $CellContext`a^4 + 
   2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 + 
   2 $CellContext`a^2 $CellContext`c^2 - 
   2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965247347*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"2ba6f63c-579c-4866-9bc8-a6c4cd860ce5"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965249044*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"cc75b2fd-b8a2-4d12-9ea3-64df15aaf48c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "65", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Schiffler point inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"b", "+", "c"}], 
    RowBox[{
     RowBox[{"-", "a"}], "+", "b", "+", "c"}]]}],
  SequenceForm[
  65, ") ", "Schiffler point inv", 
   ": ", ($CellContext`b + $CellContext`c)/(-$CellContext`a + $CellContext`b + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652505217`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"e57d3d06-a034-4e40-ab31-d4608daf1d72"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965252*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"604463a6-9c68-494e-9e40-93fe627c9ac1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "66", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Exeter point inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], "+", 
       SuperscriptBox["b", "4"], "+", 
       SuperscriptBox["c", "4"]}], ")"}]}]]}],
  SequenceForm[
  66, ") ", "Exeter point inv", 
   ": ", $CellContext`a^(-1)/(-$CellContext`a^4 + $CellContext`b^4 + \
$CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965253538*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"2dfe7f3c-bf2a-4277-aaa7-23c23d7de488"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965255044*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"2372cef8-fbcb-4b5e-a160-66f9a1089b69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "67", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"far out point inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], "+", 
       SuperscriptBox["b", "4"], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "2"]}], "+", 
       SuperscriptBox["c", "4"]}], ")"}]}]]}],
  SequenceForm[
  67, ") ", "far out point inv", 
   ": ", $CellContext`a^(-1)/(-$CellContext`a^4 + $CellContext`b^4 - \
$CellContext`b^2 $CellContext`c^2 + $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965256527*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"bf0fb608-8a17-46c4-ab25-d99a0557af33"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965258101*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"5580697a-0a83-4801-a9c0-2b1cb43a5cb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "68", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X24 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}], "-", 
       SuperscriptBox["b", "4"], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["c", "2"]}], "-", 
       SuperscriptBox["c", "4"]}], ")"}]}]]}],
  SequenceForm[
  68, ") ", "X24 inv", 
   ": ", $CellContext`a^(-1) ($CellContext`a^2 - $CellContext`b^2 - \
$CellContext`c^2)/(-$CellContext`a^4 + 
   2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + 
   2 $CellContext`a^2 $CellContext`c^2 - $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652596607`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"809740bf-2610-4553-bf92-9ddc90addd71"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965261209*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c3652db1-79d1-4004-92c7-299d289d392e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "69", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X25 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "a"]}],
  SequenceForm[
  69, ") ", "X25 inv", 
   ": ", $CellContext`a^(-1) (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652626667`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"65b2dd76-86db-47d5-9bcb-825816ebebc9"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996526414*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"2dbce668-56a1-4498-9118-e393d361f43a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "70", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Circumcenter of tangential triangle inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "8"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "6"], " ", 
        SuperscriptBox["b", "2"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "6"]}], "+", 
       SuperscriptBox["b", "8"], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "6"], " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "6"], " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "4"], " ", 
        SuperscriptBox["c", "4"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["c", "6"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "6"]}], "+", 
       SuperscriptBox["c", "8"]}], ")"}]}]]}],
  SequenceForm[
  70, ") ", "Circumcenter of tangential triangle inv", 
   ": ", $CellContext`a^(-1)/(-$CellContext`a^8 + 
   2 $CellContext`a^6 $CellContext`b^2 - 
   2 $CellContext`a^2 $CellContext`b^6 + $CellContext`b^8 + 
   2 $CellContext`a^6 $CellContext`c^2 - 2 $CellContext`b^6 $CellContext`c^2 + 
   2 $CellContext`b^4 $CellContext`c^4 - 2 $CellContext`a^2 $CellContext`c^6 - 
   2 $CellContext`b^2 $CellContext`c^6 + $CellContext`c^8)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965265843*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"ecf7352d-f8bf-4ec5-9c19-d6f196e6530e"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652674913`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"04ff3b02-e9c1-4f8b-b780-9cc679b59f39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "71", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X27 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  71, ") ", "X27 inv", 
   ": ", $CellContext`a ($CellContext`b + $CellContext`c) (-$CellContext`a^2 + \
$CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965268997*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"653c5b24-aeea-400e-9a61-c86d3c9ded9c"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652705183`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"82bf62da-30e1-4525-ab56-eb99a996dd45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "72", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X28 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  72, ") ", "X28 inv", 
   ": ", ($CellContext`b + $CellContext`c) (-$CellContext`a^2 + \
$CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652720013`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"839c4ef0-d715-4c7e-8c4e-08980f0b48ca"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652734957`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"1fa3e877-67eb-4ae4-b60d-1a497b49d383"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "73", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X29 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}]}], 
    RowBox[{"a", "-", "b", "-", "c"}]]}],
  SequenceForm[
  73, ") ", "X29 inv", 
   ": ", $CellContext`a ($CellContext`a - $CellContext`b - \
$CellContext`c)^(-1) ($CellContext`b + $CellContext`c) ($CellContext`a^2 - \
$CellContext`b^2 - $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652749968`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a094d815-8208-40bb-a5f4-738db1308396"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965276533*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"7c324041-53d6-46ae-b403-c0731cde7da4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "74", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X30 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["a", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "4"]}], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "+", 
     SuperscriptBox["b", "4"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     SuperscriptBox["c", "4"]}]]}],
  SequenceForm[
  74, ") ", "X30 inv", 
   ": ", $CellContext`a/((-2) $CellContext`a^4 + $CellContext`a^2 \
$CellContext`b^2 + $CellContext`b^4 + $CellContext`a^2 $CellContext`c^2 - 
   2 $CellContext`b^2 $CellContext`c^2 + $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965278059*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"9582d9c6-44a9-4e28-bbb3-3007148d5c19"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965280036*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"d68bd58c-3090-450d-b7ec-a88a18f9b62d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "75", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"2nd power point inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    SuperscriptBox["a", "2"]]}],
  SequenceForm[75, ") ", "2nd power point inv", ": ", $CellContext`a^(-2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965281619*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"809b718f-7acf-4f7c-9eea-538029178bc6"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652831497`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"53e81a49-933d-4927-bd6f-d02085fa2199"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "76", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"3rd power point inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    SuperscriptBox["a", "3"]]}],
  SequenceForm[76, ") ", "3rd power point inv", ": ", $CellContext`a^(-3)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965284605*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"97bda6be-44d8-481f-9526-189066878b90"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996528619*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"626f52cc-42fa-4d3e-8604-235a233edd25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "77", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X33 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], "+", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], 
    RowBox[{
     RowBox[{"-", "a"}], "+", "b", "+", "c"}]]}],
  SequenceForm[
  77, ") ", "X33 inv", 
   ": ", (-$CellContext`a + $CellContext`b + $CellContext`c)^(-1) \
(-$CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965288268*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"fdad4d9b-2458-4cc1-85b9-36cc6b48c6e4"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965289927*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"b06a3bec-f687-4d4c-b55e-89d4c154f0ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "78", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X34 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  78, ") ", "X34 inv", 
   ": ", (-$CellContext`a + $CellContext`b + $CellContext`c) \
(-$CellContext`a^2 + $CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652914257`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"0a664050-ead7-488f-828c-1087f5bd51b8"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965292906*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"82b621e2-8d3d-4bb4-a206-244d5dc28030"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "79", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X35 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "+", 
       RowBox[{"b", " ", "c"}], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  79, ") ", "X35 inv", 
   ": ", $CellContext`a^(-1)/(-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`b $CellContext`c + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965294509*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"0b11c4c4-40f0-4157-997f-3525149c58d2"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965296094*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"7febb892-f675-4e41-8334-f2243820a908"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "80", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X36 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "+", 
       RowBox[{"b", " ", "c"}], "-", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  80, ") ", "X36 inv", 
   ": ", $CellContext`a^(-1)/($CellContext`a^2 - $CellContext`b^2 + \
$CellContext`b $CellContext`c - $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399652976017`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"58e801f8-d323-4f07-8ad9-9a755bc3b716"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965299115*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a42293d8-0e0d-4b29-befc-73b744513095"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "81", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X37 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"b", "+", "c"}]]}],
  SequenceForm[
  81, ") ", "X37 inv", ": ", ($CellContext`b + $CellContext`c)^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965300619*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"1b47772a-cdfa-49c8-a426-0e8cec774fd8"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996530221*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"33da6a5d-9ce8-44e0-83e8-8d1c61ba4e12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "82", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X38 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}]]}],
  SequenceForm[
  82, ") ", "X38 inv", ": ", ($CellContext`b^2 + $CellContext`c^2)^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965303877*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"4a8cfad3-2e1e-42d2-8e24-281e42dbf479"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965305409*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"d9c66f93-f535-4ed3-959d-6760f5fb6593"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "83", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Brocard midpoint inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  83, ") ", "Brocard midpoint inv", 
   ": ", $CellContext`a^(-1)/($CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653069572`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c0baf930-f524-4e97-9627-83ea8d880c0e"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996530849*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"e771183d-a0f4-4332-8e25-8bcf33702064"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "84", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X40 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "3"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "b"}], "-", 
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"]}], "-", 
     SuperscriptBox["b", "3"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "-", 
     RowBox[{"2", " ", "a", " ", "b", " ", "c"}], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "c"}], "-", 
     RowBox[{"a", " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["c", "2"]}], "-", 
     SuperscriptBox["c", "3"]}]]}],
  SequenceForm[
  84, ") ", "X40 inv", 
   ": ", ($CellContext`a^3 + $CellContext`a^2 $CellContext`b - $CellContext`a \
$CellContext`b^2 - $CellContext`b^3 + $CellContext`a^2 $CellContext`c - 
    2 $CellContext`a $CellContext`b $CellContext`c + $CellContext`b^2 \
$CellContext`c - $CellContext`a $CellContext`c^2 + $CellContext`b \
$CellContext`c^2 - $CellContext`c^3)^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965310161*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"fa4808ce-64bc-4071-863c-42976f94db35"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653117447`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c09e8795-f9da-43cf-9938-18e1a9edd4c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "85", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X41 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]]}],
  SequenceForm[
  85, ") ", "X41 inv", 
   ": ", $CellContext`a^(-2)/(-$CellContext`a + $CellContext`b + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965313212*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a24f411f-1d81-42f4-a0f1-62167594e3dd"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965314707*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"0cb5931b-b704-46de-b3d4-8f5d6c7a58e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "86", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X42 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}]}]]}],
  SequenceForm[
  86, ") ", "X42 inv", 
   ": ", $CellContext`a^(-1)/($CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653161592`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"de425fcf-0d08-4588-bb69-73d5a2731830"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965317634*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"2bfd6c35-55d8-49dc-a391-5e63e5f4e708"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "87", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X43 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{"a", " ", "c"}], "-", 
     RowBox[{"b", " ", "c"}]}]]}],
  SequenceForm[
  87, ") ", "X43 inv", 
   ": ", ($CellContext`a $CellContext`b + $CellContext`a $CellContext`c - \
$CellContext`b $CellContext`c)^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965319171*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"f82c8f58-f1cd-48bf-8b05-6f2f8e10a7ac"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653211517`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"96667089-b9c0-4770-a1e3-2bb7acb6f032"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "88", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X44 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}]]}],
  SequenceForm[
  88, ") ", "X44 inv", 
   ": ", ((-2) $CellContext`a + $CellContext`b + $CellContext`c)^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965323103*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"8e5d9b34-a744-4efc-8d90-9521dba50f17"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965324684*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"f64d7967-7df0-460e-9e0a-f6316cca2256"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "89", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X45 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"-", "a"}], "+", 
     RowBox[{"2", " ", "b"}], "+", 
     RowBox[{"2", " ", "c"}]}]]}],
  SequenceForm[
  89, ") ", "X45 inv", 
   ": ", (-$CellContext`a + 2 $CellContext`b + 2 $CellContext`c)^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653261642`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"82c5cec4-26d4-406a-b97f-9ad9bbd93319"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965327677*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c61822d5-f299-41a9-804b-a52f4c618666"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "90", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X46 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "3"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "b"}], "-", 
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"]}], "-", 
     SuperscriptBox["b", "3"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "c"}], "-", 
     RowBox[{"a", " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["c", "2"]}], "-", 
     SuperscriptBox["c", "3"]}]]}],
  SequenceForm[
  90, ") ", "X46 inv", 
   ": ", ($CellContext`a^3 + $CellContext`a^2 $CellContext`b - $CellContext`a \
$CellContext`b^2 - $CellContext`b^3 + $CellContext`a^2 $CellContext`c + \
$CellContext`b^2 $CellContext`c - $CellContext`a $CellContext`c^2 + \
$CellContext`b $CellContext`c^2 - $CellContext`c^3)^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653292513`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"240f78b9-eed5-4725-af0f-a23440da1cf6"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965330926*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"8d939d92-73c1-4676-9828-da176a09fa11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "91", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X47 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "4"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}], "+", 
       SuperscriptBox["b", "4"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["c", "2"]}], "+", 
       SuperscriptBox["c", "4"]}], ")"}]}]]}],
  SequenceForm[
  91, ") ", "X47 inv", ": ", $CellContext`a^(-2)/($CellContext`a^4 - 
   2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
   2 $CellContext`a^2 $CellContext`c^2 + $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965332471*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"7626366c-767c-4ffa-bf6d-32dc99510d22"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965334188*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"e83ed515-b33e-48ab-9d6b-c83d7482fef6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "92", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X48 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  92, ") ", "X48 inv", 
   ": ", $CellContext`a^(-2)/(-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965335785*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c3a67ad6-b84f-44b6-9c54-ddca3db38649"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965337825*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"678a25fe-08fa-43d4-b99d-00bed7989469"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "93", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X49 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}], "-", 
       SuperscriptBox["b", "4"], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "2"]}], "-", 
       SuperscriptBox["c", "4"]}], ")"}]}]]}],
  SequenceForm[
  93, ") ", "X49 inv", 
   ": ", $CellContext`a^(-3) ($CellContext`a^2 - $CellContext`b^2 - \
$CellContext`c^2)^(-1)/(-$CellContext`a^4 + 
   2 $CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + 
   2 $CellContext`a^2 $CellContext`c^2 + $CellContext`b^2 $CellContext`c^2 - \
$CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653397703`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"e7769183-d41e-404e-94b3-7846f0c5f217"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965341435*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"010ba9ad-f23e-44dd-b085-8910d4d51be0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "94", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X50 inv\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"b", " ", "c"}], "-", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "+", 
       RowBox[{"b", " ", "c"}], "-", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  94, ") ", "X50 inv", 
   ": ", $CellContext`a^(-3) ($CellContext`a^2 - $CellContext`b^2 - \
$CellContext`b $CellContext`c - $CellContext`c^2)^(-1)/($CellContext`a^2 - \
$CellContext`b^2 + $CellContext`b $CellContext`c - $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965343014*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"2feafbb2-7dc3-4112-b749-aef16896fbaa"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965344583*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"cbb92654-b65d-437e-9666-f36054b6e098"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "95", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Centroid of orthic triangle inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}], "-", 
       SuperscriptBox["b", "4"], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "2"]}], "-", 
       SuperscriptBox["c", "4"]}], ")"}]}]]}],
  SequenceForm[
  95, ") ", "Centroid of orthic triangle inv", 
   ": ", $CellContext`a^(-1)/($CellContext`a^2 $CellContext`b^2 - \
$CellContext`b^4 + $CellContext`a^2 $CellContext`c^2 + 
   2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965346119*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"94995a70-19f7-4910-9fbd-2e539359b849"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653477097`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"9d6e2e37-8372-41d1-b212-814d757ee337"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "96", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Orthocenter of orthic triangle inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}], "-", 
       SuperscriptBox["b", "4"], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["c", "2"]}], "-", 
       SuperscriptBox["c", "4"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "4"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}], "+", 
       SuperscriptBox["b", "4"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["c", "2"]}], "+", 
       SuperscriptBox["c", "4"]}], ")"}]}]]}],
  SequenceForm[
  96, ") ", "Orthocenter of orthic triangle inv", 
   ": ", $CellContext`a^(-1) ($CellContext`a^2 $CellContext`b^2 - \
$CellContext`b^4 + $CellContext`a^2 $CellContext`c^2 + 
     2 $CellContext`b^2 $CellContext`c^2 - \
$CellContext`c^4)^(-1)/($CellContext`a^4 - 
   2 $CellContext`a^2 $CellContext`b^2 + $CellContext`b^4 - 
   2 $CellContext`a^2 $CellContext`c^2 + $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965349326*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"6c6c3a07-27a5-4f40-b8db-924d1f031926"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653509483`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"646871a4-857c-447a-9ee1-85455e24a313"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "97", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Symmedian point of orthic triangle inv\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}], "-", 
     SuperscriptBox["b", "4"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     SuperscriptBox["c", "4"]}]]}],
  SequenceForm[
  97, ") ", "Symmedian point of orthic triangle inv", 
   ": ", $CellContext`a (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2)/($CellContext`a^2 $CellContext`b^2 - $CellContext`b^4 + \
$CellContext`a^2 $CellContext`c^2 + 
   2 $CellContext`b^2 $CellContext`c^2 - $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653525763`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c1842c61-d405-4ded-a6cd-a5dd36c3b78e"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653547087`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"b27dd74f-a4a3-4382-895a-0887a3f165a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "98", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Tarry point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], " ", 
        SuperscriptBox["b", "2"]}], "+", 
       SuperscriptBox["b", "4"], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["c", "2"]}], "+", 
       SuperscriptBox["c", "4"]}], ")"}]}]]}],
  SequenceForm[
  98, ") ", "Tarry point", 
   ": ", $CellContext`a^(-1)/(-$CellContext`a^2 $CellContext`b^2 + \
$CellContext`b^4 - $CellContext`a^2 $CellContext`c^2 + $CellContext`c^4)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965356572*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"044a371e-3c2b-48eb-b6f4-3065b529a161"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965358191*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"283a00f0-2241-47b1-8db6-b980331be831"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "99", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"Steiner point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "c"}], ")"}]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}]}]]}],
  SequenceForm[
  99, ") ", "Steiner point", 
   ": ", $CellContext`a^(-1) (-$CellContext`a + $CellContext`b) \
(-$CellContext`a + $CellContext`c)/($CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653597097`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"fdd8e7c1-859c-4b41-a056-24e0f80b2a53"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965361383*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"b1f592ef-d0d9-4829-8673-9bf1baf029e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "100", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X100\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "c"}], ")"}]}]}],
  SequenceForm[
  100, ") ", "X100", 
   ": ", (-$CellContext`a + $CellContext`b) (-$CellContext`a + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965362936*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"f44e329a-ec7a-4741-a7b1-68e3810ba5eb"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965364439*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"f597bba7-f350-4b9e-bf90-0c8e94d54ce8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "101", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X101\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "c"}], ")"}]}]}],
  SequenceForm[
  101, ") ", "X101", 
   ": ", $CellContext`a (-$CellContext`a + $CellContext`b) (-$CellContext`a + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965365922*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"808ab5e4-613c-4f9e-86e3-956a38906f22"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965367394*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a6ccf6e7-e957-4ffb-87a1-cea69f1d546e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "102", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X102\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "a"}], " ", "b", " ", "c"}], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}]}]]}],
  SequenceForm[
  102, ") ", "X102", 
   ": ", (-$CellContext`a $CellContext`b $CellContext`c + $CellContext`a^2 \
($CellContext`b + $CellContext`c))^(-1)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653690166`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"4e1dcfb0-535f-415e-ae22-0c3da310f0e1"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996537101*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"684e506b-156b-4e07-bf33-a872f77a1214"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "103", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X103\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["a", 
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}]]}],
  SequenceForm[
  103, ") ", "X103", 
   ": ", $CellContext`a/($CellContext`b^2 - $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965372793*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"e828c4ac-444e-4ac3-a345-2b40f3131dfc"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965374436*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"b0b15a09-e337-4347-805d-7bcab0db736e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "104", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X104\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"b", "-", "c"}], 
    SuperscriptBox["a", "2"]]}],
  SequenceForm[
  104, ") ", "X104", 
   ": ", $CellContext`a^(-2) ($CellContext`b - $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653760557`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"ff137390-f66d-4812-b033-5938d9587c01"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965377604*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a7a2f863-b5c6-4379-b9b9-616c025b8d86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "105", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X105\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["a", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "c"}], ")"}]}]]}],
  SequenceForm[
  105, ") ", "X105", 
   ": ", $CellContext`a (-$CellContext`a + \
$CellContext`b)^(-1)/(-$CellContext`a + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965379136*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a39bd450-d3f7-40b5-91d9-fdd14b4ecd80"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965380683*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"99d57015-4150-4e5c-aa7b-3962728c2bbc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "106", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X106\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}]}]}],
  SequenceForm[
  106, ") ", "X106", ": ", $CellContext`a^2 ($CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965382181*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"5e6cd9b3-a35b-4dc7-92c6-5ed2b60bd86b"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965383685*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"4d3ce550-4ab3-445d-83e6-a98e94fc98d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "107", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X107\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}]}]]}],
  SequenceForm[
  107, ") ", "X107", 
   ": ", $CellContext`a^(-2)/($CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965385186*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c1a6b206-81cb-453c-abac-1ef16f598cc4"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965386983*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"8d9ade43-f274-4254-a014-f602b144e099"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "108", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X108\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["a", 
    RowBox[{
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}]]}],
  SequenceForm[
  108, ") ", "X108", 
   ": ", $CellContext`a/($CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653888807`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"8a2f81b4-385d-41ad-881f-9050a0615c3c"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653906403`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"aa29ba6d-fea4-4b9d-a6a7-efe6e926bc9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "109", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X109\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  109, ") ", "X109", 
   ": ", $CellContext`a^2 ($CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653922157`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"6c26d426-9eab-4e0b-9b1a-fb8f1bc4b356"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965393758*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"5da3e7fb-57e3-43e2-8c85-c43fedd14926"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "110", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X110\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]]}],
  SequenceForm[
  110, ") ", "X110", 
   ": ", $CellContext`a^(-2)/($CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965395257*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"8cc76e0a-636d-47d6-84eb-c41112c37550"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399653968*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"2e5f2870-d24c-48b2-97c3-0aa83a5f37f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "111", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X111\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "a"]}],
  SequenceForm[
  111, ") ", "X111", 
   ": ", $CellContext`a^(-1) ($CellContext`b^2 + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996539828*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"1807ea47-c9c2-4bae-a0c2-be0b2ab3fe79"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996539979*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"b0ba2011-ebb9-4dad-a259-aa0d1f8353ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "112", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X112\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}], ")"}]}]}],
  SequenceForm[
  112, ") ", "X112", 
   ": ", $CellContext`a ((-2) $CellContext`a + $CellContext`b + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399654012747`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"836339a4-a10a-453e-b8da-3067a93c24e5"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965403133*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"6a304bbe-9498-4481-9571-d81f49a96c60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "113", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X113\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}], ")"}]}]]}],
  SequenceForm[
  113, ") ", "X113", 
   ": ", $CellContext`a^(-1)/((-2) $CellContext`a + $CellContext`b + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399654051228`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"f0d3837d-533c-4078-9b88-3f34813bc144"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965407032*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"3de7cd00-f753-4c84-a3be-83f5fd8b1a5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "114", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X114\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["a", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}]]}],
  SequenceForm[
  114, ") ", "X114", 
   ": ", $CellContext`a/((-2) $CellContext`a + $CellContext`b + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399654224873`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"ac09a20c-8d3b-4d07-bffa-b881a78edea0"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399654244413`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"7845bab8-1c18-40e3-aca8-3b5bd44aca51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "115", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X115\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}], ")"}]}]}],
  SequenceForm[
  115, ") ", "X115", 
   ": ", $CellContext`a^2 ((-2) $CellContext`a + $CellContext`b + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965425974*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"3a24b073-1230-4934-9d12-e9cd1046dd7f"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965427556*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"73085de4-fa65-47ef-8a3f-fe9a3847fddd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "116", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X116\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}], ")"}]}]]}],
  SequenceForm[
  116, ") ", "X116", 
   ": ", $CellContext`a^(-2)/((-2) $CellContext`a + $CellContext`b + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965429125*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"d3315c2a-cd48-49a9-9fa8-3ab22eb49cf3"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965430854*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"e6c8fa86-1878-4a4d-8aab-b259ca63e73b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "117", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"X117\"\>", "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b", "+", "c", "-", 
    FractionBox[
     RowBox[{"b", " ", "c"}], "a"]}]}],
  SequenceForm[
  117, ") ", "X117", 
   ": ", $CellContext`b + $CellContext`c - $CellContext`a^(-1) $CellContext`b \
$CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965432397*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"446d802a-50ba-448b-955d-329a20912f84"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399654339314`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"1c7533d7-588b-4fff-8778-d6415e38fb95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "118", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"r-power point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   SuperscriptBox["a", "r"]}],
  SequenceForm[
  118, ") ", "r-power point", ": ", $CellContext`a^$CellContext`r],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965435451*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"b29546ba-04a1-4421-9d85-271302704d2e"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965437443*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"96d324b1-17d6-40b3-9cf9-b4fc791d354c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "119", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"r2-power point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "r"], "+", 
     SuperscriptBox["c", "r"]}], "a"]}],
  SequenceForm[
  119, ") ", "r2-power point", 
   ": ", $CellContext`a^(-1) ($CellContext`b^$CellContext`r + \
$CellContext`c^$CellContext`r)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399654393177`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"4cb39c81-1353-42f9-b2d4-912ea189916b"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965440981*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"222280cc-cac7-43d0-9ea1-94620d350aa5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "120", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"r3-power point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "r"]}], "+", 
     SuperscriptBox["b", "r"], "+", 
     SuperscriptBox["c", "r"]}], "a"]}],
  SequenceForm[
  120, ") ", "r3-power point", 
   ": ", $CellContext`a^(-1) (-$CellContext`a^$CellContext`r + \
$CellContext`b^$CellContext`r + $CellContext`c^$CellContext`r)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965442533*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"c9934314-f3ba-4d7d-ab1c-ee3367a3733e"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399654441147`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"74fa001f-7769-4e7f-abd4-d59aa8f66db8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "121", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"Z1\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "r"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}]}]}],
  SequenceForm[
  121, ") ", "Z1", 
   ": ", $CellContext`a^$CellContext`r ($CellContext`b + $CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965445669*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"eda4db63-3f9e-49f5-a2c8-8bd548738b9a"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399654472017`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"4624bda6-8ba3-4538-8a4e-fca7ade64782"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "122", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"Z2\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "r"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  122, ") ", "Z2", 
   ": ", $CellContext`a^$CellContext`r ($CellContext`b^2 + $CellContext`c^2)],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965448807*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"5e776865-b3c4-4526-ac78-b05d2baa1294"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965450419*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a8dc2e72-12c4-4a78-a203-b945411d32fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "123", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"Z3\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "r"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}]}]}],
  SequenceForm[
  123, ") ", "Z3", 
   ": ", $CellContext`a^$CellContext`r (-$CellContext`a + $CellContext`b + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399654519987`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"f65d6539-d0d1-4550-a596-91c38eab21f5"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965453825*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"9651c933-ce7f-4804-81be-081c04b427d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "124", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"Z4\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "r"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "a"}], "+", "b", "+", "c"}], ")"}]}]}],
  SequenceForm[
  124, ") ", "Z4", 
   ": ", $CellContext`a^$CellContext`r ((-2) $CellContext`a + $CellContext`b + \
$CellContext`c)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965455677*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"60352cc5-3ab8-4c95-a5a0-f2d7cd94012d"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965457406*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"2267bf23-917b-4fdf-8012-953539026d07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "125", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"Z5\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "r"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  125, ") ", "Z5", 
   ": ", $CellContext`a^$CellContext`r (-$CellContext`a^2 + $CellContext`b^2 + \
$CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965458971*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"b89064eb-ff2c-4e0c-b895-5ee58313053c"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965460504*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"3eae4d4d-26ae-4711-aaae-384ec3c7f47a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "126", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"Z6\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "r"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "3"], "+", 
      SuperscriptBox["c", "3"]}], ")"}]}]}],
  SequenceForm[
  126, ") ", "Z6", 
   ": ", $CellContext`a^$CellContext`r ($CellContext`b^3 + $CellContext`c^3)],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399654620047`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"ffb128cd-4914-4982-976e-ab7f6bef5e0c"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965463624*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"7a045eeb-0945-4555-9090-67a3d5fcbf59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "127", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"Z7\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "r"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      RowBox[{"b", " ", "c"}], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}],
  SequenceForm[
  127, ") ", "Z7", 
   ": ", $CellContext`a^$CellContext`r ($CellContext`b^2 + $CellContext`b \
$CellContext`c + $CellContext`c^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996546593*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"adc49578-a461-4a1b-85eb-8debb33fb14b"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399654677067`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"fb574810-f993-4765-8f21-8fc1f5caf2c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "128", "\[InvisibleSpace]", "\<\") \"\>", "\[InvisibleSpace]", "\<\"Z8\"\>",
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a", "r"], " ", 
    RowBox[{"g", "[", 
     RowBox[{"b", ",", "c"}], "]"}]}]}],
  SequenceForm[
  128, ") ", "Z8", 
   ": ", $CellContext`a^$CellContext`r $CellContext`g[$CellContext`b, \
$CellContext`c]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965469564*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"dde5ca0b-c99b-4ebc-97d8-7ba86dc331e7"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965471236*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"4ac41cc4-814f-4f44-874c-631177d75cce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "129", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"r4-power point\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "r"]}], "+", 
     SuperscriptBox["b", "r"], "+", 
     SuperscriptBox["c", "r"]}], "a"]}],
  SequenceForm[
  129, ") ", "r4-power point", 
   ": ", $CellContext`a^(-1) (
    2 $CellContext`a^$CellContext`r + $CellContext`b^$CellContext`r + \
$CellContext`c^$CellContext`r)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.8056399654728193`*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"a69256f4-ba12-4507-a4f2-9441e1bb5d43"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.80563996547442*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"db1f0aa5-d042-4c0a-be9a-081ac9eb98ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "130", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"arbitrary center\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"g", "[", 
      RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}],
  SequenceForm[130, ") ", "arbitrary center", ": ", 
   $CellContext`f[$CellContext`a, 
    $CellContext`g[$CellContext`b, $CellContext`c]]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965475937*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"6c0e85e7-85e4-455a-b79d-d028acc4da62"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965477611*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"206a3129-b852-4dd9-a369-d599e84b54ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "131", "\[InvisibleSpace]", "\<\") \"\>", 
   "\[InvisibleSpace]", "\<\"areal center\"\>", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], "a"]}],
  SequenceForm[
  131, ") ", "areal center", 
   ": ", $CellContext`a^(-1) $CellContext`f[$CellContext`a, $CellContext`b, \
$CellContext`c]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965479155*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"655a9a68-690d-402b-b8cf-2f0f583d6064"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"131", "\[InvisibleSpace]", "\<\" trilinear centers found.\"\>"}],
  SequenceForm[131, " trilinear centers found."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.805639055639859*^9, 3.8056390559201736`*^9}, 
   3.805639837925405*^9, 3.805639965480794*^9},
 CellLabel->
  "During evaluation of \
In[186]:=",ExpressionUUID->"4f2a2e34-6158-4ddf-aec3-6ba636add4ad"]
}, Open  ]],

Cell["\<\
ZeroQ[exp_]:=
Block[{val,expr},
\texpr = exp;
\tIf[!FreeQ[expr,r],
\t\texpr = expr/.{x_^k_ y_^k_->(x y)^k};
\t\texpr = Together[expr];
\t\tIf[!FreeQ[expr,t/a1],
\t\t\texpr = PowerExpand[expr];
\t\t\texpr = Together[expr];
\t\t  ];
\t  ];
\tIf[Head[expr]===Real,
\t\tval = Abs[N[expr,50]];
\t\tIf[val<0.000000000001,
\t\t\tPrint[\"  --> Expression \",expr,\"=\",val];
\t\t\t];
\t\t(* Return[expr==0.0]; *)
\t\tReturn[val<0.0000001];
\t  ];
\tIf[IntegerQ[expr],Return[expr==0]];
\tIf[Head[expr]===Rational,Return[False]];
\tval = Abs[N[expr,50]];
\tIf[val<0.000000000001,
\t\tPrint[\"  ----> Expression \",expr,\"=\",val];
\t\t];
\tReturn[False];
\t];

(* Finds the plane through three given points *)
PlaneThruThreePoints[p1_,p2_,p3_]:=
Block[{xx,yy,zz,ww,cx,cy,cz,cw},
\teqn = Det[{{xx,yy,zz,ww},p1,p2,p3}]//Expand;
\tcx = Coefficient[eqn,xx];
\tcy = Coefficient[eqn,yy];
\tcz = Coefficient[eqn,zz];
\tcw = Coefficient[eqn,ww];
\tReturn[{cx,cy,cz,cw}];
\t];
\t
(* Returns True if planes are parallel *)
ArePlanesParallel[p1_,p2_]:=
Block[{x1,x2,x3,x4,y1,y2,y3,y4,cond1,cond2},
\t{x1,x2,x3,x4}=p1;
\t{y1,y2,y3,y4}=p2;
\tcond1=(x1-x2)(y2-y3)-(y1-y2)(x2-x3)//Expand;
\tcond2=(x2-x3)(y3-y4)-(y2-y3)(x3-x4)//Expand;
\tIf[!ZeroQ[cond1],Return[False]];
\tIf[!ZeroQ[cond2],Return[False]];
\tReturn[True];
\t];

Coplanar[P_]:=
Block[{determ},
\tdeterm = Det[P]//Together;
\tReturn[ZeroQ[determ]];
\t];

ExactTetrahedralCoordinates[P_]:=
(* Returns coordinates scaled so that sum is 1 *)
Block[{su},
\tsu = Apply[Plus,P];
\tIf[su==0,Return[{Infty,Infty,Infty,Infty}]]; (* avoid errmsg *)
\tReturn[P/su];
\t];

SquaredDistance[A_,B_,S_]:=
(*
\tReturns the square of the distance between
\ttwo points, A and B, given in Tetrahedral Coordinates.
\tFormula from page 69 of Frost and Wolstenholme,
\tSolid Geometry. 
\tS is the square of the lengths of the 6 edges (see figure).
*)
Block[{eA,eB,
\t\tsa1,sa2,sa3,sb1,sb2,sb3,dist,d1,d2,d3,d4},
\teA = ExactTetrahedralCoordinates[A];
\teB = ExactTetrahedralCoordinates[B];
\t{sa1,sa2,sa3,sb1,sb2,sb3} = S;
\t{d1,d2,d3,d4} = eA-eB;
\tdist=
\t-d1 d2 sa3-d1 d3 sa2-d1 d4 sb1-
\t d2 d3 sa1-d2 d4 sb2-d3 d4 sb3;
\tIf[NumberQ[dist],
\t\tIf[N[dist]<0,
\t\t\tPrint[\"  --> Distance, \",dist,\" is negative.\"];
\t\t  ];
\t  ];
\tReturn[dist];
\t];
\
\>", "Input",
 InitializationCell->True,
 AspectRatioFixed->True,
 CellLabel->
  "In[195]:=",ExpressionUUID->"ced5749c-396f-4d37-a140-5c82afc0c811"],

Cell["\<\
EquationOfLine[A_,B_]:=
(*
\tFinds equation of line through 2 points
\tin tetrahedral coordinates.
\tEquation is of form
\t(x-a)/K=(y-b)/L=(z-c)/M=(w-d)/N
\twhere K+L+M+N=0.
\tWe return {K,L,M,N} where A={a,b,c,d}.
*)
Block[{eA,eB,expr,den},
\teA = ExactTetrahedralCoordinates[A];
\teB = ExactTetrahedralCoordinates[B];
\texpr = Together[eA-eB];
(*
\texpr = LowestTerms[expr];
*)
\tden = Denominator[expr[[1]]];
\texpr = Together[den * expr];
\tReturn[expr];
\t];

EquationOfPlane[A_,B_,C_]:=
(* Plane through 3 points *)
Block[{eq,cx,cy,cz,cw,xx,yy,zz,ww,expr},
\teq = Det[{{xx,yy,zz,ww},A,B,C}];
\teq = Expand[eq];
\tcx = Coefficient[eq,xx];
\tcy = Coefficient[eq,yy];
\tcz = Coefficient[eq,zz];
\tcw = Coefficient[eq,ww];
\texpr = Together[{cx,cy,cz,cw}];
\tReturn[expr];
\t];

EquationOfPlane2[P_,A_,L_]:=
(* Plane through point P and line (A,L) *)
Block[{B},
\t(* Find another point on the line *)
\tB = A + L;
\tReturn[EquationOfPlane[P,A,B]];
\t];


IntersectionOfLineAndPlane[A_,L_,Plane_]:=
(* A is point on line, L are line divisors *)
(* Point returned is in exact coordinates *)
Block[{aa,bb,rr},
\taa = A . Plane;
\tbb = L . Plane;
\tIf[bb==0,
\t\tPrint[\"  -> Line does not meet plane.\"];
\t\tReturn[{Infty,Infty,Infty,Infty}];
\t  ];
\trr = aa/bb;
\tReturn[Together[A - rr L]];
\t];

IntersectionOfPlanes[Plane1_,Plane2_]:=
(* Returns a point on the line and the direction vector *)
Block[{A1,B1,C1,D1,A2,B2,C2,D2,K,L,M,N,x0,y0,z0,w0},
\t{A1,B1,C1,D1}=Plane1;
\t{A2,B2,C2,D2}=Plane2;
\tK = B2 C1-B1 C2-B2 D1+C2 D1+B1 D2-C1 D2;
\tL = -A2 C1+A1 C2+A2 D1-C2 D1-A1 D2+C1 D2;
\tM = A2 B1-A1 B2-A2 D1+B2 D1+A1 D2-B1 D2;
\tN = -A2 B1+A1 B2+A2 C1-B2 C1-A1 C2+B1 C2;
\tx0 = (B1 C2 - B2 C1)/N;
\ty0 = (A2 C1 - A1 C2)/N;
\tz0 = (A1 B2 - A2 B1)/N;
\tw0 = 0;
\tReturn[{{x0,y0,z0,w0},{K,L,M,N}}];
\t];

DoPointsColline[A_,B_,C_]:=
Block[{tm,eA,eB,eC,
\t\tdelba1,delba2,delba3,delba4,
\t\tdelac1,delac2,delac3,delac4},
\teA = ExactTetrahedralCoordinates[A];
\teB = ExactTetrahedralCoordinates[B];
\teC = ExactTetrahedralCoordinates[C];
\t{delba1,delba2,delba3,delba4} = eB-eA;
\t{delac1,delac2,delac3,delac4} = eC-eA;
\ttm = Together[delba1 delac2-delac1 delba2];
\tIf[!ZeroQ[tm],Return[False]];
\ttm = Together[delba1 delac3-delac1 delba3];
\tIf[!ZeroQ[tm],Return[False]];
\ttm = Together[delba1 delac4-delac1 delba4];
\tIf[!ZeroQ[tm],Return[False]];
\tReturn[True];
\t];

CanSpearThreeLines[P0_,A1_,L1_,A2_,L2_,A3_,L3_]:=
(* Decides if there is a line through P0
 that meets lines (A1,L1), (A2,L2), (A3,L3). *)
Block[{planet,P1,P2,coll,P},
\tplanet = EquationOfPlane2[P0,A3,L3];
\tP1 = IntersectionOfLineAndPlane[A1,L1,planet];
\tP2 = IntersectionOfLineAndPlane[A2,L2,planet];
\tcoll = DoPointsColline[P0,P1,P2];
\tReturn[{coll,P1,P2}];
\t(* Returns answer as well as two points on spearing line *)
\t];

SquaredAreaOfTriangleFromSides[a_,b_,c_]:=
Block[{s,K},
\ts=(a+b+c)/2;
\tK=Expand[s(s-a)(s-b)(s-c)];
\tK=Together[K];
\tReturn[K];
\t];

SquaredAreaOfTriangleFromSquaredSides[a_,b_,c_]:=
Block[{K},
\tK = (2a b+2b c+2c a-a^2-b^2-c^2)/16;
\tK=Together[K];
\tReturn[K];
\t];
\t
SquaredVolumeOfTetrahedron[S_]:=
Block[{sa1,sa2,sa3,sb1,sb2,sb3,M,V},
\t{sa1,sa2,sa3,sb1,sb2,sb3} = S;
\tM = {
\t\t\t{sb1,(sb1+sb2-sa3)/2,(sb3+sb1-sa2)/2},
\t\t\t{(sb1+sb2-sa3)/2,sb2,(sb2+sb3-sa1)/2},
\t\t\t{(sb3+sb1-sa2)/2,(sb2+sb3-sa1)/2,sb3}
\t\t};
\tV=Det[M];
\tV=Together[V/36];
\tReturn[V];
\t];

CheckValidTetrahedron[S_]:=
Block[{ss,sa1,sa2,sa3,sb1,sb2,sb3,V,sc1,sc2,sc3},
\t{sa1,sa2,sa3,sb1,sb2,sb3} = S;
\tss=SquaredAreaOfTriangleFromSquaredSides[sa1,sa2,sa3];
\tIf[ss<=0,
\t\tPrint[\"-->Face of Tetrahedron has invalid area.\"];
\t\tPrint[\"   Sides: \",Sqrt[{sa1,sa2,sa3}]];
\t  ];
\t{sc1,sc2,sc3}=Sort[Sqrt[{sa1,sa2,sa3}]];
\tIf[sc1+sc2==2sc3 || sc1+sc3==2sc2,
\t\tPrint[\"-->Special case triangle (a+b=2c).\"];
\t\tPrint[\"   Sides: \",{sc1,sc2,sc3}];
\t  ];
\tss=SquaredAreaOfTriangleFromSquaredSides[sa1,sb2,sb3];
\tIf[ss<=0,
\t\tPrint[\"-->Face of Tetrahedron has invalid area.\"];
\t\tPrint[\"   Sides: \",Sqrt[{sa1,sb2,sb3}]];
\t  ];
\t{sc1,sc2,sc3}=Sort[Sqrt[{sa1,sb2,sb3}]];
\tIf[sc1+sc2==2sc3 || sc1+sc3==2sc2,
\t\tPrint[\"-->Special case triangle (a+b=2c).\"];
\t\tPrint[\"   Sides: \",{sc1,sc2,sc3}];
\t  ];
\tss=SquaredAreaOfTriangleFromSquaredSides[sb1,sa2,sb3];
\tIf[ss<=0,
\t\tPrint[\"-->Face of Tetrahedron has invalid area.\"];
\t\tPrint[\"   Sides: \",Sqrt[{sb1,sa2,sb3}]];
\t  ];
\t{sc1,sc2,sc3}=Sort[Sqrt[{sb1,sa2,sb3}]];
\tIf[sc1+sc2==2sc3 || sc1+sc3==2sc2,
\t\tPrint[\"-->Special case triangle (a+b=2c).\"];
\t\tPrint[\"   Sides: \",{sc1,sc2,sc3}];
\t  ];
\tss=SquaredAreaOfTriangleFromSquaredSides[sb1,sb2,sa3];
\tIf[ss<=0,
\t\tPrint[\"-->Face of Tetrahedron has invalid area.\"];
\t\tPrint[\"   Sides: \",Sqrt[{sb1,sb2,sa3}]];
\t  ];
\t{sc1,sc2,sc3}=Sort[Sqrt[{sb1,sb2,sa3}]];
\tIf[sc1+sc2==2sc3 || sc1+sc3==2sc2,
\t\tPrint[\"-->Special case triangle (a+b=2c).\"];
\t\tPrint[\"   Sides: \",{sc1,sc2,sc3}];
\t  ];
\tV = SquaredVolumeOfTetrahedron[S];
\tIf[V<=0,Print[\"-->Tetrahedron has invalid volume: \",V,\".\"]];
\t];

LowestTerms[exp_]:=
Block[{de,gg,expr},
\texpr = Together[exp];
\tde=Denominator[expr];
\tgg=Apply[PolynomialLCM,de];
\texpr=Together[gg expr];
\tgg=Apply[PolynomialGCD,expr];
\texpr=Together[expr/gg];
\tReturn[expr];
\t];

RemoveCommonFactors[exp_]:=
Block[{de,gg,expr},
\texpr = Together[exp];
\tgg=Apply[PolynomialGCD,expr];
\texpr=Together[expr/gg];
\tReturn[expr];
\t];

SamePoints[P1_,P2_]:=
Block[{x1,y1,z1,w1,x2,y2,z2,w2},
\t{x1,y1,z1,w1} = P1;
\t{x2,y2,z2,w2} = P2;
\tIf[!ZeroQ[Together[x1 y2-y1 x2]],Return[False]];
\tIf[!ZeroQ[Together[y1 z2-z1 y2]],Return[False]];
\tIf[!ZeroQ[Together[z1 w2-w1 z2]],Return[False]];
\tReturn[True];
\t];

PlaneThruLineParallelToLine[A1_,L1_,A2_,L2_]:=
(* Finds equation of plane through line (A1,L1)
\tthat is parallel to line (A2,L2).
\tIt returns {A,B,C,D}. *)
Block[{eq,A,B,C,D,xx,yy,zz,ww},
\teq = Det[{{xx,yy,zz,ww},A1,L1,L2}];
\teq = Expand[eq];
\tA = Coefficient[eq,xx];
\tB = Coefficient[eq,yy];
\tC = Coefficient[eq,zz];
\tD = Coefficient[eq,ww];
\tReturn[{A,B,C,D}];
\t];

CenterOfHyperboloid[P1_,L1_,P2_,L2_,P3_,L3_]:=
Block[{PL1,PL2,X1,X2},
\tPL1 = PlaneThruLineParallelToLine[P1,L1,P2,L2];
\tX1 = IntersectionOfLineAndPlane[P3,L3,PL1];
\tPL2 = PlaneThruLineParallelToLine[P1,L1,P3,L3];
\tX2 = IntersectionOfLineAndPlane[P2,L2,PL2];
\tReturn[Together[(X1+X2)/2]];
\t];

CheckIfCenter[P_,centers_]:=
Block[{i},
\tFor[i=1,i<=numberOfTetrCenters,i++,
\t\tIf[SamePoints[P,centers[i]],
\t\t\tPrint[\"    Point coincides with \",
\t\t\t\ttetrCenterName[i],\" of tetrahedron.\"];
\t\t  ];
\t\t];
\t];

CheckIfOnEuler[name_,centers_,P_]:=
Block[{loc,OGx,OPx},
\tIf[DoPointsColline[P,centers[1],centers[2]],
\t\tOGx = ExactTetrahedralCoordinates[centers[2]][[1]]
\t\t\t\t- ExactTetrahedralCoordinates[centers[1]][[1]];
\t\tIf[OGx=!=0,
\t\t\tOPx = ExactTetrahedralCoordinates[centers[2]][[1]]
\t\t\t\t- ExactTetrahedralCoordinates[P][[1]];
\t\t\tloc = Simplify[OPx/OGx];
\t\t\tPrint[\"    \",name,\" lies on reference Euler line (at \",
\t\t\t\t(* InputForm[loc] *) loc,\").\"];
\t\t  ];
\t   ];
\t];

\
\>", "Input",
 InitializationCell->True,
 AspectRatioFixed->True,
 CellLabel->
  "In[209]:=",ExpressionUUID->"ceaca7e7-6ed5-4628-8cfd-15034dd504cd"],

Cell["\<\
(* Property 1: The Pi are coplanar. *)
CheckProperty1[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{cop},
\tcop = Coplanar[P];
\tIf[debug,
\t\tPrint[\"cop=\",cop];
\t\tPrint[\"P=\",P];
\t  ];
\tIf[!cop,Return[False]];
\tIf[!numeric,
\t\tIf[ShowEquationOfPlanes,
\t\t\t(* Output equation of plane *)
\t\t\tPrint[\"    Equation of plane is:\"];
\t\t\tPrint[\"    \",Factor[EquationOfPlane[P[[1]],P[[2]],P[[3]]]]];
\t\t  ];
\t  ];
\tReturn[True];
\t];

(* Property 2: Plane of PiPjPk || Plane of AiAjAk *)
CheckProperty2[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{par1,par2,par3,par4,par},
\tAPlane[1] = PlaneThruThreePoints[A[[2]],A[[3]],A[[4]]];
\tAPlane[2] = PlaneThruThreePoints[A[[3]],A[[4]],A[[1]]];
\tAPlane[3] = PlaneThruThreePoints[A[[4]],A[[1]],A[[2]]];
\tAPlane[4] = PlaneThruThreePoints[A[[1]],A[[2]],A[[3]]];
\tPPlane[1] = PlaneThruThreePoints[P[[2]],P[[3]],P[[4]]];
\tPPlane[2] = PlaneThruThreePoints[P[[3]],P[[4]],P[[1]]];
\tPPlane[3] = PlaneThruThreePoints[P[[4]],P[[1]],P[[2]]];
\tPPlane[4] = PlaneThruThreePoints[P[[1]],P[[2]],P[[3]]];
\tpar1 = ArePlanesParallel[APlane[1],PPlane[1]];
\tpar2 = ArePlanesParallel[APlane[2],PPlane[2]];
\tpar3 = ArePlanesParallel[APlane[3],PPlane[3]];
\tpar4 = ArePlanesParallel[APlane[4],PPlane[4]];
\tpar = par1 && par2 && par3 && par4;
\tIf[par,Return[True],
\t\tIf[par1 || par2 || par3 || par4,
\t\t\tPrint[\"  --> Some faces are parallel.\"];
\t\t  ];
\t  ];
\tReturn[False];
\t];
\t
(* Assuming lines AB and CD meet, this finds the intersection point *)
IntersectionOfLines[A_,B_,C_,D_]:=
Block[{sa1,sa2,sa3,sa4,sb1,sb2,sb3,sb4,
\t   sc1,sc2,sc3,sc4,sd1,sd2,sd3,sd4,
\t   p1,p2,p3,p4,pt,L,Plane,
\t   nu,de,gg},
\tPlane=EquationOfPlane[A,B,{10,12,13,15}];
\tL=EquationOfLine[C,D];
\tpt=IntersectionOfLineAndPlane[C,L,Plane];
\tde=Denominator[pt];
\tgg=Apply[PolynomialLCM,de];
\tpt=Together[gg pt];
\tgg=Apply[PolynomialGCD,pt];
\tpt=Together[pt/gg];
\tReturn[Factor[pt]];
\t];

(* Property 3: Cevians AiPi concur *)
CheckProperty3[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{meet12,meet23,meet34,meet41,meet,cev,i},
\tIf[debug,
\t\tPrint[\"A=\",A];
\t\tPrint[\"P=\",P];
\t  ];
\tmeet12=Coplanar[{A[[1]],P[[1]],A[[2]],P[[2]]}];
\tIf[debug,Print[\"meet12=\",meet12]];
\tmeet23=Coplanar[{A[[2]],P[[2]],A[[3]],P[[3]]}];
\tIf[debug,Print[\"meet23=\",meet23]];
\tmeet34=Coplanar[{A[[3]],P[[3]],A[[4]],P[[4]]}];
\tIf[debug,Print[\"meet34=\",meet34]];
\tmeet41=Coplanar[{A[[4]],P[[4]],A[[1]],P[[1]]}];
\tIf[debug,Print[\"meet41=\",meet41]];
\tmeet = meet12 && meet23 && meet34 && meet41;
\tIf[meet,
\t\tcev=IntersectionOfLines[A[[1]],P[[1]],A[[2]],P[[2]]];
\t\tIf[!numeric || debug,
\t\t\tPrint[\"    Coordinates of intersection point:  \",Factor[cev]];
\t\t  ];
\t\t(* See if intersection point is a tetrahedron center *)
\t\tIf[!numeric,
\t\t\tCheckIfCenter[cev,centers];
\t  \t\tCheckIfOnEuler[\"Intersection point\",centers,cev];
\t  \t  ];
\t\tReturn[True],
\t(* else *)
\t\tIf[meet12 || meet23 || meet34 || meet41,
\t\t\tPrint[\"  --> Some cevians meet.\"];
\t\t  ];
\t  ];
\tReturn[False];
\t];

(* Property 4: Cevians AiPi have same length *)
CheckProperty4[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{d1,d2,d3,d4,z1,z2,z3,z4,eq},
\td1 = SquaredDistance[A[[1]],P[[1]],S];
\td2 = SquaredDistance[A[[2]],P[[2]],S];
\td3 = SquaredDistance[A[[3]],P[[3]],S];
\td4 = SquaredDistance[A[[4]],P[[4]],S];
\tIf[debug,
\t\tPrint[\"S=\",S];
\t\tPrint[\"A1=\",A[[1]]];
\t\tPrint[\"A2=\",A[[2]]];
\t\tPrint[\"A3=\",A[[3]]];
\t\tPrint[\"A4=\",A[[4]]];
\t\tPrint[\"P1=\",P[[1]]];
\t\tPrint[\"P2=\",P[[2]]];
\t\tPrint[\"P3=\",P[[3]]];
\t\tPrint[\"P4=\",P[[4]]];
\t\tPrint[\"d1=\",d1];
\t\tPrint[\"d2=\",d2];
\t\tPrint[\"d3=\",d3];
\t\tPrint[\"d4=\",d4];
\t  ];
\tz1 = ZeroQ[Together[d1-d2]];
\tz2 = ZeroQ[Together[d2-d3]];
\tz3 = ZeroQ[Together[d3-d4]];
\tz4 = ZeroQ[Together[d4-d1]];
\teq = z1 && z2 && z3 && z4;
\tIf[eq,Return[True],
\t\tIf[z1 || z2 || z3 || z4,
\t\t\tPrint[\"  --> Some cevians have same length.\"];
\t\t  ];
\t  ];
\tReturn[False];
\t];

(* Property 5: Tetrahedron formed by Pi is isosceles *)
CheckProperty5[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{d1,d2,d3,c1,c2,c3,z1,z2,z3,eq,u1,u2},
\tIf[debug,
\t\tPrint[\"Facial points:\"];
\t\tPrint[\"  P1 = \",P[[1]]];
\t\tPrint[\"  P2 = \",P[[2]]];
\t\tPrint[\"  P3 = \",P[[3]]];
\t\tPrint[\"  P4 = \",P[[4]]];
\t\tPrint[\"Sides squared:\"];
\t\tPrint[\"  S1 = \",S[[1]]];
\t\tPrint[\"  S2 = \",S[[2]]];
\t\tPrint[\"  S3 = \",S[[3]]];
\t\tPrint[\"  S4 = \",S[[4]]];
\t\tPrint[\"  S5 = \",S[[5]]];
\t\tPrint[\"  S6 = \",S[[6]]];
\t  ];
\t{c1,c2,c3,d1,d2,d3} = SD;
\tIf[debug,
\t\tPrint[\"Squared lengths:\"];
\t\tPrint[\"c1 = \",c1];
\t\tPrint[\"c2 = \",c2];
\t\tPrint[\"c3 = \",c3];
\t\tPrint[\"d1 = \",d1];
\t\tPrint[\"d2 = \",d2];
\t\tPrint[\"d3 = \",d3];
\t\t];
\tz1 = ZeroQ[Together[d1-c1]];
\tz2 = ZeroQ[Together[d2-c2]];
\tz3 = ZeroQ[Together[d3-c3]];
\teq = z1 && z2 && z3;
\tIf[eq,
\t\t(* See if regular *)
\t\tu1 = ZeroQ[Together[c2-c1]];
\t\tu2 = ZeroQ[Together[c3-c1]];
\t\tIf[u1 && u2,
\t\t\tPrint[\"  Tetrahedron is regular.\"],
\t\t(* else *)
\t\t\tIf[u1 || u2,
\t\t\t\tPrint[\"  --> 4 of 6 edges have same length.\"];
\t\t\t  ];
\t\t  ];
\t\tReturn[True],
\t(* else *)
\t\tIf[z1 || z2 || z3,
\t\t\tPrint[\"  --> Some pairs of edges have same length.\"];
\t\t  ];
\t  ];
\tReturn[False];
\t];

(* Property 6: Tetrahedron formed by Pi is isodynamic *)
CheckProperty6[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{d1,d2,d3,c1,c2,c3,z1,z2,eq},
\t{c1,c2,c3,d1,d2,d3} = SD;
\tz1 = ZeroQ[Together[d1 c1 - d2 c2]];
\tz2 = ZeroQ[Together[d2 c2 - d3 c3]];
\teq = z1 && z2;
\tIf[eq,Return[True],
\t\tIf[z1 || z2,
\t\t\tPrint[\"  --> Some pairs of edges have same product.\"];
\t\t  ];
\t  ];
\tReturn[False];
\t];

(*
SqCond[a_,b_,c_,d_]:=
\tTogether[(a^2+b^2+c^2+d^2-2a b-2a c-2a d-2b c-2b d-2c d)^2-
\t64 a b c d];
*)

(* Property 7: Tetrahedron formed by Pi is circumscriptible *)
CheckProperty7[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{d1,d2,d3,c1,c2,c3,z1,z2,eq},
(*
\tThe condition Sqrt[a]+Sqrt[b]==Sqrt[c]+Sqrt[d]
\tis almost equivalent to the condition:
\t64abcd==(2ab+2bc+2cd+2ac+2ad+2bd-a^2-b^2-c^2-d^2)^2.
\t[Actually, sum of some 2 = sum of other 2.]
\tSo not good enough.

\tz1 = ZeroQ[SqCond[c1,d1,c2,d2]];
\tz2 = ZeroQ[SqCond[c2,d2,c3,d3]];
*)

\t{c1,c2,c3,d1,d2,d3} = (Sqrt[SD])/.{Sqrt[x_^2]:>x};

\tz1 = ZeroQ[Together[d1 + c1 - d2 - c2]];
\tz2 = ZeroQ[Together[d2 + c2 - d3 - c3]];

\tIf[debug,
\t\tPrint[\"z1=\",z1];
\t\tPrint[\"z2=\",z2];
\t  ];
\teq = z1 && z2;
\tIf[eq,Return[True],
\t\tIf[z1 || z2,
\t\t\tPrint[\"  --> Some pairs of edges have same sum.\"];
\t\t  ];
\t  ];
\tReturn[False];
\t];
\t
(* Property 8: Tetrahedron formed by Pi is orthocentric *)
CheckProperty8[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{d1,d2,d3,c1,c2,c3,z1,z2,cond1,cond2,eq},
\t{c1,c2,c3,d1,d2,d3} = SD;
\tcond1 = Together[d1 + c1 - d2 - c2];
\tcond2 = Together[d2 + c2 - d3 - c3];
\tz1 = ZeroQ[cond1];
\tz2 = ZeroQ[cond2];
\tIf[debug,
\t\tPrint[\"c1 = \",c1];
\t\tPrint[\"c2 = \",c2];
\t\tPrint[\"c3 = \",c3];
\t\tPrint[\"d1 = \",d1];
\t\tPrint[\"d2 = \",d2];
\t\tPrint[\"d3 = \",d3];
\t\tPrint[\"cond1=\",cond1];
\t\tPrint[\"cond2=\",cond2];
\t\tPrint[\"z1 = \",z1];
\t\tPrint[\"z2 = \",z2];
\t\t];
\teq = z1 && z2;
\tIf[eq,Return[True],
\t\tIf[z1 || z2,
\t\t\tPrint[\"  --> Some pairs of edges are perpendicular.\"];
\t\t  ];
\t  ];
\tReturn[False];
\t];

(* Property 9: Cevial tetrahedron has same centroid as original tetrahedron \
*)
CheckProperty9[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{M,meet12,meet23,meet34,meet},
\tM=P[[1]]+P[[2]]+P[[3]]+P[[4]];
\tmeet12=ZeroQ[Together[M[[1]]-M[[2]]]];
\tmeet23=ZeroQ[Together[M[[2]]-M[[3]]]];
\tmeet34=ZeroQ[Together[M[[3]]-M[[4]]]];
\tmeet = meet12 && meet23 && meet34;
\tIf[meet,Return[True]];
\tReturn[False];
\t];

(* Property 10: Cevians form a hyperbolic group *)
CheckProperty10[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{P1,P2,P3,spear,wantSpears,x2,x3,y1,y3,z1,z2,cond,
\t\tHcenter,A1,A2,A3},
\twantSpears = False;
\twantHyperboloidCenters = False;
\tP1=P[[1]];
\tP2=P[[2]];
\tP3=P[[3]];
\ty1 = P1[[2]];
\tz1 = P1[[3]];
\tx2 = P2[[1]];
\tz2 = P2[[3]];
\tx3 = P3[[1]];
\ty3 = P3[[2]];
\t(* Symmetry conditions show we need only spear one set *)
\tcond = Together[z1 x2 y3 - y1 z2 x3];
\tspear = ZeroQ[cond];
\tIf[debug,
\t\tPrint[\"Condition is: \",cond];
\t  ];
\tIf[spear,
\t\tIf[!numeric && wantSpears,
\t\t\tPrint[\"  Spear line meets base at:\"];
\t\t\tPrint[\"  \",Factor[{x3 y1,y1 y3,y3 z1}]];
\t\t  ];
\t\tIf[wantHyperboloidCenters,
\t\t\tP1 = ExactTetrahedralCoordinates[P1];
\t\t\tP2 = ExactTetrahedralCoordinates[P2];
\t\t\tP3 = ExactTetrahedralCoordinates[P3];
\t\t\tA1 = A[[1]];
\t\t\tA2 = A[[2]];
\t\t\tA3 = A[[3]];
\t\t\tIf[!numeric,
\t\t\t\tPrint[\"  Center of hyperboloid:\"];
\t\t\t  ];
\t\t\tHcenter = CenterOfHyperboloid[A1,P1-A1,A2,P2-A2,A3,P3-A3];
\t\t\tHcenter = LowestTerms[Hcenter];
\t\t\tIf[!numeric,
\t\t\t\tPrint[\"  \",Factor[Hcenter]];
\t\t\t  ];
\t\t\tIf[!numeric,
\t\t\t\tCheckIfCenter[Hcenter,centers];
\t  \t\t\tCheckIfOnEuler[\"Center of hyperboloid\",centers,Hcenter];
\t  \t\t  ];
\t\t  ];
\t\tReturn[True];
\t  ];
\tReturn[False];
\t];

(* Property 11: The Pi are collinear. *)
CheckProperty11[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{coline1,coline2,P1,P2,P3,P4},
\t{P1,P2,P3,P4} = P;
\tcoline1 = DoPointsColline[P1,P2,P3];
\tcoline2 = DoPointsColline[P1,P2,P4];
\tIf[coline1 && coline2,
\t\tIf[!numeric,
\t\t\tIf[ShowEquationOfLines,
\t\t\t\t(* Print equation of line *)
\t\t\t\tPrint[\"    Equation of line is:\"];
\t\t\t\tPrint[\"    \",Factor[P[[1]]]];
\t\t\t\tPrint[\"    \",Factor[EquationOfLine[P[[1]],P[[2]]]]];
\t\t\t  ];
\t\t  ];
\t\tReturn[True],
\t(* else *)
\t\tIf[coline1 || coline2,
\t\t  Print[\"  --> 3 of 4 points colline.\"];
\t\t  ];
\t  ];
\tReturn[False];
\t];

(* Property 12: The tetrahedra are similar. *)
CheckProperty12[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{sa1,sa2,sa3,sb1,sb2,sb3,c1,c2,c3,d1,d2,d3,val},
\t{sa1,sa2,sa3,sb1,sb2,sb3} = S;
\t{c1,c2,c3,d1,d2,d3} = SD;
\tIf[debug,
\t\tPrint[\"S=\",S];
\t\tPrint[\"SD=\",SD];
\t  ];
\tval = sa1 c2 - sa2 c1;
\tIf[!ZeroQ[val],Return[False]];
\tval = sa1 c3 - sa3 c1;
\tIf[!ZeroQ[val],Return[False]];
\tval = sa1 d1 - sb1 c1;
\tIf[!ZeroQ[val],Return[False]];
\tval = sa1 d2 - sb2 c1;
\tIf[!ZeroQ[val],Return[False]];
\tval = sa1 d3 - sb3 c1;
\tIf[!ZeroQ[val],Return[False]];
\tReturn[True];
\t];

(* Property 13: Find conditions for Cevians AiPi to concur *)
CheckProperty13[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{meet12,meet23,meet34,meet41,meet},
\tIf[numeric,masterCondition={};Return[True]];
\tIf[debug,
\t\tPrint[\"A=\",A];
\t\tPrint[\"P=\",P];
\t  ];
\tmeet12=Det[{A[[1]],P[[1]],A[[2]],P[[2]]}];
\tIf[debug,Print[\"meet12=\",meet12]];
\tPrint[Factor[meet12]==0];
\tmasterCondition = Append[masterCondition,
\t\t\t\t\t\tFactor[meet12]==0];
\tmeet23=Det[{A[[2]],P[[2]],A[[3]],P[[3]]}];
\tIf[debug,Print[\"meet23=\",meet23]];
\tPrint[Factor[meet23]==0];
\tmasterCondition = Append[masterCondition,
\t\t\t\t\t\tFactor[meet23]==0];
\tmeet34=Det[{A[[3]],P[[3]],A[[4]],P[[4]]}];
\tIf[debug,Print[\"meet34=\",meet34]];
\tPrint[Factor[meet34]==0];
\tmasterCondition = Append[masterCondition,
\t\t\t\t\t\tFactor[meet34]==0];
\tmeet41=Det[{A[[4]],P[[4]],A[[1]],P[[1]]}];
\tIf[debug,Print[\"meet41=\",meet41]];
\tPrint[Factor[meet41]==0];
\tReturn[True];
\t];

(* Property 14: Find condition for Pi to be coplanar. *)
CheckProperty14[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{determ},
\tIf[numeric,Return[True]];
\tIf[debug,
\t\tPrint[\"P=\",P];
\t  ];
\tdeterm = Det[P]//Together;
\tIf[debug,
\t\tPrint[\"det=\",determ];
\t  ];
(*\tmasterCondition = (Factor[determ]==0); *)
\tmasterCondition = determ;
\tReturn[True];
\t];

(* Property 15: Find condition for Cevial tetrahedron
to have same centroid as original tetrahedron *)
CheckProperty15[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{M,meet12,meet23,meet34,meet},
\tIf[numeric,masterCondition={};Return[True]];
\tM=P[[1]]+P[[2]]+P[[3]]+P[[4]];
\tmeet12=Together[M[[1]]-M[[2]]];
\tmeet23=Together[M[[2]]-M[[3]]];
\tmeet34=Together[M[[3]]-M[[4]]];
\tmasterCondition = Append[masterCondition,
\t\t\t\t\t\tFactor[meet12]==0];
\tmasterCondition = Append[masterCondition,
\t\t\t\t\t\tFactor[meet23]==0];
\tmasterCondition = Append[masterCondition,
\t\t\t\t\t\tFactor[meet34]==0];
\tReturn[True];
\t];

(* Property 16: Find conditions for Cevians to be hyperbolic. *)
CheckProperty16[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{P1,P2,P3,x2,x3,y1,y3,z1,z2,cond},
\tIf[numeric,Return[True]];
\tP1=P[[1]];
\tP2=P[[2]];
\tP3=P[[3]];
\ty1 = P1[[2]];
\tz1 = P1[[3]];
\tx2 = P2[[1]];
\tz2 = P2[[3]];
\tx3 = P3[[1]];
\ty3 = P3[[2]];
\t(* Symmetry conditions show we need only spear one set *)
\tcond = Together[z1 x2 y3 - y1 z2 x3];
\tcond = Factor[cond];
\tmasterCondition = cond;
\tPrint[masterCondition];
\tReturn[True];
\t];

perp[V1_,V2_,S_]:=
Block[{K1,L1,M1,N1,K2,L2,M2,N2,sa1,sa2,sa3,sb1,sb2,sb3},
\t{K1,L1,M1,N1}=V1;
\t{K2,L2,M2,N2}=V2;
\t{sa1,sa2,sa3,sb1,sb2,sb3} = S;
\tReturn[
\tsa1(L1 M2+L2 M1)+sa2(K1 M2+K2 M1)+sa3(K1 L2+K2 L1)+
\tsb1(K1 N2+K2 N1)+sb2(L1 N2+L2 N1)+sb3(M1 N2+M2 N1)];
\t];

(* Property 17: Erected normals concur *)
CheckProperty17[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{q1,q2,P1,P2,P3,P4,A1,A2,A3,A4,Q,meet,u,X,Y,Z,W,ans,eP1,eP2},
\t(*
\t\tNeed (P1A4)^2+(P2A3)^2=(P1A3)^2+(P2A4)^2.
\t*)
\t{P1,P2,P3,P4} = P;
\t{A1,A2,A3,A4} = A;
\tq1 = SquaredDistance[P1,A4,S]+SquaredDistance[P2,A3,S];
\tIf[!FreeQ[q1,Infty],Return[False]];
\tq2 = SquaredDistance[P1,A3,S]+SquaredDistance[P2,A4,S];
\tIf[debug,
\t\tPrint[\"q1=\",q1];
\t\tPrint[\"q2=\",q2];
\t  ];
\tmeet = ZeroQ[Together[q1-q2]];
\tIf[meet,
\t\t(* Find point where normals at P1 and P2 meet *)
\t\tIf[!numeric || True,
\t\t\tu={X,Y,Z,W};
\t\t\teP1=ExactTetrahedralCoordinates[P1];
\t\t\teP2=ExactTetrahedralCoordinates[P2];
\t\t\teq1=perp[u-eP1,eP1-A2,S];
\t\t\teq2=perp[u-eP1,eP1-A3,S];
\t\t\teq3=perp[u-eP2,eP2-A3,S];
\teq1=Collect[eq1,{X,Y,Z,W},Simplify];
\teq2=Collect[eq2,{X,Y,Z,W},Simplify];
\teq3=Collect[eq3,{X,Y,Z,W},Simplify];
\t(* Print[\"Solving...\",eq1]; *)
\t\t\tans=Solve[{eq1==0,eq2==0,eq3==0,X+Y+Z+W==1},{X,Y,Z,W}];
\t\t\tans = First[ans];
\t\t\t{X,Y,Z,W}={X,Y,Z,W}/.ans;
\t(* Print[\"W=\",W]; *)
\t\t\t{X,Y,Z,W} = LowestTerms[{X,Y,Z,W}];
\t\t\tQ = {X,Y,Z,W};
\t\t\tIf[!numeric,
\t\t\t\tCheckIfCenter[Q,centers];
\t  \t\t\tCheckIfOnEuler[\"Intersection point\",centers,Q];
\t  \t\t  ];
\t  \t\tIf[!numeric,
\t\t\t\tPrint[\"    4th coordinate of point of intersection is:\"];
\t\t\t\tPrint[\"    \",Factor[W]];
\t\t\t  ];
\t\t  ];
\t\tReturn[True];
\t  ];
\tReturn[False];
\t];

(* Property 18: Some center of central tetrahedron
\tcoincides with a center of the reference tetrahedron. *)
CheckProperty18[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{P1,P2,P3,P4,x2,x3,y1,y3,z1,z2,cond,i,j,
\tcoinc,coincide,used,Pcenter,OGx,OPx,loc},
\tcoincide = False;
\t{P1,P2,P3,P4}=P;
\tIf[debug,Print[\"P=\",P]];
\tFor[j=1,j<=numberOfTetrCenters,j++,used[j]=False];
\tOGx = 0;
\t(* Find centers of central tetrahedron *)
\tFor[i=1,i<=numberOfTetrCenters,i++,
\t\tcoinc[i] = False;
\t\tIf[debug,Print[\"Looking at center \",i]];
\t\tPcenter[i] = centers[i] . P;
\t\tIf[debug,Print[\"  Pcenter=\",Pcenter[i]]];
\t\t(* See if any center of ref tetr is same as one of these *)
\t\tFor[j=1,j<=numberOfTetrCenters,j++,
\t\tIf[debug,Print[\"  Comparing with center \",j]];
\t\tIf[debug,Print[\"  center=\",centers[j]]];
\t\t\tIf[SamePoints[Pcenter[i],centers[j]],
\t\t\t\tIf[!numeric,
\t\t\t\t\tPrint[\"    Central \",tetrCenterName[i],
\t\t\t\t\t\t\" coincides with reference \",
\t\t\t\t\t\ttetrCenterName[j],\".\"];
\t\t\t\t  ];
\t\t\t\tcoincide = True;
\t\t\t\tcoinc[i] = True;
\t\t\t\tused[j]  = True;
\t\t\t\tBreak[];
\t\t\t  ];
\t\t\t];
\t\tIf[!coinc[i] && !numeric,
\t\t\t(* See if Pcenter lies on Euler line *)
\t  \t\tCheckIfOnEuler[\"Central \"<>tetrCenterName[i],
\t  \t\t\tcenters,Pcenter[i]];
\t\t  ];
\t\t];
\tFor[i=1,i<=numberOfTetrCenters,i++,
\t  If[!used[i] && !numeric,
\t\tIf[DoPointsColline[centers[i],Pcenter[1],Pcenter[2]],
\t\t\tOGx = ExactTetrahedralCoordinates[Pcenter[2]][[1]]
\t\t\t\t- ExactTetrahedralCoordinates[Pcenter[1]][[1]];
\t\t\tOPx = ExactTetrahedralCoordinates[Pcenter[2]][[1]]
\t\t\t\t- ExactTetrahedralCoordinates[centers[i]][[1]];
\t\t\tIf[debug,
\t\t\t\tPrint[\"i=\",i,\"  Points colline. Pcenter1=\",
\t\t\t\t\t\tPcenter[1],\" Pcenter2=\",Pcenter[2]];
\t\t\t\tPrint[\"centers[i]=\",centers[i]];
\t\t\t\tPrint[\"OGx=\",OGx,\"  OPx=\",OPx];
\t\t\t  ];
\t\t\t(* There is no Euler line for an isosceles tetrahedron *)
\t\t\tIf[Simplify[OGx]=!=0,
\t\t\t\tloc = Simplify[OPx/OGx];
\t\t\t\tPrint[\"    Reference \",tetrCenterName[i],
\t\t\t\t\t\" lies on central Euler line (at \",
\t\t\t\t\t(* InputForm[loc] *) loc,\").\"];
\t\t\t  ];
\t\t  ];
\t\t];
\t   ];
\tReturn[coincide];
\t];

(* Property 19: Find condition for Pi to be collinear. *)
CheckProperty19[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{P1,P2,P3,P4,Q},
\tIf[numeric,Return[True]];
\tIf[debug,
\t\tPrint[\"P=\",P];
\t  ];
\t{P1,P2,P3,P4}=P;
\tQ = (P2-P1)/(P3-P1);
\tQ = Q - Q[[1]];
\tQ = Drop[Q,1];
\tQ = Together[Q];
\tQ = Numerator[Q];
\tmasterCondition = Q==0;
\tPrint[masterCondition];
\tReturn[True];
\t];

(* Property 20: Find condition normals at Pi to concur. *)
CheckProperty20[A_,P_,S_,SD_,debug_,numeric_,centers_]:=
Block[{P1,P2,P3,P4,Q,q1,q2,A1,A2,A3,A4},
\tIf[numeric,Return[True]];
\t(*
\t\tCondition is (P1A4)^2+(P2A3)^2==(P1A3)^2+(P2A4)^2.
\t*)
\t{P1,P2,P3,P4} = P;
\t{A1,A2,A3,A4} = A;
\tq1 = SquaredDistance[P1,A4,S]+SquaredDistance[P2,A3,S];
\tq2 = SquaredDistance[P1,A3,S]+SquaredDistance[P2,A4,S];
\tIf[debug,
\t\tPrint[\"q1=\",q1];
\t\tPrint[\"q2=\",q2];
\t  ];
\tQ = Together[q1-q2];
\tQ = Numerator[Q];
\tmasterCondition = (Q==0);
\tPrint[masterCondition];
\tReturn[True];
\t];

\t\
\>", "Input",
 InitializationCell->True,
 AspectRatioFixed->True,
 CellLabel->
  "In[247]:=",ExpressionUUID->"c6e32e54-0604-467d-a964-2984f98c1d1e"],

Cell["\<\
CheckProperties[A_,P_,NumConditions_,GenConditions_,
\t\ttestList_,debugList_,debug_,numericCheckOnly_]:=
Block[{ok,numericOk,
\t\tcaseNames,values,S0,S1,SD0,SD1,
\t\tdoAllTests,doAllDebug,gc},
\tP1 = P/.GenConditions;
\tP0 = P1/.NumConditions;
\tP1=Simplify[P1/.{t->100}];  (* can scale tetrahedron to make t=100 *)
\tP0=Sqrt3Simp[P0];
\tgc = Apply[Plus,P0];
\tIf[IntegerQ[gc],
\t\tgc = Apply[GCD,P0];
\t\tIf[gc>1,P0=P0/gc];
\t  ];
\tS1 = {a1^2,a2^2,a3^2,b1^2,b2^2,b3^2}/.GenConditions;
\tS0 = S1/.NumConditions;
\tS1=S1/.t->100;
\tS0=Sqrt3Simp[S0];
\tSD0 = {
\t\t\tSquaredDistance[P0[[2]],P0[[3]],S0],
\t\t\tSquaredDistance[P0[[3]],P0[[1]],S0],
\t\t\tSquaredDistance[P0[[1]],P0[[2]],S0],
\t\t\tSquaredDistance[P0[[4]],P0[[1]],S0],
\t\t\tSquaredDistance[P0[[4]],P0[[2]],S0],
\t\t\tSquaredDistance[P0[[4]],P0[[3]],S0]
\t\t  };
\tIf[!numericCheckOnly,
\t  SD1 = {
\t\t\tSquaredDistance[P1[[2]],P1[[3]],S1],
\t\t\tSquaredDistance[P1[[3]],P1[[1]],S1],
\t\t\tSquaredDistance[P1[[1]],P1[[2]],S1],
\t\t\tSquaredDistance[P1[[4]],P1[[1]],S1],
\t\t\tSquaredDistance[P1[[4]],P1[[2]],S1],
\t\t\tSquaredDistance[P1[[4]],P1[[3]],S1]
\t\t    };
\t  ];
\tcaseNames = False; (* set to True to print case names *)
\tvalues = False; (* set to True to print sample values *)

\t(* Make sure that the numerical tetrahedron exists *)
\tCheckValidTetrahedron[S0];

\tIf[!skipTetrCenters,
\t\t{numCentroid,numCircumcenter,
\t\tnumMongePoint,numIncenter,numEulerPoint} =
\t\t\t{ourCentroid,ourCircumcenter,
\t\t \tourMongePoint,ourIncenter,ourEulerPoint}/.NumConditions;
\t  ];
\t
\tnumberOfTests = 20;
\t
\tdoAllDebug = debug;

\tdoAllTests = Length[testList]==0;
\tFor[test=1, test<=numberOfTests, test++,
\t\tdoTest[test] = MemberQ[testList,test];
\t\tdoDebug[test] = MemberQ[debugList,test];
\t\t];
\t
\tCheckProp[1] = CheckProperty1;
\tCheckProp[2] = CheckProperty2;
\tCheckProp[3] = CheckProperty3;
\tCheckProp[4] = CheckProperty4;
\tCheckProp[5] = CheckProperty5;
\tCheckProp[6] = CheckProperty6;
\tCheckProp[7] = CheckProperty7;
\tCheckProp[8] = CheckProperty8;
\tCheckProp[9] = CheckProperty9;
\tCheckProp[10] = CheckProperty10;
\tCheckProp[11] = CheckProperty11;
\tCheckProp[12] = CheckProperty12;
\tCheckProp[13] = CheckProperty13;
\tCheckProp[14] = CheckProperty14;
\tCheckProp[15] = CheckProperty15;
\tCheckProp[16] = CheckProperty16;
\tCheckProp[17] = CheckProperty17;
\tCheckProp[18] = CheckProperty18;
\tCheckProp[19] = CheckProperty19;
\tCheckProp[20] = CheckProperty20;
\t
\tPropMsg[1] = \"Points are coplanar.\";
\tPropMsg[2] = \"Faces are parallel.\";
\tPropMsg[3] = \"Cevians concur.\";
\tPropMsg[4] = \"Cevians have same length.\";
\tPropMsg[5] = \"Tetrahedron is isosceles.\";
\tPropMsg[6] = \"Tetrahedron is isodynamic.\";
\tPropMsg[7] = \"Tetrahedron is circumscriptible.\";
\tPropMsg[8] = \"Tetrahedron is orthocentric.\";
\tPropMsg[9] = \"Tetrahedra have same centroid.\";
\tPropMsg[10] = \"Cevians form a hyperbolic group.\";
\tPropMsg[11] = \"Points are collinear.\";
\tPropMsg[12] = \"Tetrahedra are similar.\";
\tPropMsg[13] = \"Find condition for concurrence of cevians.\";
\tPropMsg[14] = \"Find condition for points to be coplanar.\";
\tPropMsg[15] = \"Find condition for tetrahedra to have same centroid.\";
\tPropMsg[16] = \"Find condition for cevians to form a hyperbolic group.\";
\tPropMsg[17] = \"Normals concur.\";
\tPropMsg[18] = \"Tetrahedra have centers in common.\";
\tPropMsg[19] = \"Find condition for points to be collinear.\";
\tPropMsg[20] = \"Find condition for normals to concur.\";

\tTetrCenters[1] = ourCentroid;
\tTetrCenters[2] = ourCircumcenter;
\tTetrCenters[3] = ourMongePoint;
\tTetrCenters[4] = ourIncenter;
\tTetrCenters[5] = ourEulerPoint;

\tnumTetrCenters[1] = ourCentroid/.NumConditions;
\tnumTetrCenters[2] = ourCircumcenter/.NumConditions;
\tnumTetrCenters[3] = ourMongePoint/.NumConditions;
\tnumTetrCenters[4] = ourIncenter/.NumConditions;
\tnumTetrCenters[5] = ourEulerPoint/.NumConditions;
\t
\tIf[IntegerQ[numTetrCenters[1][[1]]],
\t\tgc = Apply[GCD,numTetrCenters[1]];
\t\tnumTetrCenters[1] = numTetrCenters[1]/gc;
\t  ];
\tIf[IntegerQ[numTetrCenters[2][[1]]],
\t\tgc = Apply[GCD,numTetrCenters[2]];
\t\tnumTetrCenters[2] = numTetrCenters[2]/gc;
\t  ];
\tIf[IntegerQ[numTetrCenters[3][[1]]],
\t\tgc = Apply[GCD,numTetrCenters[3]];
\t\tnumTetrCenters[3] = numTetrCenters[3]/gc;
\t  ];
\tIf[IntegerQ[numTetrCenters[4][[1]]],
\t\tgc = Apply[GCD,numTetrCenters[4]];
\t\tnumTetrCenters[4] = numTetrCenters[4]/gc;
\t  ];
\tIf[IntegerQ[numTetrCenters[5][[1]]],
\t\tgc = Apply[GCD,numTetrCenters[5]];
\t\tnumTetrCenters[5] = numTetrCenters[5]/gc;
\t  ];

\tFor[test=1, test<=numberOfTests, test++,
\t  If[doAllTests && test!=13 && test!=14 && test!=15 && test!=16
\t    && test!=19  && test!=20 || doTest[test],
\t\tIf[caseNames||doAllDebug,
\t\t\tPrint[\" Checking property \",test,\"...\"];
\t\t  ];
\t\tIf[values||doAllDebug,
\t\t\tPrint[\"P0=\",P0];
\t\t  ];
\t\tnumericOk = CheckProp[test][A,P0,S0,SD0,doDebug[test],
\t\t\t\t\t\tTrue,numTetrCenters];
\t\tIf[numericOk,
\t\t\tIf[numericCheckOnly,
\t\t\t\tok = True,
\t\t\t(* else *)
\t\t\t\tIf[values||doAllDebug,
\t\t\t\t\tPrint[\"P1=\",P1];
\t\t  \t\t  ];
\t\t\t\tok = CheckProp[test][A,P1,S1,SD1,doDebug[test],
\t\t\t\t\t\tFalse,TetrCenters];
\t\t\t  ];
\t\t\tIf[ok,Print[\"  \",PropMsg[test]],
\t\t\t\tIf[numericOk,
\t\t\t\t\tPrint[\"  Property \",test,
\t\t\t\t\t\t  \" failed in general,\",
\t\t\t\t\t\t  \" but numeric example succeeded.\"
\t\t\t\t\t\t ];
\t\t\t\t  ];
\t\t\t  ];
\t \t  ];
\t  ];
\t];

];

g0[y_,z_]:=y^3+z^3;
f0[a_,x_]:=a(x-a^2);

Sqrt3Simp[expr_]:=
Block[{temp},
\ttemp=expr/.{3^Rational[n_/;OddQ[n],2]->3^((n-1)/2)Sqrt3};
\ttemp=temp/.{Sqrt3->Sqrt[3]};
\ttemp=Together[temp];
\tReturn[temp];
\t];

(*
\tOther ideas for tests:
\t
\tratio of volumes numerical constant
\tratio of face areas numerical constant
\tcan inscribe a regular tetrahedron
\tlines to center j of inner tetrahedron concur
\tcorresponding edges are perpendicular
\tcorresponding edges are same distance apart
\terected perpendiculars are hyperbolic
\tcenter i of inner coincides with center j of outer
\t\twhere centers are:
\t\tcentroid, circumcenter, incenter, Monge point
*)
\
\>", "Input",
 InitializationCell->True,
 AspectRatioFixed->True,
 CellLabel->
  "In[333]:=",ExpressionUUID->"946e07da-c32d-4f6b-8c3f-26f83440993b"],

Cell[CellGroupData[{

Cell["\<\
(* Picture of our base tetrahedron *)
Under the transformation A1A2A3->A2A1A4->A3A4A1->A4A3A2,
we have
(a1,a2,a3)->(b2,b1,a3)->(b3,b1,a2)->(b3,b2,a1).\
\>", "Input",
 Evaluatable->False,
 AspectRatioFixed->
  True,ExpressionUUID->"823fae71-366a-4996-820b-c71d4ec979d6"],

Cell[GraphicsData["PICT", "\<\
18`0S`1H0FD1Oa41X022X@1T00YCD4iD0nP00@00X@1T00iCD4iD3=00S`1H0FD1
Oj40I00:De1>E0^h00/00:00S:40I00:De1>E0^h00<00P402P2?05P1I@5o802d
09`1CP1cX@1T00YCD4iD2kP00`02805?07<1C`5TX@1T00YCD4iD2kP00`02805>
0F@0]02MX@1T00YCD4iD2kP00`02802d09`0Y@4iX@1T00YCD4iD2kP00`02802T
0CT1C`1cX@1T00YCD4iD2kP00`02802T0CT1C`5UX@1T00YCD4iD2kP00@00X@1T
01YCD4iD32H1B@5X0F01O`0400;ooooooooooj40I00:De1>E0bD00000:40UP0<
1@00008000000000;00<01D9B6E/MVEdJF=Q0`0E3@0<:05I0Fd2@C6P09NQ06@0
2U=@CU@;^001002Q06@06U=@CU@<9P2P08<0]`2J00@00_ooooooooooX@1T00YC
D4iD39@00000X@2F00`500000P000000000X0;00R091<Z00Uj40I00:De1>E0^h
00400:40I00JDe1>E0`V0Dh0F05U06l01002oooooooooonQ06@02U=@CU@<U000
002Q09H030D000020000000002P1GP1M0T4cX02GX@1T00YCD4iD2kP00@00X@1T
01YCD4iD32H0S`4h0:H1C`0400;ooooooooooj40I00:De1>E0bD00000:40UP0<
1@00008000000000:02O0Cd2@CBP09NQ06@02U=@CU@;^001002Q06@06U=@CU@<
9P3_07411P2800@00_ooooooooooX@1T00YCD4iD39@00000X@2F00`500000P00
0000000X0?l0MP9Q<J00Uj40I00:De1>E0^h00400:40I00JDe1>E0`V0Dd0e05T
0>d01002oooooooooonQ06@02U=@CU@<U000002Q09H030D000020000000002]S
GP9Q<Z00Uj40I00:De1>E0^h00400:40I00JDe1>E0`V0@T0n`4P0AD01002oooo
oooooonQ06@02U=@CU@<U000002Q09H030D000020000000002P16@400V4cX02G
X@1T00YCD4iD2kP00@00X@1T01YCD4iD32H0i05?0?/1IP0400;ooooooooooj40
I00:De1>E0bD00000:40UP0<1@00008000000000:03d0E@2HS6P09NQ06@02U=@
CU@;^001002Q06@06U=@CU@<9P2F0=/0[@3i00@00_ooooooooooX@1T00YCD4iD
39@00000X@2F00`500000P000000000X0:H0h09R<Z00Uj40I00:De1>E0^h0040
0:40I00JDe1>E0`V0@80Y@4I0;`01002oooooooooonQ06@02U=@CU@<U000002Q
09H030D000020000000002P14P2Z0V8cX02GX@1T00YCD4iD2kP03000X02=X@1T
00ICD4iD0nVP08?o\>"], "Graphics",
 Evaluatable->False,
 AspectRatioFixed->True,
 ImageSize->{282, 287},
 ImageMargins->{{34, Inherited}, {
   Inherited, 
    Inherited}},ExpressionUUID->"84ed5b7b-3083-44e9-a997-6d5db940bf81"]
}, Open  ]],

Cell["\<\
findTetrCenters[condition_]:=
Block[{aCentroid,aCircumcenter,aMongePoint,aIncenter,aEulerPoint},
\t{aCentroid,aCircumcenter,aMongePoint,aIncenter,aEulerPoint} =
\t\t{Centroid,Circumcenter,MongePoint,
\t\t\tIncenter,EulerPoint}/.condition;
\t{aCentroid,aCircumcenter,aMongePoint,aIncenter,aEulerPoint} =
\t\tPowerExpand[{aCentroid,aCircumcenter,aMongePoint,
\t\t\t\t\taIncenter,aEulerPoint}];
(*
\taCentroid = RemoveCommonFactors[aCentroid];
*)
\tIf[NumberQ[aCentroid[[1]]] && aCentroid[[1]]<0,
\t\taCentroid = -aCentroid];
\tIf[showTetrCenters,
\t\tPrint[\"Coordinates of centroid: \",Factor[aCentroid]];
  \t  ];
(*
\taCircumcenter = RemoveCommonFactors[aCircumcenter];
*)
\tIf[NumberQ[aCircumcenter[[1]]] && aCircumcenter[[1]]<0,
\t\taCircumcenter = -aCircumcenter];
\tIf[showTetrCenters,
\t\tPrint[\"Coordinates of circumcenter: \",Factor[aCircumcenter]];
  \t  ];
(*
\taMongePoint = RemoveCommonFactors[aMongePoint];
*)
\tIf[NumberQ[aMongePoint[[1]]] && aMongePoint[[1]]<0,
\t\taMongePoint = -aMongePoint];
\tIf[showTetrCenters,
\t\tPrint[\"Coordinates of Monge point: \",Factor[aMongePoint]];
  \t  ];
(*
\taIncenter = RemoveCommonFactors[aIncenter];
*)
\tIf[NumberQ[aIncenter[[1]]] && aIncenter[[1]]<0,
\t\taIncenter = -aIncenter];
\tIf[showTetrCenters,
\t\tPrint[\"Coordinates of Incenter: \",
\t\t\t(aIncenter/.{Sqrt[x_]:>Sqrt[Factor[x]]})];
  \t  ];
(*
\taEulerPoint = RemoveCommonFactors[aEulerPoint];
*)
\tIf[NumberQ[aEulerPoint[[1]]] && aEulerPoint[[1]]<0,
\t\taEulerPoint = -aEulerPoint];
\tIf[showTetrCenters,
\t\tPrint[\"Coordinates of Euler point: \",Factor[aEulerPoint]];
  \t  ];
  \tReturn[{aCentroid,aCircumcenter,aMongePoint,
  \t\t\t\taIncenter,aEulerPoint}];
\t];

findGeneralTetrCenters[]:=
Block[{A1,A2,A3,A4,tem1,tem2,tem3,tem4},
\tIf[IntegerQ[numberOfTetrCenters],Return[]];
\tPrint[\"Finding general tetrahedron centers...\"];
\tA1 = {1,0,0,0};
\tA2 = {0,1,0,0};
\tA3 = {0,0,1,0};
\tA4 = {0,0,0,1};
\tCentroid = A1+A2+A3+A4;
\t(* Note that we have to divide Centroid by 4 to get exact coords *)
\tPrint[\"  Found centroid.\"];
\tcosf[x_,y_,z_]:=y^2+z^2-x^2;
\ttem1 = a1^2 b1^2 cosf[a1,b2,b3]+a2^2 b2^2 cosf[b2,b3,a1]+
\t\ta3^2 b3^2 cosf[b3,a1,b2]-2a1^2 b2^2 b3^2;
\ttem2 = tem1/.{b2->b1,a1->a2,a2->a1,b1->b2};
\ttem3 = tem1/.{b3->b2,b2->b1,a1->a3,a3->a2,a2->a1,b1->b3};
\ttem4 = tem1/.{b3->a1,b2->a2,a1->a3,a3->b1,a2->b2,b1->b3};
\tCircumcenter = {tem1,tem2,tem3,tem4};
\tPrint[\"  Found circumcenter.\"];
\t(* M = 2G-O *)
\tMongePoint = Centroid/2 -
\t\tExactTetrahedralCoordinates[Circumcenter];
\t(* Note that we have exact tetrahedral coords for Monge Point *)
\tPrint[\"  Found Monge point.\"];
\tF1=SquaredAreaOfTriangleFromSides[a1,b2,b3];
\tF2=SquaredAreaOfTriangleFromSides[b1,a2,b3];
\tF3=SquaredAreaOfTriangleFromSides[b1,b2,a3];
\tF4=SquaredAreaOfTriangleFromSides[a1,a2,a3];
\tIncenter = Sqrt[{F1,F2,F3,F4}];
\tPrint[\"  Found incenter.\"];
\t(* E = (2G+M)/3 *)
\tEulerPoint = Centroid/6 + MongePoint/3;
\t(* Note that we have exact tetrahedral coords for Euler Point *)
\tPrint[\"  Found Euler point.\"];
\tnumberOfTetrCenters = 5;
\ttetrCenterName[1] = \"centroid\";
\ttetrCenterName[2] = \"circumcenter\";
\ttetrCenterName[3] = \"Monge point\";
\ttetrCenterName[4] = \"incenter\";
\ttetrCenterName[5] = \"Euler point\";
\t];
\
\>", "Input",
 InitializationCell->True,
 AspectRatioFixed->True,
 CellLabel->
  "In[342]:=",ExpressionUUID->"3611b796-46ce-4baf-98f0-4ec44bfe3eea"],

Cell[CellGroupData[{

Cell["\<\
(* Set up Tetrahedral Coordinates for
\tvertices of a tetrahedron *)
A[1] = {1,0,0,0};
A[2] = {0,1,0,0};
A[3] = {0,0,1,0};
A[4] = {0,0,0,1};
typesOfTetrahedra = 6;
TetrTypeName[1] = \"General Tetrahedron\";
TetrTypeCond[1] = {};
TetrNumCond[1]  = {a1->16,a2->20,a3->22,
\t\t\t\t\tb1->14,b2->17,b3->21,r->3,f->f0,g->g0};
TetrTypeName[2] = \"Isosceles Tetrahedron\";
TetrTypeCond[2] = {b1->a1,b2->a2,b3->a3};
TetrNumCond[2]  = {a1->7,a2->8,a3->10,r->3,f->f0,g->g0};
TetrTypeName[3] = \"Circumscriptible Tetrahedron\";
TetrTypeCond[3] = {b1->t-a1,b2->t-a2,b3->t-a3};
TetrNumCond[3]  = {a1->8,a2->10,a3->13,t->32,r->3,f->f0,g->g0};
TetrTypeName[4] = \"Isodynamic Tetrahedron\";
TetrTypeCond[4] = {b1->t/a1,b2->t/a2,b3->t/a3};
TetrNumCond[4]  = {a1->35,a2->40,a3->28,t->840,r->3/2,f->f0,g->g0};
TetrTypeName[5] = \"Orthocentric Tetrahedron\";
TetrTypeCond[5] = {b1->Sqrt[t-a1^2],b2->Sqrt[t-a2^2],
\t\t\t\t\tb3->Sqrt[t-a3^2]};
TetrNumCond[5]  = {a1->4,a2->9,a3->12,t->1105,r->3,f->f0,g->g0};
TetrTypeName[6] = \"Harmonic Tetrahedron\";
TetrTypeCond[6] = {b1->a1/(a1 t-1),b2->a2/(a2 t-1),b3->a3/(a3 t-1)};
TetrNumCond[6]  = {a1->7,a2->9,a3->10,t->1/4,r->3,f->f0,g->g0};
(*
TetrTypeName[7] = \"Ecliptic Tetrahedron\";
TetrTypeCond[7] = {b1->(t-a1)/(a1+1),b2->(t-a2)/(a2+1),b3->(t-a3)/(a3+1)};
TetrNumCond[7]  = {a1->7,a2->8,a3->17/2,t->260,r->3,f->f0,g->g0};
*)
(*
\tFor each triangle center,
\tfind the 4 centers of each of the faces
\tof the tetrahedron in
\ttetrahedral (Barycentric) coordinates.
\tThe center in face i (opposite vertex Ai
\tis called Pi).
*)

skipSqrts=False;
showTetrCenters=False;
skipTetrCenters=False;
ShowEquationOfPlanes = False;
ShowEquationOfLines = False;

doAllTypes = True;
If[doAllTypes,
\tktLow=1; ktHigh=typesOfTetrahedra,
(* else *)
\tktLow=4; ktHigh=typesOfTetrahedra;
  ];
doAllCenters = True;
If[doAllCenters,
\tiLow=1; iHigh=numberOfCenters,
(* else *)
\tiLow=1; iHigh=5;
  ];

If[!skipTetrCenters,findGeneralTetrCenters[]];

For[k=ktLow,k<=ktHigh,k++,
Print[\" \"];
Print[\"CASE \",k,\": \",TetrTypeName[k]];
Print[\"------\"];
genCondition = TetrTypeCond[k];
numericalCondition = TetrNumCond[k];
(*
\tCompute various centers of the tetrahedron.
*)
If[!skipTetrCenters,
\tgenC=genCondition/.t->100;
\t{ourCentroid,ourCircumcenter,ourMongePoint,
\t\tourIncenter,ourEulerPoint} =
\t\t\tfindTetrCenters[genC];
  ];
For[i=iLow,i<=iHigh,i++,
\t{x1,x2,x3}=ArealCoords[i]/.{a->b3,b->b2,c->a1};
\tP[1]={0,x1,x2,x3};
\tIf[skipSqrts,
\t\tIf[!FreeQ[x1,3^(x_)],Continue[]]
\t  ];
\t{x1,x2,x3}=ArealCoords[i]/.{a->b3,b->b1,c->a2};
\tP[2]={x1,0,x2,x3};
\t{x1,x2,x3}=ArealCoords[i]/.{a->b2,b->b1,c->a3};
\tP[3]={x1,x2,0,x3};
\t{x1,x2,x3}=ArealCoords[i]/.{a->a1,b->a2,c->a3};
\tP[4]={x1,x2,x3,0};
\tPrint[\"i=\",i,\" \",centerName[i]];
\tCheckProperties[{A[1],A[2],A[3],A[4]},
\t\t{P[1],P[2],P[3],P[4]},
\t\tnumericalCondition,
\t\tgenCondition,{},{},False,False];
\t];
  ];\
\>", "Input",
 AspectRatioFixed->True,
 CellLabel->
  "In[346]:=",ExpressionUUID->"dbcebd92-0be6-4d67-928b-77e052207010"],

Cell[BoxData["\<\"Finding general tetrahedron centers...\"\>"], "Print",
 CellChangeTimes->{3.8056402882853937`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9c2abb94-4493-4e03-9056-27607469835e"],

Cell[BoxData["\<\"  Found centroid.\"\>"], "Print",
 CellChangeTimes->{3.805640288286786*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d3f43e2f-217c-4871-81e6-45090933691c"],

Cell[BoxData["\<\"  Found circumcenter.\"\>"], "Print",
 CellChangeTimes->{3.805640288287624*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f45b1579-321d-4979-a41a-25fa905677f7"],

Cell[BoxData["\<\"  Found Monge point.\"\>"], "Print",
 CellChangeTimes->{3.8056402882884293`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4e901449-f76f-4f7f-bfd0-22c17a8081d8"],

Cell[BoxData["\<\"  Found incenter.\"\>"], "Print",
 CellChangeTimes->{3.805640288289238*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"76ef299e-9706-4d0f-87ba-2edd05fefafa"],

Cell[BoxData["\<\"  Found Euler point.\"\>"], "Print",
 CellChangeTimes->{3.805640288290041*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6ca2af8f-ab56-4471-9699-ec170ea95b46"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.8056402882908487`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"61851c4f-79d2-4206-a53f-3b7e52d237c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CASE \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"General Tetrahedron\"\>"}],
  SequenceForm["CASE ", 1, ": ", "General Tetrahedron"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640288291683*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"852a16bc-12eb-4648-81eb-28581823c727"],

Cell[BoxData["\<\"------\"\>"], "Print",
 CellChangeTimes->{3.805640288292557*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8569086b-b2e2-42d1-970f-ff3831b69170"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>"}],
  SequenceForm["i=", 1, " ", "incenter"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640288293401*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e2ea3737-604b-4a26-b9f0-8fe1c6326d81"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564028829429*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"19f374be-6f85-47b3-a531-0070086e6f0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>"}],
  SequenceForm["i=", 2, " ", "centroid"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640288295189*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7c2c1899-552c-4811-bc88-bac7b63aaa4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Faces are parallel.\"\>"}],
  SequenceForm["  ", "Faces are parallel."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640288296082*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c6041b47-9a39-4647-bd29-fd578a0e1e59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Coordinates of intersection point:  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["    Coordinates of intersection point:  ", {1, 1, 1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402882969923`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ae1738d4-4331-436b-8e87-7613205c5bf0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm["    Point coincides with ", "centroid", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402882978697`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a3535f4c-db4c-411c-b581-3421e147fadc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", "\<\"Intersection point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on reference Euler line (at \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    ", "Intersection point", " lies on reference Euler line (at ", 1, ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564028829878*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"11dcc305-3148-488f-9c17-5479163ad944"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Cevians concur.\"\>"}],
  SequenceForm["  ", "Cevians concur."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640288299857*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"36d0ec96-f7da-4991-ab9a-89ef0716d9b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640288300735*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6a618272-e15d-4669-a2ac-71a7230953b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640288301608*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"337a6289-cb82-4aa8-9135-8255091390d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra are similar.\"\>"}],
  SequenceForm["  ", "Tetrahedra are similar."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640288302492*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"77c57d29-f94a-4c4e-b1bf-b8458a700b11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402883033733`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d5e7e192-080a-48fc-bc52-b34291619458"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "Euler point",
    "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640288310062*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a7119445-1ece-457b-8ab6-9113e70817c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", "\<\"Central Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on reference Euler line (at \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["2", "3"], "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    ", "Central Monge point", " lies on reference Euler line (at ", 
   Rational[2, 3], ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640288415225*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b93b61b4-7b9f-46da-92a0-7c6a19ba4b40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", "\<\"Central Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on reference Euler line (at \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["8", "9"], "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    ", "Central Euler point", " lies on reference Euler line (at ", 
   Rational[8, 9], ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640288580682*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"805dcc43-1610-4c79-adda-4a6b6de07509"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Reference \"\>", 
   "\[InvisibleSpace]", "\<\"circumcenter\"\>", 
   "\[InvisibleSpace]", "\<\" lies on central Euler line (at \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    Reference ", "circumcenter", " lies on central Euler line (at ", 4, 
   ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402886898518`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"088e1d52-ff68-48ef-a43b-6b6a1f3280ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Reference \"\>", 
   "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on central Euler line (at \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "2"}], "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    Reference ", "Monge point", " lies on central Euler line (at ", -2, 
   ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402887454567`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"93af3f87-8d45-4973-ac42-1742f22c8fd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564028879634*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3d3d1cb4-34e5-4daa-b9de-fe6b6f621a2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"circumcenter\"\>"}],
  SequenceForm["i=", 3, " ", "circumcenter"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640288797707*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"67620ae0-4593-4dff-8a95-c72e8c00250c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"circumcenter\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm[
  "    Point coincides with ", "circumcenter", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402893611937`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ad473ed5-a5c3-42e8-a4a1-c5ba5d11b247"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", "\<\"Intersection point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on reference Euler line (at \"\>", 
   "\[InvisibleSpace]", "0", "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    ", "Intersection point", " lies on reference Euler line (at ", 0, ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402894109163`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e423ef22-9992-45e9-b9b5-540aa9cd7775"],

Cell[BoxData["\<\"    4th coordinate of point of intersection is:\"\>"], \
"Print",
 CellChangeTimes->{3.805640289412037*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8ba90fe5-77f8-4d4a-897e-8905e2a87461"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["a3", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a1", "4"], " ", 
     SuperscriptBox["b1", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["b1", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a3", "2"], " ", 
     SuperscriptBox["b1", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["b2", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a2", "4"], " ", 
     SuperscriptBox["b2", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["a3", "2"], " ", 
     SuperscriptBox["b2", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a3", "2"], " ", 
     SuperscriptBox["b3", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["a3", "2"], " ", 
     SuperscriptBox["b3", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a3", "4"], " ", 
     SuperscriptBox["b3", "2"]}]}]}],
  SequenceForm[
  "    ", 2 $CellContext`a1^2 $CellContext`a2^2 $CellContext`a3^2 + \
$CellContext`a1^4 $CellContext`b1^2 - $CellContext`a1^2 $CellContext`a2^2 \
$CellContext`b1^2 - $CellContext`a1^2 $CellContext`a3^2 $CellContext`b1^2 - \
$CellContext`a1^2 $CellContext`a2^2 $CellContext`b2^2 + $CellContext`a2^4 \
$CellContext`b2^2 - $CellContext`a2^2 $CellContext`a3^2 $CellContext`b2^2 - \
$CellContext`a1^2 $CellContext`a3^2 $CellContext`b3^2 - $CellContext`a2^2 \
$CellContext`a3^2 $CellContext`b3^2 + $CellContext`a3^4 $CellContext`b3^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640289413233*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"20471d4e-ca4d-4f05-aa2c-b6c797f54a5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Normals concur.\"\>"}],
  SequenceForm["  ", "Normals concur."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640289414331*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"79e0fa2f-cdda-4948-9968-834e47088181"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"orthocenter\"\>"}],
  SequenceForm["i=", 4, " ", "orthocenter"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640289415303*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d63aa755-2c98-4a7b-9adf-6bfc738d82f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"nine point center\"\>"}],
  SequenceForm["i=", 5, " ", "nine point center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640289423534*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5c967f6c-9737-4474-a3b9-7a53c6ff37f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"symmedian point\"\>"}],
  SequenceForm["i=", 6, " ", "symmedian point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640289473167*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7a5d7d3e-687b-420e-b608-b64c419075fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640289475128*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"40c9ec49-054a-4469-9530-485d2cb9ef79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Gergonne point\"\>"}],
  SequenceForm["i=", 7, " ", "Gergonne point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640289476613*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"78532b1b-a92b-4887-9b1d-e9e2e69ea4d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Nagel point\"\>"}],
  SequenceForm["i=", 8, " ", "Nagel point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640289529195*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d8a5d62f-f4a8-49d5-909d-8ddfa9207ebc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Mittenpunkt\"\>"}],
  SequenceForm["i=", 9, " ", "Mittenpunkt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640289530373*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c7ab2528-6ddb-4403-ada9-ee5c3d5835ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Spieker center\"\>"}],
  SequenceForm["i=", 10, " ", "Spieker center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640289531402*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ba0472a2-0fe9-4cc8-af1b-67892af57477"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Feuerbach point\"\>"}],
  SequenceForm["i=", 11, " ", "Feuerbach point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640289532583*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f1a64fe8-0c8e-4894-9a5b-f865aa155204"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X12\"\>"}],
  SequenceForm["i=", 12, " ", "X12"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402895833483`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9db589b3-9647-465c-82df-938b481389ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"1st isogonic center (Fermat point)\"\>"}],
  SequenceForm["i=", 13, " ", "1st isogonic center (Fermat point)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564028958457*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"faef6ddd-04dc-4946-9e71-a63f317e32b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Isogonic center\"\>"}],
  SequenceForm["i=", 14, " ", "2nd Isogonic center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640289916532*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"03396519-aeb1-4b00-a722-e077aae332c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"1st Isodynamic point\"\>"}],
  SequenceForm["i=", 15, " ", "1st Isodynamic point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640290184306*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"90a615a5-86da-4720-a937-b3287ddfc4b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Isodynamic point\"\>"}],
  SequenceForm["i=", 16, " ", "2nd Isodynamic point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402903602123`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cc3b2664-496b-4fb1-9875-baacebc17da7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"1st Napoleon point\"\>"}],
  SequenceForm["i=", 17, " ", "1st Napoleon point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564029054246*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"77d22860-bb01-4a30-9b77-a9442ec3e2d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Napoleon point\"\>"}],
  SequenceForm["i=", 18, " ", "2nd Napoleon point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402908922997`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7db3bb49-4d08-4459-9fe1-3ab70cf64eec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Crucial point\"\>"}],
  SequenceForm["i=", 19, " ", "Crucial point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402911663303`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"982b4106-a887-4978-bc0c-aeceb588147c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"De Longchamps point\"\>"}],
  SequenceForm["i=", 20, " ", "De Longchamps point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640291216346*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d68651a6-72c9-4a9f-acce-9434639084a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Schiffler point\"\>"}],
  SequenceForm["i=", 21, " ", "Schiffler point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640291269678*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"667e0853-6740-4802-a850-536669bcd1fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Exeter point\"\>"}],
  SequenceForm["i=", 22, " ", "Exeter point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640291271123*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ca99398d-9d1f-4aea-931e-83d7f51c1894"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"far out point\"\>"}],
  SequenceForm["i=", 23, " ", "far out point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640291332068*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5a89c572-12a7-4c0e-acb3-e8eb878c8904"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X24\"\>"}],
  SequenceForm["i=", 24, " ", "X24"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402913332567`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9fb0565e-155a-4daa-9691-325426559b6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X25\"\>"}],
  SequenceForm["i=", 25, " ", "X25"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640291386265*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e1fba38c-dfda-4696-9705-c026e351c6c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Circumcenter of tangential triangle\"\>"}],
  SequenceForm["i=", 26, " ", "Circumcenter of tangential triangle"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640291437261*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2e4de72a-f5a2-49a2-9858-c77e5599d2d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X27\"\>"}],
  SequenceForm["i=", 27, " ", "X27"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640291529298*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"df55f275-6491-4202-8d7d-d686244c0505"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X28\"\>"}],
  SequenceForm["i=", 28, " ", "X28"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640291579672*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"614a2ff8-4835-41c4-a70d-a15f7653ee7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X29\"\>"}],
  SequenceForm["i=", 29, " ", "X29"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640291631278*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1013e40c-4c03-4b57-abe4-44f769e41297"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X30\"\>"}],
  SequenceForm["i=", 30, " ", "X30"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640291683201*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"838ab076-3afd-490e-a027-7b9593aed008"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640291684383*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b52c6319-3700-477f-89b2-c850dd798fbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640291685315*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"033e753b-605b-466b-93a8-b8fce5f6d6f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640293741828*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"da7aafa6-da1b-4134-a62f-806ae50dd6d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd power point\"\>"}],
  SequenceForm["i=", 31, " ", "2nd power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402937431393`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fecadb8d-f07f-4be0-b733-52e8873c41eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640293772252*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d842687e-c54e-4d0f-9307-13f9203d91b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"3rd power point\"\>"}],
  SequenceForm["i=", 32, " ", "3rd power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640293773471*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b9c9243a-7da0-489e-89ea-ee7b0b22796f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402937744513`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"560ba00e-95dc-46b7-9630-922428636267"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X33\"\>"}],
  SequenceForm["i=", 33, " ", "X33"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640293781377*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0b723a03-c74b-4cc9-9634-67ec81bc871f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X34\"\>"}],
  SequenceForm["i=", 34, " ", "X34"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402938286552`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5421d628-3293-43f9-9f80-73e967d6fed8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X35\"\>"}],
  SequenceForm["i=", 35, " ", "X35"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640293875193*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"de39644b-c40c-48f9-90bb-4507d38ad6fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X36\"\>"}],
  SequenceForm["i=", 36, " ", "X36"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640293906139*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4df2e2ff-2640-433d-80bc-37dd7827a147"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X37\"\>"}],
  SequenceForm["i=", 37, " ", "X37"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402939437447`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fc905fac-f6d5-453c-b68b-5c702dcdf729"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X38\"\>"}],
  SequenceForm["i=", 38, " ", "X38"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640293951232*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a00cf050-3288-42bf-a39e-8e3978745c00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "39", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Brocard midpoint\"\>"}],
  SequenceForm["i=", 39, " ", "Brocard midpoint"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640293981545*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4a2b5ed2-1b7c-4865-a037-df52539a0377"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X40\"\>"}],
  SequenceForm["i=", 40, " ", "X40"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294013198*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"47aadfd3-703f-4d28-8ff5-08c0781b0c01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X41\"\>"}],
  SequenceForm["i=", 41, " ", "X41"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294075626*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4c204fc7-2c00-49c6-a3d8-1e257b3824c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X42\"\>"}],
  SequenceForm["i=", 42, " ", "X42"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294104649*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2076d98e-5668-4230-a450-0a73d3fd43be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "43", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X43\"\>"}],
  SequenceForm["i=", 43, " ", "X43"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294144375*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"da3b7619-50c6-45af-9b76-072df3f0269d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "44", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X44\"\>"}],
  SequenceForm["i=", 44, " ", "X44"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294176853*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"119f10c6-6719-4a3c-b39c-cdfd13ee85b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "45", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X45\"\>"}],
  SequenceForm["i=", 45, " ", "X45"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402941840677`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e5955500-95b3-43d6-8fc2-c78f74b5aeb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "46", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X46\"\>"}],
  SequenceForm["i=", 46, " ", "X46"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402942133904`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ebf088b5-432f-47e6-90ed-786c1270da2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "47", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X47\"\>"}],
  SequenceForm["i=", 47, " ", "X47"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294273849*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"521c57d0-e9d2-43a5-9451-58f296f2110a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "48", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X48\"\>"}],
  SequenceForm["i=", 48, " ", "X48"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294320568*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"099f273c-adb6-4e54-b125-027f10de18e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "49", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X49\"\>"}],
  SequenceForm["i=", 49, " ", "X49"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294352024*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f8d227e7-9c0d-4c52-9e38-4d734b8b1dfe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "50", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X50\"\>"}],
  SequenceForm["i=", 50, " ", "X50"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294414586*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6b62d5fc-2508-485f-8c54-17e95864df28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "51", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Centroid of orthic triangle\"\>"}],
  SequenceForm["i=", 51, " ", "Centroid of orthic triangle"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294474605*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"89a8c6ea-1969-4694-9c0d-b405e4843dbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "52", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Orthocenter of orthic triangle\"\>"}],
  SequenceForm["i=", 52, " ", "Orthocenter of orthic triangle"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294542076*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7922cc65-9fc2-4b4a-8dc7-b18f654e3d1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "53", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Symmedian point of orthic triangle\"\>"}],
  SequenceForm["i=", 53, " ", "Symmedian point of orthic triangle"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564029460917*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cdf4b289-434a-4edd-a5a1-f2e4ba53442e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "54", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Nine point inv\"\>"}],
  SequenceForm["i=", 54, " ", "Nine point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402946483173`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dab80396-84c0-466a-a858-e3b60517bbad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "55", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Gergonne inv\"\>"}],
  SequenceForm["i=", 55, " ", "Gergonne inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402947314863`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"786b6e23-a700-4070-a7fe-e174f23d728f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "56", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Nagel inv\"\>"}],
  SequenceForm["i=", 56, " ", "Nagel inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294761503*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6ecc383b-2d92-436b-b7a8-8a772208eae6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "57", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Mittenpunkt inv\"\>"}],
  SequenceForm["i=", 57, " ", "Mittenpunkt inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294794046*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"29291453-cc84-482c-acd2-67ed79f091a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "58", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Spieker inv\"\>"}],
  SequenceForm["i=", 58, " ", "Spieker inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402948260813`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6142d65d-f914-4f83-ac9b-7e62e5986f85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "59", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Feuerbach inv\"\>"}],
  SequenceForm["i=", 59, " ", "Feuerbach inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564029483276*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"afdec6cf-8d8b-4c81-9348-9d1520de76bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "60", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X12 inv\"\>"}],
  
  SequenceForm["i=", 60, " ", "X12 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294890935*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"06b3c2ca-b38e-42ce-b710-1c34ac51f73a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "61", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"1st Napoleon point inv\"\>"}],
  SequenceForm["i=", 61, " ", "1st Napoleon point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640294926674*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"95fec1a0-0ab0-4fd7-8bfb-6114fb14fdfe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "62", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Napoleon point inv\"\>"}],
  SequenceForm["i=", 62, " ", "2nd Napoleon point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402951631823`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ae0e7d8e-71ed-4ef7-86d7-139d918eac29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "63", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Crucial point inv\"\>"}],
  SequenceForm["i=", 63, " ", "Crucial point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640295387528*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a0016b32-f688-4976-b718-040f120561f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"De Longchamps point inv\"\>"}],
  SequenceForm["i=", 64, " ", "De Longchamps point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640295415966*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d880af38-02d6-4e07-a9e2-ca915960ff05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Schiffler point inv\"\>"}],
  SequenceForm["i=", 65, " ", "Schiffler point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640295491495*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f4844b27-2b8b-4c2e-be0b-1ecd914a943f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "66", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Exeter point inv\"\>"}],
  SequenceForm["i=", 66, " ", "Exeter point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640295519959*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0c7cbfc1-17a1-49c5-99ce-e3559983e251"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"far out point inv\"\>"}],
  SequenceForm["i=", 67, " ", "far out point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640295558823*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"39691d46-c68b-48e7-8ae8-f53e5097b654"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "68", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X24 inv\"\>"}],
  
  SequenceForm["i=", 68, " ", "X24 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640295594221*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"09556604-b6fe-4ae2-aa8f-2f99b2e17734"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "69", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X25 inv\"\>"}],
  
  SequenceForm["i=", 69, " ", "X25 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640295646324*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"97d98980-9b35-4a09-b289-cf29baf1641d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "70", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Circumcenter of tangential triangle inv\"\>"}],
  SequenceForm["i=", 70, " ", "Circumcenter of tangential triangle inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640295675188*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"875a96a9-0394-4853-99e2-8220485032b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "71", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X27 inv\"\>"}],
  
  SequenceForm["i=", 71, " ", "X27 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402957774563`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"85be37a4-8a76-4edc-9cac-b3249bac63d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "72", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X28 inv\"\>"}],
  
  SequenceForm["i=", 72, " ", "X28 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564029580797*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2ff2bdcb-bc3f-440d-a419-a5cba62bf3f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "73", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X29 inv\"\>"}],
  
  SequenceForm["i=", 73, " ", "X29 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640295844596*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"85e4b186-dec9-4b07-835a-7f0b264336d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "74", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X30 inv\"\>"}],
  
  SequenceForm["i=", 74, " ", "X30 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640295878207*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6fd42880-f0cd-4d27-a7d7-d5b2c24bb51f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "75", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd power point inv\"\>"}],
  SequenceForm["i=", 75, " ", "2nd power point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402959746037`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"507ef26e-865d-4f63-af3d-6d9bb27da8f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564029600412*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d0cb0cc5-19ae-4fc7-949e-1cd14a9a6e66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "76", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"3rd power point inv\"\>"}],
  SequenceForm["i=", 76, " ", "3rd power point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296005588*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"863bb3aa-3bc7-40b0-b163-6a86861bcb54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402960067043`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"eb947ff0-4b51-4f1e-8543-0be86a2cc339"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "77", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X33 inv\"\>"}],
  
  SequenceForm["i=", 77, " ", "X33 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296014361*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4ee0f0d0-9f50-4b33-b934-9437c206e008"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "78", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X34 inv\"\>"}],
  
  SequenceForm["i=", 78, " ", "X34 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296076853*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"df4f1454-aefa-4dd3-87f7-b95042432070"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "79", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X35 inv\"\>"}],
  
  SequenceForm["i=", 79, " ", "X35 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296108897*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1a6c82ff-adfe-49c9-b4ad-f57c894483b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "80", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X36 inv\"\>"}],
  
  SequenceForm["i=", 80, " ", "X36 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402961409893`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"240644e2-3d4f-47bf-9a70-1bf70cb096c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "81", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X37 inv\"\>"}],
  
  SequenceForm["i=", 81, " ", "X37 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296172102*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"afb791c5-3057-450b-a697-c3c836feea80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "82", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X38 inv\"\>"}],
  
  SequenceForm["i=", 82, " ", "X38 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402961798983`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b430b451-5235-4637-ac37-ce95b6e5f5ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "83", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Brocard midpoint inv\"\>"}],
  SequenceForm["i=", 83, " ", "Brocard midpoint inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296209771*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1112cb2b-7093-45a7-a3ee-a89371ec7891"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "84", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X40 inv\"\>"}],
  
  SequenceForm["i=", 84, " ", "X40 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296243784*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3290574d-4e2d-434c-9f2f-07ad77c37ab3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "85", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X41 inv\"\>"}],
  
  SequenceForm["i=", 85, " ", "X41 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296341263*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0f667cba-f1f3-48a0-ac6e-e9f328df1e46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "86", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X42 inv\"\>"}],
  
  SequenceForm["i=", 86, " ", "X42 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296388029*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1c0fd936-dbb0-4598-b664-0b935c3e7ba9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "87", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X43 inv\"\>"}],
  
  SequenceForm["i=", 87, " ", "X43 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296418735*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4ee94d49-8152-44d7-aaaf-c1939b9763b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "88", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X44 inv\"\>"}],
  
  SequenceForm["i=", 88, " ", "X44 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296461491*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"15b20e51-737a-4c14-a37f-15fb5fed8da5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "89", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X45 inv\"\>"}],
  
  SequenceForm["i=", 89, " ", "X45 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296493181*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2397d759-4946-42ff-8e10-0aeb732f18c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "90", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X46 inv\"\>"}],
  
  SequenceForm["i=", 90, " ", "X46 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296527224*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"48bb5c38-2754-4feb-ba53-ad8c7ac3a686"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "91", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X47 inv\"\>"}],
  
  SequenceForm["i=", 91, " ", "X47 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402966164303`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"90a813bb-f18a-40c1-ac89-b2b5066504b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "92", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X48 inv\"\>"}],
  
  SequenceForm["i=", 92, " ", "X48 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296683681*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"da693dba-ce6e-480e-9635-bd92114ae62f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "93", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X49 inv\"\>"}],
  
  SequenceForm["i=", 93, " ", "X49 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296732603*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9a01959c-a30e-4599-93d7-8bac92e5dc45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "94", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X50 inv\"\>"}],
  
  SequenceForm["i=", 94, " ", "X50 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296828474*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"53f7df52-1c47-484b-b8e0-8bf2f9920be8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "95", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Centroid of orthic triangle inv\"\>"}],
  SequenceForm["i=", 95, " ", "Centroid of orthic triangle inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296918071*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"38fc67af-6513-4b22-a4e7-9c473d2ce889"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "96", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Orthocenter of orthic triangle inv\"\>"}],
  SequenceForm["i=", 96, " ", "Orthocenter of orthic triangle inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640296984991*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7e495f59-2841-49f6-9e89-161bbb8dd16d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "97", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Symmedian point of orthic triangle inv\"\>"}],
  SequenceForm["i=", 97, " ", "Symmedian point of orthic triangle inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297086473*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5370a7f3-bf14-482e-89d3-b248c678daa7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "98", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Tarry point\"\>"}],
  SequenceForm["i=", 98, " ", "Tarry point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297151082*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d3d7006a-387b-4aff-a1e1-7e228e24c1a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "99", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Steiner point\"\>"}],
  SequenceForm["i=", 99, " ", "Steiner point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402971904097`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"afd9490a-c072-4402-8feb-a34691d6608a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "100", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X100\"\>"}],
  SequenceForm["i=", 100, " ", "X100"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297219401*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"410af620-0e50-4266-b623-23c05901e94a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "101", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X101\"\>"}],
  SequenceForm["i=", 101, " ", "X101"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297249189*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ea5b51f6-79ac-4b3d-ae5e-0fc4bd6896da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "102", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X102\"\>"}],
  SequenceForm["i=", 102, " ", "X102"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297279396*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2b0553c9-8308-400d-9d0e-1ff0b18b5a8a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "103", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X103\"\>"}],
  SequenceForm["i=", 103, " ", "X103"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297310246*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"872667b2-dd5b-4072-b904-ac844638326a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "104", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X104\"\>"}],
  SequenceForm["i=", 104, " ", "X104"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402973447323`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2a8e9bb2-2c33-40c1-9502-736ac7e6f707"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "105", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X105\"\>"}],
  SequenceForm["i=", 105, " ", "X105"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297346018*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"864d1feb-53c7-4110-b964-740d24c73ddd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "106", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X106\"\>"}],
  SequenceForm["i=", 106, " ", "X106"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402973773813`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0285236e-5290-4307-8054-2e3249aa6037"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "107", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X107\"\>"}],
  SequenceForm["i=", 107, " ", "X107"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402974108047`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"974c5321-0b36-4033-ab9f-20132281b064"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "108", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X108\"\>"}],
  SequenceForm["i=", 108, " ", "X108"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297443317*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b2104916-1273-4a49-a2a8-3419a88facc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "109", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X109\"\>"}],
  SequenceForm["i=", 109, " ", "X109"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297476807*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"906e8a7c-cd7a-4292-9d02-9819f9862fd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "110", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X110\"\>"}],
  SequenceForm["i=", 110, " ", "X110"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297510385*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"02c2637d-9da1-4191-8fc0-a4ed39708264"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "111", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X111\"\>"}],
  SequenceForm["i=", 111, " ", "X111"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402975431757`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4ae733eb-b0f7-4eb6-aa03-abdccf1cdd1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "112", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X112\"\>"}],
  SequenceForm["i=", 112, " ", "X112"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297577352*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e4c28837-f900-418d-bcfd-9bf843ddb36d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "113", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X113\"\>"}],
  SequenceForm["i=", 113, " ", "X113"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297578648*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b6d8e765-9a9c-4579-9c4b-7f7172a5f8d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "114", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X114\"\>"}],
  SequenceForm["i=", 114, " ", "X114"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402976104317`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1f247bcb-a16c-45cd-ad64-c734f0f0f8c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "115", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X115\"\>"}],
  SequenceForm["i=", 115, " ", "X115"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402976441517`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b426517e-4512-436e-b245-dbb21ac9e9a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "116", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X116\"\>"}],
  SequenceForm["i=", 116, " ", "X116"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402976511917`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dd56925f-9048-43dc-81e3-05ace3ebed90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "117", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X117\"\>"}],
  SequenceForm["i=", 117, " ", "X117"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297696891*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a436f191-60d1-49fb-8337-9c3ebdc3c6d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "118", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"r-power point\"\>"}],
  SequenceForm["i=", 118, " ", "r-power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297725699*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d422ddd7-7f05-4e98-99dd-18130da8d198"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297735314*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c7ea991c-ffbb-4ac3-84cc-0e3c46b571ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "119", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"r2-power point\"\>"}],
  SequenceForm["i=", 119, " ", "r2-power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402977651*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a5f0afce-61f1-4fb2-90bc-110eec999199"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "120", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"r3-power point\"\>"}],
  SequenceForm["i=", 120, " ", "r3-power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564029776667*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e8653cda-114d-415a-b8f8-c009279c3e57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "121", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z1\"\>"}],
  SequenceForm["i=", 121, " ", "Z1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297796578*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b7fffb14-9b85-40f1-a80d-31f285927997"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "122", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z2\"\>"}],
  SequenceForm["i=", 122, " ", "Z2"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402978307343`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e79fbc14-bc8e-46c5-bcc1-25aa19092f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "123", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z3\"\>"}],
  SequenceForm["i=", 123, " ", "Z3"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297867634*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"eafb03d3-0323-4c31-8f1c-12df60bd93d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "124", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z4\"\>"}],
  SequenceForm["i=", 124, " ", "Z4"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402979058228`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5bf87cef-d8c5-4a2e-aba3-0595968e162e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "125", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z5\"\>"}],
  SequenceForm["i=", 125, " ", "Z5"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640297947194*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a07eeb8d-b602-4983-87b2-8b872b24dd3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "126", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z6\"\>"}],
  SequenceForm["i=", 126, " ", "Z6"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564029798946*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c0be2871-bd40-4d3a-8a77-f4259b62f03b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "127", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z7\"\>"}],
  SequenceForm["i=", 127, " ", "Z7"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640298031706*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cd46855e-61b7-4255-a709-b4f5d24ca7d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "128", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z8\"\>"}],
  SequenceForm["i=", 128, " ", "Z8"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640298072398*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bc8daebf-b43a-4ea9-9eb1-710de84ba1f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "129", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"r4-power point\"\>"}],
  SequenceForm["i=", 129, " ", "r4-power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640298107225*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d57f52f7-0989-48ce-af38-9807c4387d0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056402981353416`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1860ef45-6d7a-4c32-b8e7-a3691f882b92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640298143173*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f3f39d84-eb6b-48df-9ca6-5c4a5e2de933"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640303723339*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c0d3acf8-670e-4a73-bf5c-3f3484859b84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "130", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"arbitrary center\"\>"}],
  SequenceForm["i=", 130, " ", "arbitrary center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640303725037*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d96b3595-4f85-4d3c-9c9d-14a3da595535"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "131", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"areal center\"\>"}],
  SequenceForm["i=", 131, " ", "areal center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640303753126*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"06dd7cf6-186e-4231-93b2-1a23bdf348be"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.805640304395855*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bcc903b0-d751-4ec1-8516-5cc55c3f9573"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CASE \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"Isosceles Tetrahedron\"\>"}],
  SequenceForm["CASE ", 2, ": ", "Isosceles Tetrahedron"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403043970537`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"592ebb34-ccbb-4503-96cd-d327ff6e6285"],

Cell[BoxData["\<\"------\"\>"], "Print",
 CellChangeTimes->{3.805640304398025*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"81d0dc1f-5a65-4ae9-9a4d-1abcfd5583b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>"}],
  SequenceForm["i=", 1, " ", "incenter"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403044049177`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"15517421-6a45-4fe3-9561-8024996e2861"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403044061604`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"77e69562-687a-48cf-aaea-e22bcfcd90a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403044351873`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0b198c8c-9fd4-4943-82db-fa9a28f158f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304436489*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5b8ef1d4-1f96-4ad8-891a-a787cfaa1aa3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403044375763`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dda277ac-a316-461a-bc76-054c606c7b63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304438838*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f3a49b3a-bfa2-4416-a1ec-297b8c2f179f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304439912*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"006cf50d-60f9-4e68-bc27-3684c5a2c509"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403044411592`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"519f1139-4eb1-4a32-8dff-7c55baea1337"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403044425793`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b622efa2-a101-46c6-b439-ce51281774fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403044437733`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e54c8a72-3f34-4fec-a734-c64adb44d0f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403044448233`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f79354e1-e162-4334-980b-52f84e241acc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>"}],
  SequenceForm["i=", 2, " ", "centroid"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304445836*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"57fa2a91-22b1-4bab-b52c-54f3556c9f5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Faces are parallel.\"\>"}],
  SequenceForm["  ", "Faces are parallel."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304446847*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aaca4b46-ffeb-469a-bfdc-22ed82652d31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Coordinates of intersection point:  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["    Coordinates of intersection point:  ", {1, 1, 1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304447996*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"088b0835-7885-44d0-adee-488c0e5ed228"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm["    Point coincides with ", "centroid", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304448997*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f8197239-2e98-406e-b5ac-826ad51789c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"circumcenter\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm[
  "    Point coincides with ", "circumcenter", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403044500923`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8306fa51-eee9-465c-b93f-84386bcaa050"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm["    Point coincides with ", "Monge point", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304451296*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"73462778-00cd-42ea-80b2-c4795eeeeb3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm["    Point coincides with ", "incenter", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304452298*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3e6c1b17-549a-49bf-aef7-ed72c65287a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm["    Point coincides with ", "Euler point", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304453413*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a7e60955-d35a-4a9c-b7df-d315ddc89b33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", "\<\"Intersection point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on reference Euler line (at \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    ", "Intersection point", " lies on reference Euler line (at ", 1, ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030445442*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"80a29330-31a6-462e-baf7-c1ff7d4ecd0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Cevians concur.\"\>"}],
  SequenceForm["  ", "Cevians concur."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304455428*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"385371b6-8d61-46cb-a775-517cf02c00a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304456402*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1d82838d-ec1f-4401-a1e3-53550475c8d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304457468*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0101d518-c0e3-4fe7-a35a-a013e46957ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304458756*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7466cdde-d6e2-4fa2-934b-e41419b4b8cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403044597673`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"58abb50e-d03c-484b-b5b2-7d2425018e5e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra are similar.\"\>"}],
  SequenceForm["  ", "Tetrahedra are similar."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304460738*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"efab5d81-8966-4ad0-b194-8bc25a32cd30"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304461708*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ee6670cd-79f3-465d-b0dc-34354aeff9bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304462779*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ef2f50a1-c66e-4413-a645-b4cd575d8041"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403044642467`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"69c1ed6e-9125-4184-9b27-e46e1d705e43"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304465456*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dcad4262-c985-4d0f-9176-93387129f054"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304466818*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"41bb4a92-5034-4f2f-871b-b22e0b7b157f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030446824*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c7bc8b46-10da-45d7-bca1-12019dc57cc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"circumcenter\"\>"}],
  SequenceForm["i=", 3, " ", "circumcenter"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403044692707`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d45beffc-cdab-411c-8246-04e69620e0aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304470293*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ffecfd32-4eef-4eeb-9190-8aa56531e703"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304471285*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1b022d58-c298-43d0-b9b9-b128aa30d7ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304472268*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d14e2278-3572-4548-a377-2ff953f620d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304473343*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c1da1928-7465-4a52-86b2-2ec6bee28b9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm["    Point coincides with ", "centroid", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304593389*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"285a575a-6aac-4821-b6a9-94d39e980e2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"circumcenter\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm[
  "    Point coincides with ", "circumcenter", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403045951233`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"018b0eba-278c-47b2-b077-8d743f11cdc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm["    Point coincides with ", "Monge point", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403045962467`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"00f510bc-13da-4f8c-b9fb-93ec92edd99e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm["    Point coincides with ", "incenter", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304597541*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e1551546-33fd-4484-bbbf-244b4ea67075"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm["    Point coincides with ", "Euler point", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304598588*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"34c27977-0d3e-47c3-8112-36b4bab3ddb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", "\<\"Intersection point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on reference Euler line (at \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    ", "Intersection point", " lies on reference Euler line (at ", 1, ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403045996103`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0f491ae0-5973-4daf-b9bc-175ee1d0634c"],

Cell[BoxData["\<\"    4th coordinate of point of intersection is:\"\>"], \
"Print",
 CellChangeTimes->{3.805640304600634*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"59b1b0c0-3a5a-4bb7-9922-08f415cc709d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["    ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304601636*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e819d094-b190-40bd-bba8-4d3a92ed261d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Normals concur.\"\>"}],
  SequenceForm["  ", "Normals concur."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304602902*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8d2d9479-30d6-4438-98ac-945177438941"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304603998*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0a0ec2f0-b6bb-4676-846a-8ef67e19e187"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304605364*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"09f6e77f-f064-4427-8648-e934cdf12efd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403046064243`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"72f26f05-70b9-471f-b9ff-5124470ae963"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304607465*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ebdb69e5-e4b6-4f82-87d1-5c065f9ac4d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304608494*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"27ade93e-4d2f-46cd-bdf5-2e52b67b18d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403046095667`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fd984479-b08c-43e2-8d17-7a5a3fb0cff8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"orthocenter\"\>"}],
  SequenceForm["i=", 4, " ", "orthocenter"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403046108294`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0d363715-8e08-4eea-86f2-e74006e12bf7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304611949*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fc60175a-c2e4-4db4-bc0b-5b3f0566feec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403046416273`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f2e10c4a-21e1-4abe-8b22-86e551aa708e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304643373*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f0eaf316-0011-45a4-b31c-af6315ac940b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403046443768`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"72c0a2b5-0d35-444b-9435-32677009a167"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304645361*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0d5ce6b1-d2c5-4fbc-970d-e1087460cba3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304646411*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8bf15219-94b1-4245-b2aa-9a1c631b8042"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403046474867`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5d6689b8-a928-436f-864b-ea134591105d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304648546*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"73a084f8-dd7d-405c-8212-b997b82883e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304649596*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b2bbff70-3a3c-405f-8e53-fe60d6567598"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304650926*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ec40667c-453a-461d-938f-5190386fba2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"nine point center\"\>"}],
  SequenceForm["i=", 5, " ", "nine point center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304651967*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e5bcf21d-e649-40c2-b6eb-c8a06ca0bea2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403046531878`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8cd78f7a-d022-4080-8dc5-040690544925"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403046848383`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b7d8077e-5546-4cab-85f3-7291205282b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304686151*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3a4818fe-fd40-4c7b-bf28-84dd4d5f315f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304687166*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4cbd9497-c5ce-41a5-9df1-03e00a26bd1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304688169*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bfcbdce1-aa60-42d2-b22c-90d685485894"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403046892347`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"42eb4795-17a7-43cb-9a17-1f62bef44171"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304690539*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f36e44e4-321e-4ab2-bdcf-7032aca007cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304692238*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fd9149b3-1d5a-47d7-8ac0-2c165da9fbd0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304693514*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1d9a685e-d185-4790-ac6f-7d5d70e1df35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304694705*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1c5bf385-c603-4dd6-a265-63c87f859537"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"symmedian point\"\>"}],
  SequenceForm["i=", 6, " ", "symmedian point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304695836*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"924082fc-512b-485a-9811-517e97a63130"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304696968*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7581baea-ecdc-4e6f-a49f-9e3cf8354f03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403046981087`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7ac73288-9c00-42ec-8d00-6c9c87c34a51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304699473*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"06b82576-91c9-4568-aa03-a058d34e6e27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047005053`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e3d86004-7985-40dc-a27d-27c76633a546"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304701518*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"724cad43-6575-478e-8196-2a9a56e5a8d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304702573*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"12eeccb0-9224-4a28-a475-01a54ed5f226"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030470366*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f0416fa3-735f-4704-a880-71f2f4a20f2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047047367`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4e56c23a-0f45-4c6e-b98b-eb419a2e2013"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304705791*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9623f492-4e92-43bc-8d20-c58d12a7854a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304707259*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c9b97b02-eafc-4c7a-ada8-aea504f09eed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Gergonne point\"\>"}],
  SequenceForm["i=", 7, " ", "Gergonne point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304708308*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"26134890-d336-4eac-b33e-1347cdd7f22d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304709301*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"47953207-96dd-4d1a-9e9d-ce4b2f5f5a79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304738407*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2e0a3249-73e7-48a0-9598-6b88d4e5de04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047398157`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bb208f4d-cd6a-48e7-99ee-2cd0f197956c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047411203`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"24ef2105-addb-4376-848e-1477d3bb762c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304742714*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"60f16928-87fe-4c8e-bbe2-d2f064c2b681"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304743904*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"53570a8e-3dd4-498a-93a4-51421c9772fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304745245*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a6bd3ad1-a92f-4f9f-91ce-bfb32127c375"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047464323`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b3835a59-19c6-4f2e-940f-1b3f8899fe17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304747651*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"31f72b85-93d0-4195-8b3f-3406f22a07df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304748869*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"af8c4656-7271-4821-ab4f-729f5b70ef1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Nagel point\"\>"}],
  SequenceForm["i=", 8, " ", "Nagel point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304749887*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8f312120-459c-4ddb-9996-c2e12611a447"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304750875*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"46619af1-8092-41b4-8222-4f9a16da5f1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304751873*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c3f0306a-5cc1-4b61-96d4-5f6022797114"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304752873*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ee6bae4d-e8ff-4599-b280-d4d5425c2287"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304753881*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"35018b0f-5a88-4e03-8127-d1a57fbd3113"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304754903*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3821bd6e-0940-4432-9695-de3174b405e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304756043*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"663c620a-46ae-4374-962c-fc4bc0c120c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304757214*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fee80596-f405-48a9-954a-b0674a4313af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304758292*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e7a19f5c-9129-4d67-8932-150b1fbe525d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047593946`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"28b09bf6-aace-4e38-bde2-296d25fa1b6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304760456*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"61e973b0-74c3-4ceb-827a-d48feebbdc72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Mittenpunkt\"\>"}],
  SequenceForm["i=", 9, " ", "Mittenpunkt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047615137`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d73cf4fa-e4e1-4e93-8a5a-674f8b9bf6cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047625113`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"782d4e6b-6ad0-4dc2-b141-c4d27664b084"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304769929*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"106e551a-c13b-42db-a428-6a615d5af780"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304771283*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fdcad515-afd5-4afd-be09-3add38ede6f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047723103`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a1805b4c-de53-496e-bea4-593c2d5ad32c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047734003`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f94a6327-4a38-44d6-b839-7b709501c75d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047745943`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1abcf482-2c52-4219-a329-2b97d4f01f80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047756577`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a4a1b138-3007-40d8-9b5d-a6e80deb7626"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304776805*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b91d7d06-6806-4fea-ae8b-6f30ef173e07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304777884*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"900e1dc5-3dd1-4f5c-ab55-b598da0e051a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304778962*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"67017ae7-c1f0-479c-94c7-21108d8f550d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Spieker center\"\>"}],
  SequenceForm["i=", 10, " ", "Spieker center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304779969*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"57fa5069-5933-4f11-870e-adec70e46d49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304780979*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a1efbea4-cfc9-4535-ac04-7417424f9337"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047820044`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9dc08a99-59f4-4776-960c-78342903c969"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304783024*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ae30d9fe-bbce-46cd-803f-fa4eb51779f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304784114*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"76f01dd2-7ac7-4353-8056-a6a20a25dfe1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304785337*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"154dbbc9-a8f9-4a51-b1fb-615105d58b93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304786667*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d3b400e8-e24c-4362-9295-aa040a2bce79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047880497`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8677cdd4-ba8b-499c-87cb-f3fcf747833a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047894*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dd84995d-bf59-4e5c-86e3-2965c73fd620"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403047906513`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bd27b767-fb43-4544-b1b9-6d9b8a19bfa9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304791741*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aff9f76b-f02e-4e0b-8e91-d8eb96cb1263"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Feuerbach point\"\>"}],
  SequenceForm["i=", 11, " ", "Feuerbach point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304792816*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"db42b7f2-007e-4bdd-a1a9-914bdcf9f319"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304820943*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"73d0dfd1-103d-4858-92ac-92b5cbbc62a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304829154*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"28c59beb-728d-4e14-9718-463b66305577"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403048306303`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"29ccfad2-d7d1-4a31-bdea-fd37e9ae150b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304831821*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"88b8033b-f283-4444-93b2-10019b98992d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304832877*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c4edc251-8cdc-43d6-8404-8e0dee4a66b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304834207*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1ea2195b-2ad2-4016-930d-2318fa5f4dec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304835772*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"622bceee-cff4-49e9-8fbf-d48858d7f518"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304836882*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"57a70b13-05f3-46b6-81ec-daae5be7e06b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304837994*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bd566519-6648-437d-838b-fa17c131783b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304839135*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f1938957-bdee-4a23-9e5d-eae0a5f46b9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X12\"\>"}],
  SequenceForm["i=", 12, " ", "X12"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403048404016`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f8f03509-ecde-4224-8f80-1689dc0888e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304841441*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8ee7906d-65d1-4940-a13a-d35c64795b3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304892962*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3d6c44ec-b8a1-45cc-a6e8-5bb4e9f11148"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403048943157`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2fde76e0-c89f-4fd2-a2b3-671ee4610749"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403048953657`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d41ed009-4e8e-48ba-99e3-22786382d8ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304896421*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4e443bf7-bf97-40a0-9cb6-95617d8101db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304897543*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c29e3b8f-cd4a-4f18-b91f-256b8da8dc79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304898641*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c7fb733d-3098-40bd-bbd3-fe379a902531"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403048997498`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"87489cb7-a1eb-4491-a08f-ec7f96b8eca8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304901043*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"660c14a5-e350-4c91-9ea8-f126a86c2ade"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304902178*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e9d999a8-027c-4e18-b700-004d5afb1f6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"1st isogonic center (Fermat point)\"\>"}],
  SequenceForm["i=", 13, " ", "1st isogonic center (Fermat point)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640304903246*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"651fcec8-c08d-41b9-a948-6443d930f318"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403049324493`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0916269e-2a70-453c-be8b-22cb87661f68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305153372*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"38056cca-2c54-4795-8ae3-6540260c22a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305184249*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f51ad694-e5ad-4813-a2c9-6100535fc34d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305185557*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cc4f7c9d-fe64-4557-aedc-064e6c5ea714"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403052159777`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1898716d-1cb2-463f-b85a-5b06f5294cd1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305217786*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"89b8637f-b6b0-4aba-9976-388fe12020b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305219475*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"34b5f011-bd95-4d20-8312-a9c9b0c548c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305220717*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"93fff589-80bb-4b6a-af16-e7fea38a7f05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305221849*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"53fd02a6-62d8-4e75-93ff-ceca56af79fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403052229853`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"65b2e5ca-006c-4833-a43c-854f105fab14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Isogonic center\"\>"}],
  SequenceForm["i=", 14, " ", "2nd Isogonic center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305224299*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b233062b-9cce-4370-b7bd-93b3d2222674"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305254344*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"edd4c519-5770-4fce-9188-7c49723485e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403054861517`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7ec8838a-ebe4-4047-9a58-61578df66d31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305519683*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f6b60a06-f8bd-44ef-8fd7-4c5e3619e403"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305521038*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bc124a33-46a7-464b-8927-0b010bb19c66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305551676*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"494b7c6b-c264-439d-98fc-9ff92866c8ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403055533133`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b63c9498-9392-4a0c-a2e9-ce216e4a5af4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305554797*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"071b210e-771f-4f46-9052-7d2342c0fc38"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305556097*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c76adf51-3e43-4048-bfe7-daf343a8d176"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403055573874`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9b156eb4-928d-4c36-a950-23ab6a00371d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305558648*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"96f8e069-d5d8-4407-8ec2-29fbf8088eab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"1st Isodynamic point\"\>"}],
  SequenceForm["i=", 15, " ", "1st Isodynamic point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305559782*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5b1d2c7c-c421-4c2c-b837-7048fba2475c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403055895147`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"296fe6d6-8c96-4faa-abcb-775dfbc65b78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305653819*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"58247322-e354-4b50-affe-d98214af5952"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030568519*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c05e1e5d-d89f-40db-aa99-c797a50c66f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403056865253`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b735b037-c2e3-48a4-975a-fc8e733c35a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305687619*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b6477915-e885-48bc-a22a-effb4dc3ffc5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305688909*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"be36f617-fbdd-4e6b-9f2d-63b48a1e9f8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305690345*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f62f73cd-1d89-49cb-9190-36e44b7d884f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403056919127`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2d25cb4d-01b1-4ff6-bc28-c86286f4931c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030569312*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f5b09a48-9d77-4153-a039-cbc0380e757b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305694415*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e17e2252-045c-4064-a3a4-8eee2556fc17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Isodynamic point\"\>"}],
  SequenceForm["i=", 16, " ", "2nd Isodynamic point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305695547*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5de125ab-bc29-4057-9687-ffa1048a66bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403057316933`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e9be9383-d8c0-49cc-a2f0-053f31ad36ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030580099*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0baf8718-67d5-4bad-b945-b0483ddf4ce4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403058318787`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c72ab441-0ed1-4573-b809-fbd8f9df6b5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305833254*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c3a7ba20-4915-4b2f-b848-dcf366e0946e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305834647*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"672e470c-cdb7-405a-ae84-170f487405d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305835883*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"addb5454-5967-41df-af86-f9661bd1a936"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305837014*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bdc07ad6-08ae-46e3-8e0f-7d1ea3dba5ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305838126*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1bc8429b-8e18-4e93-b73a-bc177a5cf86e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403058394012`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ad5bb9e0-4343-4faf-828f-f82a30b70783"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305848422*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2304a124-cb47-4f35-936c-7b1fb7d9c73f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"1st Napoleon point\"\>"}],
  SequenceForm["i=", 17, " ", "1st Napoleon point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305849815*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6eab3614-9b5f-4e31-a829-df60ebeb01dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640305881503*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3ebd7f30-693f-4189-be7e-5f322703d612"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306089512*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ced4b508-5745-402e-9c2a-258ab6274cf0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403061214933`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fff80452-f950-4f74-b051-6b43f41b9add"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030612287*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b1db4b5b-71a8-4e04-b42d-2c643743def0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306130576*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bc5ebe81-24dd-44c4-a2e7-74e03a54e1e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306132146*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7051ca07-53fa-4c57-8a28-858310fde552"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403061333017`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f198d977-227b-4779-995d-40548bdbb544"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306134419*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"871d9142-e473-4a1c-a847-5f95276d7e03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306135518*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"eb917497-9479-4d76-970e-afa07b314470"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306163753*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3f206d02-9014-46af-b2e0-eb9e7a7e9b55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Napoleon point\"\>"}],
  SequenceForm["i=", 18, " ", "2nd Napoleon point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306165222*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f74e5e08-6cd0-4fc9-b033-e22335d53b79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403061718388`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bf86322f-cdf1-4f71-94f4-53c5bd959ee9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306367805*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f0f9b3ac-2c89-4f79-b8d5-7a63184492c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306398809*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"de8389e2-1e54-44e3-a526-086472f68c32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306400216*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a3674971-623a-47bc-8f9b-2c5fe96f5d6a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306430251*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7e072d7a-e867-4103-83f4-d2224109a0c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306431695*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5227709d-0417-4241-b515-90e6b8d4017a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306432796*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c9e316ff-fc86-4446-9f51-02141dea700c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030643391*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d59358f9-f4a7-4d9b-991c-d6c4f2e9ce3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403064350157`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ca5e7e70-2206-4837-b0a3-76c70f8e416f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306436097*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7b20748b-80d6-457f-be2b-23839f3a1fc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Crucial point\"\>"}],
  SequenceForm["i=", 19, " ", "Crucial point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306437151*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8c166bff-31ad-4e7d-a8de-72d1fc6784eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306438364*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"26d88f46-1948-4a28-aa54-a785e3e1c08b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030647211*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e2f8a269-5c82-4ef7-b4d9-409338ed77e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306473526*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6219fb21-7be1-4e5a-a8b3-39e2d4e36218"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306474759*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dca87842-e130-4353-89ff-b2b5670ee7d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403064761553`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"436aa17d-8852-456b-94b2-a36bb5c52fff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403064774513`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9803aad8-c55d-4b23-be35-320134d8c212"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306478701*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cac6126a-c79a-49c1-8b36-37f9df40ac64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306480102*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4ba913b0-3a08-4844-b06c-f815783d353a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306481635*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d106d332-7e48-4a97-a326-5d8b5ea2228e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306483287*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"af9a7f61-5ff0-4226-81d9-161259502696"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"De Longchamps point\"\>"}],
  SequenceForm["i=", 20, " ", "De Longchamps point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030648447*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"013f6ae1-aa58-45bd-8009-9ac2905c9a64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403064914494`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6f2e1ee8-3c94-478c-996d-b3c8c8492411"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403065214977`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ff0ec5cd-3384-486c-9737-e9d7d691a559"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306523003*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ad47ce65-3c34-4085-8579-fcf892547aaf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306524238*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f7d000a5-fdb3-4b89-a261-bf25153bc5e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306525654*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"60f0479c-409f-45fc-8052-e6c76d282af4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403065272617`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2fcdb3a6-5dd9-44ca-86a1-ac08804666c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030652851*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"50948503-bd8f-400e-a2e6-8b43b57c55b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030652969*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"041f4054-ea45-4007-91b1-986beb8018d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306530846*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e617e75a-81e6-462b-977f-73ac770eee8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030653203*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"32c46a01-749c-4876-a840-472838b7ea0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Schiffler point\"\>"}],
  SequenceForm["i=", 21, " ", "Schiffler point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306533113*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0bfe7bdf-d666-4e8d-a043-ccbb972bf32e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306534196*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"452a2470-aba9-4879-b21a-20330d80e55f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306570311*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"53c56f0c-956a-4217-9392-d421ad35ceaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403065717773`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2f4f034b-9ac4-4f9e-abca-3f029086db0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306572863*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9a938391-c83c-40c4-9116-e3f85171c495"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030657397*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7ef80ed8-cb28-4c0f-b8e6-f5bfbd2b72c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306575377*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"240ef66f-07ce-4125-855a-b1efd26723cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306576858*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"42718ac8-02c3-4321-bb67-1dc619ad42fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030657825*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"205616ee-a9ff-468a-8784-0a0616ec6293"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403065798693`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"15c34713-3030-443c-a07a-507842b80412"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403065810966`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7dc7195c-0cbe-4899-abb0-647263e02021"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Exeter point\"\>"}],
  SequenceForm["i=", 22, " ", "Exeter point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306582182*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aee4829e-a15f-40f3-9982-ef04fb361345"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306588921*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"71d6b433-7433-4630-b0a5-1107627a38f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306617824*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3d8943a6-4a36-4ee8-9bc4-46a1a7cf6c08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403066194153`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5ab31e40-d036-4109-a4e3-6c270f5a814c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403066207867`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6e020ce3-1d0a-4e87-99b5-52777bd24ec8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403066218967`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7cb987b8-ad96-4334-961a-6294e0f468a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306623011*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e0e67b5b-4f7d-460c-8540-1c86427c064e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403066241693`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"35808870-36ad-4275-9ae0-41bdc292f02a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306625308*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5a834c58-b434-4a19-a9b9-75cc028cb0f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306626734*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"14dfb074-8cd5-4949-a36b-3291ea62b185"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306627984*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d0f44a9e-7870-422a-81d6-75c8b677a86f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"far out point\"\>"}],
  SequenceForm["i=", 23, " ", "far out point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306629117*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"488b3311-1040-48b0-bb45-fef1306c7655"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403066302443`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"37809e15-3c1e-4976-8c3f-0109b19dc469"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306659127*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aed38044-45f6-45fb-856f-eb7c2d7aa7d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403066605873`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f600d0a3-30db-4c9f-8833-8bfaa08cf902"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306661683*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e1a0a31b-45c4-46d7-b710-736407e59c71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403066628304`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"14d91e4a-a1e9-435e-a0c0-a0971d198818"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306664187*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"828b17ea-d983-4f8e-810a-3d8e54054a70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306665389*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e1306c7b-7375-48af-a9b1-29201847adbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306666521*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5b770dd6-9433-4fe1-a813-248ca4d5ec82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306667635*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2522d057-c75b-4a2f-9200-8db85fe64c6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306668746*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8210e558-e2e8-42f4-95d4-84d645792478"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X24\"\>"}],
  SequenceForm["i=", 24, " ", "X24"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306669794*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7beec9c3-96d9-4443-bf0d-f832849f5f49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306670879*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4022eab6-1bad-46a5-a1a3-450c886acd9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306735072*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"66eff67b-9350-442c-b7e1-0723638f1690"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403067421227`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9fdd136f-35e0-47b6-b25c-6e5c4ddc97dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306743535*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"258be43a-2dfe-4fdd-8e5b-e6b70023d70d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030674465*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d88c33f4-8c2e-4e59-9116-5265808d88f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306745804*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9536ed40-38e8-4c15-9c3c-d123c614d21a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306746991*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"926c090a-b0c1-4c1f-9123-a5d190720581"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403067482367`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"68c30491-9d82-4803-8a83-3731074f2938"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306749414*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2496d30b-7736-44ca-88dc-4a2eeba64440"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306750586*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b710179f-212c-4c0e-b4d3-580c625bd042"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X25\"\>"}],
  SequenceForm["i=", 25, " ", "X25"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306751718*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ff31147e-78aa-437b-a157-edcdcb68ea77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306780279*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6b00c73d-bafc-4e9e-af26-ac0abba2a62d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306813953*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"32595ea0-d3d7-4a6f-84a8-264c9e363814"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306815734*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4854f0c1-d690-4e08-be36-64f948907887"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306817099*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1d6dbdde-1c59-4a56-89b9-ed2e171799cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306818272*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"68c5b7b3-5c2f-4581-a10f-215cebaa1d74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306819483*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a506cb53-f7e2-4d4c-818b-3742e919f51d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306820704*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aa97d7f5-feb4-4814-9b93-6209910121f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306821928*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"41e322d4-8527-4d47-8c8e-0bc462967e12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306823125*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b351f986-8da1-4996-8f78-2fa5b5c7028d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403068243732`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b4988dc9-4d29-4cb7-a744-74b729e34c31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Circumcenter of tangential triangle\"\>"}],
  SequenceForm["i=", 26, " ", "Circumcenter of tangential triangle"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030682583*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d7b091fd-42c4-4625-8216-0499626210bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306827177*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"24d70559-6607-43f7-8219-f0f7b7a654f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403068868837`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2800d0c3-0220-41c5-8836-e9aab8881b46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306893805*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fca7ec23-f3de-4a74-831d-5f373812f83f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306895496*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"94bee697-97d1-41ba-8b81-509bcc52aa4e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030689707*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6e7216c3-775c-4505-9b53-cdb16402dc7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306898387*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f03760ba-5cbd-491c-8788-691345c5ae83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306899626*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fb963cae-ca39-4142-aeef-62ae573931a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403069010067`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a6836856-51dd-4d63-8505-aceb319bfc00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306902821*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"25faba90-6f7f-4934-8adf-2e67053c00b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306904484*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6d21bbfc-1c43-498a-9b12-8b7f182e53ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X27\"\>"}],
  SequenceForm["i=", 27, " ", "X27"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306905673*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7a970ca9-b862-47a0-b580-1e10375e7ec5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306934073*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4e0654d6-78a6-4434-8df2-1cb70cc53983"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403069826603`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"07044cc5-f888-4734-a440-8501cc1a586f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306984131*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b7fd8abe-09b8-40a8-8ecd-9b25359267b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306985261*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"afaebaa6-544f-476c-8e5f-b684fc5d745a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403069864073`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1719c5e4-17cc-4381-a37e-c06e3cf0c488"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306987586*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4f8358ba-1765-4622-8538-fae2518bc3f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306988847*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"23838210-91d4-4acf-887a-bb960cd57f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403069900227`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9635793e-a56d-4e24-b50a-5176da5f4338"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306991414*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3bae9c31-6637-4235-93e4-ff0349d56931"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306992635*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"507050f6-a914-40dd-bc2e-2e370dbc2c31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X28\"\>"}],
  SequenceForm["i=", 28, " ", "X28"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640306994223*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d11a3965-fdba-453f-9682-c177bc4fbe9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307001363*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b5612c72-0769-4346-a937-9a8c7e46f5e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307077985*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6f4609df-2507-4a8e-9d21-ca7cd553b385"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307084847*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f2489cec-622c-41be-9337-188df7988a42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307086275*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"70d98cc7-18fb-4052-b10d-55ae214eeaab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403070874434`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c65a90e6-278d-4fcf-a5b6-6cce5b6345ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307088678*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7bc86fb0-8a0b-4b5f-af4d-76ae07d2c249"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307089979*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ac15ec5e-404b-4062-9677-d7a34a199f2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403070912237`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"08cd46b8-0546-4456-9bcb-1b6b508026a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030709245*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"92f7fb75-52c9-49b1-b785-cb22d1e5d6ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307093687*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"96feb088-6436-4e81-9b7f-a3f78865cd6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X29\"\>"}],
  SequenceForm["i=", 29, " ", "X29"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403070948753`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"58dddcf2-4a72-48c3-ab8e-ae5cec88737b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307123391*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"124a3eb2-a06e-44cc-a2a9-93888d2406f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307192718*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"eba9b547-eede-4ab0-941f-83ae1eb49226"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307199724*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8c4c81b0-9f3a-4641-9969-b6a944252480"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307201161*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"258912a5-04dc-4f69-a048-619e17a6d850"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072022963`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0d3bc3cd-6ddf-4c04-b01b-6426432158b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030720382*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9aa41591-def0-445e-ab71-15f1d2e21218"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307205118*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1a767907-d71d-4958-a7fc-0c1ca36d6c81"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307206379*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d024c396-12eb-4e11-8fe6-3eb2539f55be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072077227`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"24f13d4c-68c4-401b-a180-410d3c7356b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072089243`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3358f23a-dc16-4b97-901e-f915dd7fef79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X30\"\>"}],
  SequenceForm["i=", 30, " ", "X30"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307210033*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7bde9d56-ef8f-4717-a89a-ee2de93c2099"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307211144*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a8992639-0443-4405-b477-c2903d561449"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072399273`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"672b805e-e377-40f5-abe6-83be31a6787d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307241468*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8c22ce1a-572c-403a-9cd5-15f9942310b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307243031*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7d0eff68-6295-477d-967f-e3523e1ce724"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072443933`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f3f41d58-d67f-486f-94db-0da6c031987e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072458277`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4b429f7c-92d5-42b7-b128-4eee7cd57ae6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072471447`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e9fe48d2-6eac-445e-ae67-bb049d8b2c45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307248369*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"859ab30e-53b1-42cd-91f5-7109bed9e4d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307249695*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ea5b2281-22d6-48f7-bf66-6da224eff8cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072510443`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d605f964-7f9f-4d2b-b5cc-e9f1174701d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd power point\"\>"}],
  SequenceForm["i=", 31, " ", "2nd power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030725219*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"346e9c9a-e7f9-4059-a464-47246ddee634"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072533503`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7a9e0282-67fd-43db-add0-692c8013bda1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307254519*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"78346684-0b03-4dbb-8354-cfe3c8e3f139"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072556543`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3ced9a2a-da44-4b97-8184-8e3a445764b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072567873`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"93c529c8-5d58-482e-adc3-3ac93af32276"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072580433`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3f92c077-3358-4501-a274-c70f727e3e57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307259284*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9ff9915d-9713-40d5-acc8-b56ea7b8a2fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307260755*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0c7af62e-5680-40b0-9a70-5e633e726550"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072621403`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8a56944c-d0f6-45e1-9b21-8bb82fe97046"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307263379*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"911fb292-2e19-41ec-af90-90816881d7ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307264656*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2e9279bf-8f78-4406-8fb4-e646506b9117"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"3rd power point\"\>"}],
  SequenceForm["i=", 32, " ", "3rd power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307265942*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3976279b-22aa-4d20-9ab0-e3faa7a8194f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307267107*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"87b913ba-4f8c-42b2-9dd4-9187708df555"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072681923`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"adfe97cf-9855-4468-82a4-49b9b0ab9c5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072692966`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"01b8fad2-563d-46d7-a62d-eeedb6e0bf91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307270371*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7b30751c-3552-4e1b-afcd-08eb35827a5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307271491*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e91ef356-03ce-48b5-b87a-2ff0ec1b6a83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072726603`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3cd5603c-ebc8-4cbe-8f75-3078fbddfc83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307273829*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9a1a24d3-f54a-486d-951a-1e7495afac96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307275031*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"14b0c91f-f795-4539-b732-429a71623298"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307276217*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"136b8062-9d00-4503-ae5c-f4365857b066"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307277399*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"150f9a8a-2869-4654-b5f5-8ef53800c779"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X33\"\>"}],
  SequenceForm["i=", 33, " ", "X33"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307278522*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fa938e77-a293-4b20-b8ac-9126a3f75716"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403072797937`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"15296b47-8897-4b0c-b5a6-6916294f2d39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307332613*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8fe8f674-1e76-42a2-a7b6-4f200ee01cd9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307334132*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f9dc5a7a-e237-4178-8a0f-fcf2419707d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307335483*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c7954fec-a356-4647-b836-f52c410dd8cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403073367357`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"72ae1724-f501-4bba-ae1f-365de9044c05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307337986*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2e8f5c3b-1807-4fb9-8568-f82179f895be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030733921*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"093ae0ca-8d76-424e-959c-0410a61e42a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307340643*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"874df1ed-9bbe-4cd3-bcd2-aba7df29dd7a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307342044*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7090a5d2-af4f-4db1-8ed8-92035c8e5cf9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307343554*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1875e9f3-275f-4c57-bf6d-aee76c747797"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X34\"\>"}],
  SequenceForm["i=", 34, " ", "X34"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307344863*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0666368b-36dc-434f-9bb5-7e69cd84d1a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307352107*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a92aadb1-9355-4547-a9b7-facda385312b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403074398317`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d11afdb8-d68b-43b4-a8aa-352ee955c755"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307441349*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0347873b-6701-4f27-9f78-d539e2740b22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307442531*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6baf6fd5-ece0-4e4c-81a5-97ce6ce61ca1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307443677*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"22db72b6-4fcc-40e1-99ea-fa5c6a5e5bcd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403074448957`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2923cc89-d594-4e22-b820-850e6808473f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307446106*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"944ac936-3ed5-434d-a4b0-63dff53d147b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307447537*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1e131cd8-315f-4aa0-b9ca-7fe26cdbc977"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307448778*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9198e292-7d1b-4d4f-aef8-77eac4990625"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307450225*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1511f490-0893-4f4c-8bc0-e688adccfff9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X35\"\>"}],
  SequenceForm["i=", 35, " ", "X35"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403074514427`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f3009ec7-c565-466d-8456-dd08756f3a50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403074584303`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"37477112-af66-4cae-aba2-d1238b325e27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307487726*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"522495b3-998a-4925-8182-4e2a4f3389b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307489255*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7572031b-6d58-4a62-bd32-b7a6b37c8768"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307490851*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9955e781-5a5a-432b-b110-6e53b9f9a88f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307492502*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2f461845-3090-461c-a65b-a6ce0eb3e58d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307493947*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"868274f1-ceb5-4ca8-aa22-ceb9174285d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403074959917`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"551e7a6d-a3ba-4db1-b608-18495a7d2011"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307498043*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f004fa77-c659-418c-9d4b-207585367998"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307499453*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"448ae6b3-743b-4de6-b232-d22a45768a32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030750072*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0ae27024-454e-454d-a6ea-a9e90106c89e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X36\"\>"}],
  SequenceForm["i=", 36, " ", "X36"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307502129*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1bb8fd5d-844c-414a-8a0c-d7e37a7e3966"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307503303*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a36c1f7c-68f4-49d5-a09e-6e12334ce5ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403075337267`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"eb4257a8-f8a6-407a-b9ed-401dde9d0ef6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307535262*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8c8a5983-945b-4521-8f7c-476d2f7cf809"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307536628*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e68fb0b6-8e2a-4797-aa1a-c02720b23234"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307538453*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"855ee069-99f8-4ef3-a468-44566a240650"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307539846*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"95ff4e3b-f546-4eda-a709-43c56f0adcb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403075413933`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5a4a5c0e-d2fb-4e98-ae41-7c9a1d9443c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307543054*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3ad9f830-a259-4c3b-bd24-6c9d356f04fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307544581*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aced4ac2-edc3-4b39-9b2d-42844291a02a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403075461407`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dc1323ea-af57-4a47-ad08-d52430eb171b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X37\"\>"}],
  SequenceForm["i=", 37, " ", "X37"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307547406*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a70a2181-9c34-48b4-b646-2777b4b2420f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307548585*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5cf653a0-7f4a-4f79-812c-a0ec22350239"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307579052*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"34ea84a6-a2d3-400c-a398-1d788dd54bbe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307580653*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6ebd473a-f1c5-47cd-8309-9eabc199ba23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307581863*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"233fcb80-5f1e-40dc-8ad5-aedc93015459"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307583022*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1c918074-f9e3-4190-a871-d62168253641"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307584222*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a5287ea9-c27a-47dc-ac06-9ac45ac86c54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403075854273`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a21f6d64-b8f5-47b9-af5c-5dff164424ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403075866423`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8d1c9fc9-e53d-4426-ac75-f3a0bd681a7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307587854*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1b43bc71-80c4-43f7-b0f6-a18b26c57343"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403075892267`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"31b367fd-a4a4-484d-bc7a-e6ee32291ea5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X38\"\>"}],
  SequenceForm["i=", 38, " ", "X38"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307590436*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"100feb4b-b453-44a2-a7f1-2d4a5205cecf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307591744*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"212f1387-34a2-4387-87ae-14568a95446b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307593454*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"79a4fe08-faee-4c63-9225-2e0e7a4bff30"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403075948067`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7392d03b-9976-4bc5-bc7d-ba28176842e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307596105*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0b237c8b-ffe6-4c89-9a44-57447b95205e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307597361*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4a92d001-e12a-4e87-bb52-caca928ee559"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307598867*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7b0a3e38-a751-4e9b-8ea2-3e95899306a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307600181*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c96cdfdb-9d7a-4eca-aa23-8d2c0a62004f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030760142*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c08cd08a-a58c-48cd-a03f-c16a2145762e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307602953*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"36373791-c874-4b79-8626-ea97b66885e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307604244*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5b1571ef-254e-4257-9f43-1dbd679d46ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "39", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Brocard midpoint\"\>"}],
  SequenceForm["i=", 39, " ", "Brocard midpoint"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403076054153`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"907d4118-8243-4cc2-b951-e261a6ace5a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403076065893`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"799354cc-bb98-49aa-a15b-b95a821d695b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403076137877`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bc58c1b4-c79b-4f18-8e9f-0f42d8394010"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307615259*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b854f3bd-8b08-4f3e-935b-3116e99e7562"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307616745*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c8004efc-431a-4045-8b3e-313133d0bdd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307618414*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b125316b-ae6a-4022-9b8d-97d7025a2a0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307619811*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"420188ac-bbe4-4b82-9092-cc535340f57c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307621213*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"44ff0029-03d0-49b6-baaf-4b525d122965"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307622661*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"30a4df86-b3ee-4478-af87-59478de3338b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403076241083`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e28e5c28-4652-4e00-a9a5-ffdc26c8a2ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307625404*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a8f2042c-5a46-4ffb-a4fc-7955c75f0ddb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X40\"\>"}],
  SequenceForm["i=", 40, " ", "X40"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307626589*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1a6118be-6d7a-4b36-a04e-104223464fa2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307655387*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d2c8b3aa-955a-412e-80fc-b17a3401dfca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030769175*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"59616deb-97fc-4a34-b19c-82047fe3de58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307693741*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"312d4497-e12e-414a-a730-aa5355a66298"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307695095*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"50ec1208-b234-4160-93ce-b34093e92e53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307696766*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5c246103-1c84-4dba-9c8c-75b8a166a321"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307698051*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"edfcd311-9d59-4e15-9cc8-6105c2d609d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307699396*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"05ecc36d-55a8-49b8-987f-4a4e1b578b7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307700697*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d92b8f69-0a0d-47bd-8efb-e7a7a4568292"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403077020197`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ac72be8c-fb91-4af2-95d0-478b4a48c7c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307703402*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f1bb1686-bd33-4b7c-9dae-5a05fed4a303"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X41\"\>"}],
  SequenceForm["i=", 41, " ", "X41"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307704587*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"705f9c67-7b77-45c9-a37f-1f804e1ad3f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403077057323`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5f8578d7-0b9f-4019-97a8-d6e83c92496b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403077356586`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ed7040fe-8e49-4ccf-b025-e79bd277cdcc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403077372513`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"09ff4cbb-4bcd-4722-8f02-d3077d7d5161"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030773876*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7ad9916c-bbdf-4a5e-90f8-c76477d0f0fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403077402697`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"77808e15-cea3-4f25-8f39-47bdd0999b8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307741542*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4462f12d-d97f-4fbc-8916-42c331a2e927"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307743039*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cd68e8ea-fc08-4a8b-9912-e2f50e81e829"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307744438*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"57188cf1-a941-4f40-8e0c-eba1b93ff007"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307745757*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"513450dd-925a-4ad9-9e9f-751964cb22ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307747052*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"564e1ab5-35c5-4386-b573-c866a513dc9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X42\"\>"}],
  SequenceForm["i=", 42, " ", "X42"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403077482767`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3c60a577-1357-4014-96df-0a8611f34512"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307749546*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b107d48f-5063-43ba-8820-7343342afa46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403077798767`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5e779624-0523-4702-ae75-2539ea527dea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030778144*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"61c0ae7c-e549-4b94-95b9-169e1f305f08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307782634*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"92ba5cb5-e825-4b25-818d-593920696196"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307783832*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e12fc74f-fadc-4c87-97bb-d3988439b51b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403077850637`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a0214705-b6a6-4601-be6d-cb12759decd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307786501*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"996b7165-0579-4410-b786-4a4c288e8a1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307787773*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5564ea93-2344-4416-8d77-d6fdb9b2a29d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307789021*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"047818c5-5692-41cd-9ad4-94fb20149dce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403077902412`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aaea8ae0-5592-4005-8782-357e09f8c38c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "43", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X43\"\>"}],
  SequenceForm["i=", 43, " ", "X43"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307791461*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"85e3b5c8-3aec-43f0-acb3-77ac4eaaaadc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307792863*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dd62973c-1d51-41e0-86ee-1ceebc402d48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307800644*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9770694a-6062-49d7-8da4-dcf0010b64ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307802174*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ff14ca64-fade-40a2-bdf0-65367080e3f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307803834*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"915970ae-595c-4f2e-afc1-e3a8327104cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307805077*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"705f82da-bc19-409c-bfc7-c9a185800592"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307806382*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5313ea2c-03fe-448e-b26a-c004669cad79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307807705*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"09b5e3ff-5e18-4a98-8972-952919c44657"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307809051*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5f10d869-6087-4c4f-a3a0-768596419ba2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307810773*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"26681f4a-22c2-4a7e-a880-cec9de7a880f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307812125*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"40418468-a5de-4c79-9862-f604c90268ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "44", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X44\"\>"}],
  SequenceForm["i=", 44, " ", "X44"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307813341*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3f338686-9aa9-4371-a4ac-068771417c09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307814509*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b0060956-a38b-4566-8569-489dadb28464"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403078442907`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"026f050e-a29c-4c1a-a383-3cac3f8fef95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403078461123`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5b5f6e54-5b8b-44c6-b4ab-5a4bf000142f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307847335*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"586d9a26-59f2-409d-bf74-ae0d7d390177"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403078485613`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3575acb9-3fc9-4368-8831-22c684c0824b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403078497972`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"272fbef3-6460-474c-9a76-900bd76af200"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307851054*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ae7f2eb8-b92b-41cd-9a1a-54cc33129c1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307852404*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"907f20b6-c237-4c31-a67f-7e2f78136eaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307853853*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"21c00b10-619b-4e30-86fd-957bf12d5c77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307855147*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f29917e9-c858-4507-b5f2-aab0524170fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "45", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X45\"\>"}],
  SequenceForm["i=", 45, " ", "X45"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307856368*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"53c1485c-9084-498e-8f2b-d1ab8acf029e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307857616*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"eecc0689-60f6-4ff1-9580-4530a73866c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403078890133`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c6f5c7bf-1552-4654-858c-de039f974a05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307890957*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2779c2ab-4bbb-4938-90a5-fa2682a56d7a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307892568*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8d425469-888e-4d2e-b0a0-9c9c58679edf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403078940277`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"47ca9ed4-a326-43f1-913b-9dd4f9aebac2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403078955727`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1e975da8-a522-4fce-bde2-3e380cd7de35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307896965*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9c00a80a-692a-4a0e-b4ef-ec974c090949"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307898498*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f5bcc23a-846e-417b-8399-3bae0d37a75d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307899864*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"477058aa-197a-4cdc-8787-50f1a552f689"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307901224*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8ffa2a30-c562-4ef1-9284-5d8d599ad13d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "46", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X46\"\>"}],
  SequenceForm["i=", 46, " ", "X46"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307902565*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"982d1b3f-f8e2-4499-98eb-63eaaebf24f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403079038754`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0b1173ad-2e26-4cbf-bddc-579957118772"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403079405937`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9f57bdb4-46e3-4f89-8ae4-83f13190829e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403079424*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"16cbcb61-7984-4130-91af-b27ade6f73a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307944021*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6b23db4e-8bda-4ad1-87c2-10f96f211e52"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403079457073`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6c54d31a-3a52-48a2-ab53-8de083fa1671"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307947542*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"680f1fca-4f03-4557-b9a7-2b55c08788b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307949192*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"036b8010-c451-4974-bb0f-5ee9903ecf70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307951096*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7ae4d2a8-3b0e-4b48-bc8e-b3f5aa5cad40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307952445*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dd2b573d-244d-4643-a4e4-e93c0dd97d53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307953865*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3175eaf5-0f3b-4a0c-8cae-6d2ccaeb4e76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "47", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X47\"\>"}],
  SequenceForm["i=", 47, " ", "X47"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307955328*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a5a28597-c0e5-44bd-973f-60959d79b9d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307962166*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"62547833-0217-45c4-a82b-6bbecf4211da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307997964*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1aa17849-58bf-43d8-9b9a-20989a56aea5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640307999631*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e0875617-8c46-47b2-9fec-cb197764fd62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308000916*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"306f67fc-558f-498c-b02f-3a279e38a905"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403080029707`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"34f207de-ef66-4822-b8be-6a8765d1693f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030800456*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f2ffcd1a-9edb-4616-8301-68b1531d0c4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308006069*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"87acf3d5-58ed-4ebe-b5d7-4f4a591cfc56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403080076323`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4590bbe6-8b91-4731-bb42-f26232505408"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403080090218`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5f1dab81-a40b-40b0-8389-6f41c9d2f3e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030801075*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"001c7259-3629-467a-91e8-d584e450cb71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "48", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X48\"\>"}],
  SequenceForm["i=", 48, " ", "X48"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403080122747`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d1ccd562-4beb-4f31-85ce-479274c1a965"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308013583*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0edfd185-800c-4a13-a42e-857ee6c0bcdb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308044189*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cecd58d2-b4e9-4083-89c2-9afc80e9a54e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308045842*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0e7f930c-db53-49c1-8879-33920b60f8f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403080473013`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"12bb60ae-bd94-414e-b8bc-e3c0b64ae60a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403080487947`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cf904d39-718b-4beb-88d0-62cfd86b8325"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308050453*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0fa0e552-0fb8-407f-b675-33ccbacf562a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403080520277`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cb7c667c-46be-4bf5-af58-db63d4fd3e16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308053423*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4986e1a0-2309-4f5b-a922-b164b966f892"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403080547123`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"300491c4-390e-4f9a-adde-89db51317c90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308055944*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d238b4e1-5858-40f5-ba49-0a48f517fe26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "49", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X49\"\>"}],
  SequenceForm["i=", 49, " ", "X49"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308057138*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7cac8c53-06dd-4101-8913-825ff1a34c4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403080586767`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d7fff6fd-460b-4bda-9415-8206941310df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403081034517`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"356a3b5b-3508-4fed-8375-c34be84cc357"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308111618*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"376e1cbf-218a-4523-a338-e79ef02c10f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308113288*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"07c43dfa-5d09-4669-bea4-5224678f8763"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403081149673`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ef38924e-a807-41b9-ab99-a3d543cfb464"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403081163816`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"06454bf0-2145-4d63-8d67-eec0b4f3d237"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308117774*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1148301c-c53f-4118-8ee6-fb24722be909"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308119173*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ecb331b5-e26e-49fd-b50c-ce6bd44fce31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308120563*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"91d026c8-9c1e-4c1d-8715-bb7959e3092f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308121851*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"62d6b3fe-95a6-439d-8071-49cd7cfff22b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "50", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X50\"\>"}],
  SequenceForm["i=", 50, " ", "X50"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308123044*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f0b76755-3953-414a-863c-e544942972be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403081242437`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ea4098a7-ff0d-4a0f-8d63-c882319fb1c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308168379*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f1c0ec96-cb77-4881-814d-255d9222d567"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308170229*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4039e9ff-156b-481e-8477-1edf55f60fb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308171728*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2aa99751-d31a-42be-a02c-4ffabf336fd9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308173378*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"baef3254-0603-47a9-b783-4ba2b37fd0dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308174839*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"65c7a310-16b0-48b5-8ef7-5e6cb559fb20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308176271*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c6be96a8-06df-4efd-9087-30ec83c1eb9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308178378*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"11b666d0-11ae-4380-a9f2-25b8c6777514"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403081801643`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f26da6a3-3e81-4dd0-936a-700966681e2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308181573*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8fc598db-c099-4f0f-a341-533b7ae928f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "51", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Centroid of orthic triangle\"\>"}],
  SequenceForm["i=", 51, " ", "Centroid of orthic triangle"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308182871*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a3015aa4-c53f-4c00-880c-633a1709dcad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308189769*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6c478beb-ffe3-41c2-bd20-0a4c48d4b7f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308219342*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"84cd8ebf-3625-4d42-9ffc-d8970573d63b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308221376*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1367a6ae-3cbd-4cfc-9568-722ffa980bd0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308222649*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"46907dd9-539b-4b07-8b5c-2b8df457cf3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308224244*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"63c47743-4100-4103-9c29-49925fb773c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030822657*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0c3e72c7-6e22-4509-8989-8cedd744d651"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308228204*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ba2f1972-4afb-4110-8918-ba53ef6ae5a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308229637*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"83554954-08a0-4c40-90ba-12163b29955f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308231172*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ccfc3bff-42f2-427b-b758-2704567a6254"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308232666*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2c59faf9-aa99-4bc5-b8a2-78e891779440"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "52", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Orthocenter of orthic triangle\"\>"}],
  SequenceForm["i=", 52, " ", "Orthocenter of orthic triangle"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403082341537`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ed6b4813-7868-4163-9fe2-8672bb3705c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030823561*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c813c0b4-9bbc-4e4c-ac84-964b02d69607"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308292756*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0b143da1-57e1-4ca7-9e79-f1e79aae44d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308300704*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3ccc2d83-c953-4fe0-acfa-39a5378424b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308302663*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"972910c7-5274-46ad-bf9a-3e5dee1f42aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403083041363`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"686ce801-dad0-4878-aee3-37fcf32e7780"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308305539*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b53f2398-0b03-48dc-ad16-f2fc29689106"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308307249*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"26af4de5-e282-4115-b22d-3c7ed262fb3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308308733*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"51982bfb-6bf0-42df-80ea-993fba229838"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403083101187`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4ab49c04-c0c0-4a95-a036-78cb8cd2a1db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308311516*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9266c6fa-dfd1-417a-bece-dbac97a1430b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "53", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Symmedian point of orthic triangle\"\>"}],
  SequenceForm["i=", 53, " ", "Symmedian point of orthic triangle"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403083129272`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"73f879da-6004-4f39-af37-9c4fd326d60e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403083144903`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"962904ff-4feb-4547-983e-7427b70ff537"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308385645*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3076186e-4b33-4444-917d-e276202d7421"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403083931103`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"38362787-536b-4707-8d35-e3a3e7147f6a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308395053*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8f80d9e4-72de-4f03-b5d5-0ea73f8df724"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308396488*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f89ba98d-698b-4e77-bbd1-9cad8d63f450"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308397822*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2d16d478-dde4-4215-9519-90b48b91657b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308399166*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"839df755-a90f-4b51-a8e4-4e528a5e71fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308400504*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8f11c904-471f-42ae-919b-4587a07eabff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308402231*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2f0bfc44-22d3-45e4-b785-63c347ebeae3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308404079*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"084a9865-afb0-4db7-9b55-9700b2edf30d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "54", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Nine point inv\"\>"}],
  SequenceForm["i=", 54, " ", "Nine point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403084054613`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ded3a7e2-dacd-467a-92e0-f4b18ec642db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308435205*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"99b82019-c19b-4a0a-842b-01f13c7f5625"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308484375*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e2fdd7b9-0d3e-42b1-8fad-29d917d83d51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403084920053`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"19de4f0a-892d-4f79-a1d4-69a8122b47ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308493661*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"84fd71dc-5eed-4740-9854-da32b5eaff5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308494972*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ccbe258e-c811-4ced-9bf3-bf891b1bb756"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030849716*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"99d2c2ea-750d-409c-8b08-97dcc412f775"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403084991703`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cbd74b36-b896-4c98-8ba9-15d0a2928a8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308500641*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b6c97f62-1bdb-439d-9a2d-2031da8ff4e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308502236*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1dc9500c-b3e9-468c-adae-01d73c3f78df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308503654*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"60c6872a-2cb6-4870-a25d-b3c6bd60e8ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "55", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Gergonne inv\"\>"}],
  SequenceForm["i=", 55, " ", "Gergonne inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308504899*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"17708b9e-671f-47ef-941f-3fa45037fc53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030850633*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d017497f-2c1f-4350-aad9-36b49274eb37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308536584*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2a013624-a9e3-4205-a11e-96629d3adec0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308538555*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6e2fc6b4-9040-4015-b51d-9968730eb379"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030854009*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"461b5d1b-926b-4ef4-abb7-9265274e8e18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030854141*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e10d3ef8-68da-4301-8ea2-6c9bd09f7f08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308543141*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a7feb013-10b6-455c-9510-5cc2c2c70f13"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308544598*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"93d9d49f-33c6-46d0-80f2-7c87817c6a4f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030854615*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"03228898-7652-4fee-8cae-5c1d0c50e70e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403085477543`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c15fcf2b-dd9c-4431-957c-9fa44f7be2f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403085492*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"60ce9b21-4729-45be-8e8f-0658f6d87c91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "56", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Nagel inv\"\>"}],
  SequenceForm["i=", 56, " ", "Nagel inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403085504837`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5021097d-6ce7-4b43-a146-a9a08575fa98"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403085517797`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9264f53a-9206-4d2c-aa2f-9ea540cd1935"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308582123*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f2468978-1b97-4de3-aa56-c278555fcc49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308583825*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"54d62a1e-6d28-4612-9ed1-2f981ebcd6f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308585123*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"31f13255-6208-408a-9288-2acc4c4a7d82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308586734*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d87f8e50-fae8-47ea-9bf3-e482d98c60f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308588181*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d83ac48f-472b-47c5-912a-d5e452b7df5e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308589604*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f43dc1dc-6a09-4901-a6a1-84e19ece1e98"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308591084*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"db52242b-621c-4959-9588-e6b53b62c785"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308592853*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3109e2ff-7df0-46fd-a970-fb5dae48abfe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030859487*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"510b51e3-c7ca-49c1-9030-8b00decb3ac9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "57", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Mittenpunkt inv\"\>"}],
  SequenceForm["i=", 57, " ", "Mittenpunkt inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403085963507`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bd6eb850-f902-4987-97f6-bee6872f04c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308597752*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9cdb0f9e-c376-408b-937d-e8a649ff078d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030863235*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5021cb04-c9e2-4445-8349-5ce8ff5611f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308634327*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2abc1f53-a278-42c0-95e7-bb0d9eae14c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030863581*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b06460d8-2172-4fc7-81dd-7629bd6f1fdc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403086371717`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9f0d34f4-7a84-4a29-923b-ad3d05a6e8b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308638567*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"796d0af0-0f17-4981-ae17-f5be0a4a934b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308639999*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7d1b3137-dcd3-4b20-b340-724b02a1488c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308641399*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e3df6ef4-1697-46e6-b3f0-94c2dfa487bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308643341*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ac3edf8c-08d8-4806-b48c-d29335d30625"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308645073*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d47a30a1-966c-4d4c-8469-3cb245316085"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "58", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Spieker inv\"\>"}],
  SequenceForm["i=", 58, " ", "Spieker inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308646637*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f9e3b486-bd2c-4370-a46f-ccb4fd0f8bc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308648024*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e405fabd-7b93-4366-900a-f7b2b4f7e334"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308681397*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1ce4da8f-199c-411b-88e8-f73a3e741f9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308683674*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4da956a4-0c68-48bd-b1ef-f58f8f1f3ee7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308685072*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"527fee89-4eb2-43b9-af80-67d9376d43ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308686417*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"89e7258a-031c-477e-8fcc-98349e34c0e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030868778*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"824cbdd3-14ad-4368-b768-1eef4bf8050d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403086894083`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9717e9ec-90e6-4c1b-afff-87cc4d8668ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403086912117`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5541a668-63df-4834-8c0a-97f9d0200f9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308693308*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"057ba2ff-082f-46f2-a376-4715633be0e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308695425*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a165ee3a-8b4a-43e8-9744-5f34bde51a96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "59", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Feuerbach inv\"\>"}],
  SequenceForm["i=", 59, " ", "Feuerbach inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308697542*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0e8df2ef-a572-4b92-b1ed-a70d6597a4d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308705031*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"190ced92-65a6-4127-87cb-b10d15a608c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308796956*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9cac9028-43d6-4e26-aa6f-323ca953a377"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403087986717`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"be1f3ecb-9395-4b1f-a8b5-0c34114620a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403087999983`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5f435084-7e4f-4a51-aa45-5a97cddc4130"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403088013077`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"156d51b9-463a-4cb5-9d97-ea5e3ea30ccd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308802678*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3f9113b8-06f1-4d85-a7b0-e56199092dd0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308804224*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5f249a88-7af8-4d90-97fe-dfc604b6ccaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308805636*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"580e5436-04c1-4ddc-b68d-047304be235c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308807045*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9ef747a6-859e-497b-bd07-9849b8f6884b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308808436*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7cb516ce-eb76-4aec-b1d7-a19cbce8bba5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "60", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X12 inv\"\>"}],
  
  SequenceForm["i=", 60, " ", "X12 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308809808*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"49a6f1f7-af08-46ae-b916-d244ffcaa483"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403088171864`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a714de16-8911-4052-99f1-fd28aa0ab372"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403088928957`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"65d52426-a7df-463a-9a77-427a9d31d1b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308894608*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7fee4d42-7863-4b63-a892-f2134b45fd10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308895976*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c836407f-ed87-4d4a-b21a-010ec553a36a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308897331*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c1d8fd25-0d00-4399-83ac-81905da89833"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640308899107*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"72bab27f-975a-48e5-ac33-435922ed3cec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030890058*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4df5fd86-e59e-4ef0-ab92-18ed1e1513a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403089022017`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bc8bbc54-09f1-4011-a2fc-cee0fa2d4012"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403089041758`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5d3194df-f016-47b4-b8d2-af522dc9ef7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403089056377`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"eb0b194a-0a27-4ff5-9360-9529999ef2b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "61", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"1st Napoleon point inv\"\>"}],
  SequenceForm["i=", 61, " ", "1st Napoleon point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403089077063`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"13eb7ceb-df5f-4f64-8ced-bb08441e1d9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403089523907`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c125b112-7b83-4c3b-abb3-e838c3bc5c7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403090401*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d4b9c88a-4eba-4d72-808c-090903fb3d4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403090699263`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5e10dc7d-b326-427c-8d9b-1e6f0ecee00e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309071619*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5c76f0b6-b412-4764-a40c-845cedbe7555"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403090729723`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2ce63301-4c6d-498a-bfab-c7eb7e67cc18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030907471*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3f7929c3-f81d-4b18-a7a4-abacc00def27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309076524*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6c29f6e4-d625-42cb-b3c8-025f6e030fdc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403090780478`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"11e3e7f3-6cb4-4789-9241-b2ecb616f387"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309079492*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0d006e2a-87c3-4ed2-80ad-8406e49daf83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309080917*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a5ed25bb-5a1b-4d8e-a74d-98d65745be8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "62", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Napoleon point inv\"\>"}],
  SequenceForm["i=", 62, " ", "2nd Napoleon point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309082649*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"56e236da-7c08-4ef0-9ded-4b50104e264d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403091180573`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7542da36-d19c-4ce6-a424-89fa201a6713"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309197678*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5c668777-80c7-4ca3-8f79-d05e7fee084b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403092269573`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"85132f6f-ab6d-464f-857f-9f1d4135ef82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309228704*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ac54c17c-7536-4e70-93e1-067d1136aba3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309230081*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2f844ace-6582-48f3-b7cb-605523fc4cb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309231471*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b290bb35-bdd7-4e23-bef5-fcccba8d4262"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309232835*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5b4bf419-633e-4d5d-8e2f-a635a0e82563"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309234503*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"15b9c147-34e7-4e6d-b39e-14263e64c3dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309235999*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"66ffb593-8bce-4721-9abc-ac4dbf855d1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403092374268`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e95095f0-b37a-48e2-a237-c5dead3a382d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "63", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Crucial point inv\"\>"}],
  SequenceForm["i=", 63, " ", "Crucial point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403092388153`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7e3f0bd5-8d79-4de0-b5b9-6231f82eaca1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309247727*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0c469893-6e8d-4204-a454-b694fd3b3961"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309278173*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cc793d4a-d062-42d3-904b-95b623c35798"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403092801027`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bcd65d94-c950-48df-87c7-d12ff868ae87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403092814817`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7aaed8bd-0c67-4de3-b37e-bcddc697083f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403092831707`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b9a2bee5-b6fa-463f-a0d4-43e6d16d3ddc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309284758*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ee9bba0b-7995-4fde-aee4-c86269cf6256"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309286256*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"33407204-02de-45a1-893f-bfc52eeed2fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309287623*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"39cf9d55-1a1e-4be5-980a-cde33b4e0d6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309288946*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"82ae7fdc-a687-4afa-bc76-28c716c8ac73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309290559*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f57ed000-f366-45d8-b88e-cc5a558c34da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"De Longchamps point inv\"\>"}],
  SequenceForm["i=", 64, " ", "De Longchamps point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309292016*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0c1f1dd5-e7bc-4407-a7d6-1d623c662394"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403092936993`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1a8efbc0-9e83-4971-9ba9-eecf1c998163"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030936347*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b78495a4-9b68-460e-be7e-d00fbb3c8c4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309370905*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"724a9159-c88d-43eb-bf78-6a1f32a89f1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309372593*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"00bd9e50-69fc-4032-af90-d2bd0e85718d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309373951*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c4efd2a6-204f-4e7e-8e82-083579f86857"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309375355*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dab2d69d-f244-4dfb-8985-2b4264523bf3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309377665*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"154e809f-beb5-4c4a-92e9-7fe5d049a30b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309379672*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1a1e2bba-7e42-4f6c-902b-c3146046fa56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309381237*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c1a06529-34b3-428d-8858-e2211b3b02ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309382635*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d06f6c7e-b720-4aa1-9832-316b932b76c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Schiffler point inv\"\>"}],
  SequenceForm["i=", 65, " ", "Schiffler point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309384231*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"496fbf61-a1db-431b-8a50-0d25631c439b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309385586*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6c7350a1-4f00-4177-b009-64de98bcf932"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030943642*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7c3fe5fd-7150-428c-9370-d3ffe4ed58b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309438394*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b886553e-e887-4be5-bcdc-d3f03dcd2f41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309439763*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e716ca43-95fd-49a2-95db-81fce4347b4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309441123*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ae85cd91-e1d6-410c-ad19-89ed447ba8d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403094430637`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"90d5d4fe-b1fc-4382-bb0d-a677bc072aa2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309444688*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"38f1b9e9-5345-4714-948c-35fd5679e108"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309446149*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a5ce8fd3-b862-41bc-8486-3e1d55698e06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309447603*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5f983733-6110-4de0-a965-bbe7cf1c69e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309449264*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"14bb2d51-1847-4073-8689-bb33c4ed3a7a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "66", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Exeter point inv\"\>"}],
  SequenceForm["i=", 66, " ", "Exeter point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030945098*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5ee48e10-7718-4701-8e32-d0160057bc73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309452392*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3020038d-e388-4e55-89ec-260e08e55c0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403094821863`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"25d511ff-a160-41d0-89dd-a702326c62f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309489794*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"42375368-37f3-4e49-b2e6-b9805fae0ddd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309491911*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1ca92ba1-a9a5-40b6-bc54-2a8c44794d0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030949382*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9d279bf5-6494-4b5e-bf22-9a2aa9bf82d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403094954157`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a720335d-1136-4001-8542-2b0efba0bb50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403094971313`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3a66e3c2-688c-48ad-b492-ec435a9ed0b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309499597*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"eb065c8e-c9c5-409b-915e-6c10db5b8917"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309501273*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"34a3766a-d930-4bba-b24c-e983c5f618b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309502799*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"42de0c01-6a3b-49ca-b0e6-932b271ad506"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"far out point inv\"\>"}],
  SequenceForm["i=", 67, " ", "far out point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309504342*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4fbea527-cd69-4b46-89c3-688f3365cf60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309505961*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bce92840-5fdd-4fe7-bc43-8f9bd018a6dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403095624323`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cda119c1-50bf-4f53-8606-555733e7e9b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309564275*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4ce561a9-1093-426b-b3c1-52ce4c6643e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309565639*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0052c4c2-f7f8-4660-86bb-3c9dad54bb9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309567173*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8c07ec33-5546-4633-9858-f933f6cdd898"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403095685863`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"20de47db-a98e-4683-9ba1-b846bf799339"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403095700808`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7b767578-6217-4b2d-9515-34358e852218"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309571787*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"80e82847-1511-4b56-b06e-7945f5d6b7c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403095732183`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c22782b2-86e7-4a29-9c09-f28a28cfd5cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403095745897`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8a5a853c-d26d-4ac2-8768-6c2aeb6fa083"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "68", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X24 inv\"\>"}],
  
  SequenceForm["i=", 68, " ", "X24 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309576264*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5ad305ac-fb9d-483c-9525-e08a1bcd2719"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403095777903`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3f6966cd-4c79-44ab-b1b5-07cee8cd3105"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309652651*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1822f8ad-6123-44a7-8260-7e888da8a2dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309683647*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4a6d4bb3-dd77-492d-b799-ceb6385e431e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030968568*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0fe9c1a4-6474-4460-9353-1d0e61ac05d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309687091*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"49ec317c-d226-46d2-8d83-1e397a9ad358"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309688651*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"912bd336-0fda-4778-a866-9c42692db59b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403096904087`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7a125ed5-98a9-4322-8dfb-c11185a19873"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309692339*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9cf0b999-83ec-45f6-9689-48e1c8bcd283"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309693989*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"16742a6b-59ce-464c-bc09-03af97985c2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403096955853`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d644a3f7-dba2-4c86-ab91-68f3f1e1a801"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "69", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X25 inv\"\>"}],
  
  SequenceForm["i=", 69, " ", "X25 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309696988*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ed82db16-0712-4e5c-ad86-bf5c93defc87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309698917*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f63aa5bf-4a92-4f5b-bed1-f4fccd795a0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403097003508`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8d86bd13-ca87-4641-9efa-951d989a6818"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309701688*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b6d60a1e-83b3-45a9-bee5-5b3546bde709"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309703148*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"798f0b7c-cc23-4657-b9e7-b3580b1fbdf1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309704464*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"44f2e905-d8ae-4ea5-8b0d-92fc8adab585"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403097058887`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a61f13d6-4fc9-4381-9ecb-4f4a11e83e74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403097075167`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9a81115f-377b-44f3-a30f-be48435d5c2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309709049*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fdecc38c-d644-4329-8d9c-a077acfcc139"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403097105017`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"86bb1d82-fd53-441b-badb-91a7aa4d1042"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309711904*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"81fd692c-008a-4c12-af20-36d9d9bf7dfa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "70", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Circumcenter of tangential triangle inv\"\>"}],
  SequenceForm["i=", 70, " ", "Circumcenter of tangential triangle inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309713243*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"48af94c7-67d1-41ce-8b58-dd8a8ae2ead6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309714946*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"57bd2fe0-c7d5-49a7-9fd9-6bf6f64a689e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309815702*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9051bbf7-086b-43c0-891a-2c32c12d3a0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403098441057`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6969b230-00ca-4fc2-823d-63774bb4f115"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309845881*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cdab25d9-6af3-4426-854a-3756ffd2b3b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309847376*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b7820de1-71ec-461b-b9f8-73a9f3f9ab21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309848803*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bc2e2802-91b6-4a4c-80d0-0628b4eabd2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309850565*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"458c6ca0-eea7-4c1e-b782-1cc3b0b90f07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403098521357`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"82bfad9a-08db-46b2-b87a-6f401031996a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309853602*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7a941fa0-0653-4d7f-8ace-c894a5253d67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309855008*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9528988b-104e-48ec-976f-6d2070abfb40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "71", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X27 inv\"\>"}],
  
  SequenceForm["i=", 71, " ", "X27 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309856531*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"469f8015-c8bf-41db-a3cd-157e5d6b9159"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309858157*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"feafced0-53a7-42d6-8f81-64c2d821fe21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403098886757`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ffa15388-d9a9-4685-8e5e-6bf775fd846b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030989086*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cf6b1759-da3c-4cc6-8184-717d85a6b300"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309892811*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"99346a4d-0aef-43ad-9097-63cea0424e42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309894597*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aed56b60-8ea1-4007-91fd-b846f37d7177"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309896348*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c0ca5f3b-2c34-45fa-bdfe-e442e6a3fba5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309897892*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8cee17d5-9dcf-462a-8acd-f4488b0b7130"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403098996363`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c4c215d2-1202-4489-a951-4d912ff3c799"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309901112*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"41236779-29c2-4f7f-8150-16c8e8938127"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309902545*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bb0e6f00-a26b-4db8-ad8e-73886e3b04bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "72", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X28 inv\"\>"}],
  
  SequenceForm["i=", 72, " ", "X28 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309903905*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d5025a15-a4f4-49e3-8e6a-bc22c36640d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309905315*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ade16b60-e18c-4724-83b8-4a812436cee5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309936102*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0163b20c-31c2-48e7-b338-13cc35b8203d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309938232*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2581746a-a307-4856-83bb-cff5486b2fe4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403099399357`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"731a6473-d9bf-471a-a7a0-499893585bf4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309941395*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"043da7fc-45b3-4fea-836e-7a72ecafd8ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403099433413`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"647c8f93-4920-411a-bde2-e4963cdbcfa3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309945127*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9f6feff8-d3af-4b82-80b0-6d8add9e7a15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309947071*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4f8391c5-3b40-4491-ac12-d1030f760b44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309948584*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0c152b8b-5e45-43cd-89f1-786931a9c87d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403099499702`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"27086a65-d814-4ecb-a582-92b1e9dadf34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "73", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X29 inv\"\>"}],
  
  SequenceForm["i=", 73, " ", "X29 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564030995129*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2f132f97-a6f4-49ce-bc97-1f71d0e5d2a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640309952767*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6007df29-e526-4ee7-82c1-d3933012a507"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310060143*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e9dbd29e-7c93-41e2-b01e-a63f31a863ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403100625753`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d4a99421-6dd9-480c-ad66-fd4cf2097d22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310064193*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3cdf3dc8-ff53-4d61-8be7-c5aa987c3c8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403100660143`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5be4c50e-b515-4105-8593-cba367be0fa3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403100680304`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e3ce028e-a07f-4910-91b7-d3a627221d85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031006962*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c71791ab-cdab-4d3e-afa5-cd185204ee6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310071144*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"76e37a75-7dfe-49ce-954d-14b2c6ff16d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310072669*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8e8e5b83-0d1b-40ce-8031-3dd7e6e59899"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310074295*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f6e27386-cbf8-4d10-a60c-b4ee80886463"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "74", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X30 inv\"\>"}],
  
  SequenceForm["i=", 74, " ", "X30 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310076333*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f4173989-1e32-4e97-8d00-830eac65c0bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403101067953`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"245dc1ed-3fdb-42a2-b76a-88c44c26b1ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031016435*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3cabb41b-c660-4bef-9a91-0556bb5eea78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403101720753`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8b753f08-0f42-4947-83a1-d29bae0b537b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310173882*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aa1e47bc-5490-43fe-8f3e-c14c01b3a916"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031017631*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c4bcab39-8e95-4b02-9994-02c6f4348ae0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031017813*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"310b0e14-1222-469c-afb5-082e0f15820f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310180256*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e9a3b7b8-19ca-4ae7-a53c-6e1f137c4d77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310181912*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1c31e3cd-7079-4bb4-aadd-5f1b57deb0f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403101834373`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"919b0cff-684f-4784-991f-c0eafa7282a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310184848*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ab905b63-9865-4145-82f9-ba6e3e4feeab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "75", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd power point inv\"\>"}],
  SequenceForm["i=", 75, " ", "2nd power point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031018647*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"95e3a3ff-08de-4b6c-a111-b6610ead61cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310187944*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6b564b3f-a934-4234-97fb-7621884b188e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403101952763`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"46439eaa-6e34-43a1-a70d-868d847f1640"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310197247*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e57026a2-8929-41ee-8f6c-3ded49356d9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310198659*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5a8f1d21-b5c1-4759-a913-38eca7aa364d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310200116*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6e35dffa-8c73-47ea-b167-96f9832b1bdd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310201614*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"44c9636a-6a79-4d78-9e71-e1fc9d72518c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403102036667`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"12407a9c-cbdd-46d6-9bed-4c8f38d49fb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310205185*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"42ebd32e-bbb6-46f5-9b4d-a986143f90a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403102066517`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"abe39f07-b367-46ae-bd04-b58095e646c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310208085*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"56e0b3b8-e7f4-412d-9319-3dcaace96e33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "76", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"3rd power point inv\"\>"}],
  SequenceForm["i=", 76, " ", "3rd power point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310209436*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d75784d1-6a4d-4dd5-b834-f6de05b2d715"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403102111683`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"30dcd6a4-4695-4f54-b59f-28b26ad618ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310241466*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"215dbd0c-ef29-46df-8535-3f7c13d77cfe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310243607*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1c2e9a4a-5ea6-4c57-901f-367a66642980"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310245014*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0da9b74d-257e-4d14-bddd-6010f629699f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310246372*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a17acfa9-1f0f-44c6-97ab-082c3de225fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403102479277`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"777a1d87-dd73-42ed-a5e4-38da5efd6165"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310249446*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"19361e27-d36e-442e-9e2a-cb226b4331fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310251265*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5c4acc4a-8900-4039-8528-860476030d49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310252746*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3ce4bc54-9af3-4984-9aed-7b1cd32421fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403102541723`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"62ea6e66-2c02-49ce-a0c2-7c56253fd37c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "77", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X33 inv\"\>"}],
  
  SequenceForm["i=", 77, " ", "X33 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403102555304`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e5afc769-1583-4afa-9dbb-00568cd9c002"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310256892*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2feb2213-bd21-457e-a484-2fa66999bd21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310311922*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d2ee647f-a242-4ae1-a26b-cf8a65ff15ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310313768*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5a696970-73d6-472d-8211-ae180568b2a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310315609*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fdd6b5e9-e304-43d9-b9f1-5c254decd113"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310317079*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e9f99483-1599-4f47-bf27-69460798f638"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310318653*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"55c0b5e6-8c07-4983-b9d4-40b25ee8f26e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310320237*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"00845af4-aa5d-4d07-8678-0b515b309d28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310321879*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b5f6add8-2b96-47b4-97f1-803695f9180b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310323928*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"26dc75d6-5efe-438f-971c-87a7990371e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310325469*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"703aff96-2804-43e8-a66e-19646dc1e447"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "78", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X34 inv\"\>"}],
  
  SequenceForm["i=", 78, " ", "X34 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403103273706`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b2192f81-0ea4-43d0-ac40-a81d5a452401"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403103288927`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f37a8b48-025e-44a3-80dd-162b5253623c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310364113*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"941d0a1a-1261-4876-b51e-84aa0beb3bc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310365971*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cff7b693-517d-4e6a-a6ae-27a044913274"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310367773*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6fe1bdb2-a607-4ab6-9ba6-c6896eedafb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310369461*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2038857e-9572-41bf-bd3c-af92d19c49de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310371039*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cc7fd701-9eac-4600-bf04-b18f85932b41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310372854*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a6b4586b-dd70-466c-ab65-a4f90f9995d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031037457*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7d9775d9-5fac-4a9a-ba5a-e7d61f0f2cdb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310376487*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f2b888a1-254e-4257-9c45-f76db95a244e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310378767*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1e851cdf-07e2-48a1-954a-439dca021800"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "79", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X35 inv\"\>"}],
  
  SequenceForm["i=", 79, " ", "X35 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310380426*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7a102755-f438-4e12-9750-a4c04b050936"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403103818483`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ab7dc79b-74c0-4e08-bc58-4a5eb2cf0aa6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403104192677`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"68a6e567-cebc-4175-8b3b-618003a6e895"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310421113*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6cab4117-a097-456f-9754-a2d5f9c9d286"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310422578*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"505e5ab1-dbe8-4648-ae68-12bd71849387"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310424032*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"078dc381-4454-4154-b6c4-1b2342e3ac5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310425992*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"94542b77-4520-4863-8db3-bc366071f392"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310428031*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8ac7efa4-8a4b-4d94-94c9-d82ba5410680"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310429846*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7e60d4ca-e51a-4471-86d5-0956e3807c0a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310431634*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"00471eb9-9848-4715-acb5-60e676149c47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310433326*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"74adbf8a-88da-4be4-a344-83f8da5e7375"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "80", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X36 inv\"\>"}],
  
  SequenceForm["i=", 80, " ", "X36 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403104350853`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"22d94de2-7b70-4572-9241-f48c23738761"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310436529*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b31dd1b8-e454-40a6-b4ef-2c9f5b7f3836"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031047598*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e928b32d-caa7-468c-b400-8be336259ec8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310477991*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"48ecd8f4-3b6b-405e-9dcd-4d4af8a5280d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310479632*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0df1bc27-1aec-409d-a965-71df9ce2326b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310481098*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"00cc97f1-134b-4536-bdab-eb6f797550d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310482688*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"268c63f7-a0e7-410f-9b24-f6bab43551a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310484293*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a9cb1348-a168-4a56-a951-ad1e93bb43bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310485924*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"88bb90d8-e3ca-4b4d-ae9d-91a343a032d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310487607*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f8c111cb-3186-4bd3-ab35-45715610be11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031048907*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d15179db-cb9f-419e-b047-764ac88ae5ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "81", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X37 inv\"\>"}],
  
  SequenceForm["i=", 81, " ", "X37 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310490449*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"766e4b83-9936-48d9-ad4c-0870fc0c2b17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310491889*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c059f770-18e2-4633-99ad-e3f030f58e47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310522545*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ab9778d7-41e0-4b48-b396-84e5f13e98c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310524392*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7f1dc74c-acb2-410d-b3d7-74df7eb68c3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310526147*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3b1747f2-91c0-409c-9237-94ea8d4b3887"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310527886*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bef3aaf9-8bc2-4586-914b-bcf8c9976ef9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403105295353`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"428b121d-cbc2-49a5-b206-24ff5f201b1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310531178*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bd7c40ac-b7d6-4c50-ba95-5e5824e64c8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310533162*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d976be09-4323-480c-a4b0-1875aca5fe5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310534707*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0b09f208-29cf-4bee-bf93-699e2c7ee1d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403105361423`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e9d29831-da6c-4f4f-95e7-2826b867ec4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "82", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X38 inv\"\>"}],
  
  SequenceForm["i=", 82, " ", "X38 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310537551*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"19fa6e32-e17f-4a77-ae12-961d87fd9524"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310538968*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a36b9841-eb9b-4660-90f0-594186b2266e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310571291*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"33ba10e3-b152-4e81-a059-47f3752c4d10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403105731783`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"764a900f-5d23-4a8c-9c15-47219adf524e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310574675*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9fdda33f-e43d-473b-9709-8fb4b0f67573"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310576476*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a3b41c5d-9123-4bea-8183-0460a739a5fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031057833*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"916452db-60aa-4f0d-b4c4-95c9655815a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403105801373`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"69c20218-7ac5-4298-b47d-77846669469c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310581793*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cc49bf7f-5ca5-40b8-a6ba-c3c34e9758e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310583486*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cbb34b4a-89ea-47e7-af3f-1ddf75533ec4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310584972*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f08e6b15-e3fa-488c-a0cc-06d4b8e0f221"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "83", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Brocard midpoint inv\"\>"}],
  SequenceForm["i=", 83, " ", "Brocard midpoint inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310586398*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1c13a405-eb41-4631-ad44-4ca297ae465f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310587953*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ad4c2a66-79a9-4c3b-84d8-6e9b61272d06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310618606*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fc39530e-e830-48b5-9aaa-f54a0bbd35a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310620645*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"28bedbeb-fb40-454e-9db0-f20cec6681cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310622106*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"38ad129f-3d00-41d9-991b-acf9a86e59ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403106235733`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4a12f0ba-2721-408d-92fa-001d93d4b128"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310625146*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a5c4f569-c47f-47c6-8e2a-65de2a4a4930"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310627055*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b68414ca-52d5-45f6-962e-c276f7b4a92e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310629084*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"35916964-303a-49d8-a4ec-1b94a2a764e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310630718*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8c44e2bd-3910-42dd-94d4-59480729d8a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310632189*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"26b15f97-9c0a-4cd4-bf8b-cb77194e517e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "84", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X40 inv\"\>"}],
  
  SequenceForm["i=", 84, " ", "X40 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403106336517`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"16991a8d-31d6-4552-839f-fdb7a627ffa5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310635088*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"759cc1ce-01fb-4703-b73c-9e096dfab5c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310742639*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"260a997c-3a20-4346-8877-23127bbccc11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403107446413`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e9eb6e51-61a6-4e35-94ca-d5921c0f64e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310746109*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c235ac88-8f62-4619-8205-240632363f2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310747617*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ce67b005-884e-4062-8346-ea8cc6652817"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310749136*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a41f116b-43f7-42c4-bc66-33501ef78591"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031075066*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f312716d-279f-47c3-9d67-5f94bf6f17c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031075219*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b69c1ccb-870e-4b12-97b3-c00c25ebdec3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403107538013`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b5638691-a4ef-4932-95c2-3261c7214572"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403107553596`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e89bb508-df73-4a65-a54a-abc953001f3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "85", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X41 inv\"\>"}],
  
  SequenceForm["i=", 85, " ", "X41 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403107568274`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5b2b557c-29c8-4472-be9d-d993c32d0e68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310764243*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d1429880-ab29-4ab6-9efc-524429462338"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310802655*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ed05e7d6-bb51-4ec4-a2f8-d858f3020427"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310804598*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"511de702-98b3-473d-a52f-3e6557d9717e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310806089*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"39913ddd-6a36-4ee2-af5a-c29965ea5251"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031080757*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4c7d1629-7229-4fcf-9672-22165ada2bfa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310809366*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"99a66c9f-77d3-4315-a1a2-1f250a6dfea1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310811427*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"799715d4-8e22-41c6-a871-375db267fde8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310813375*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"39208020-cc08-45e6-92c6-29edcd91d394"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403108149977`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cfbaeb24-b10d-4c37-ae55-9c1db8dda6ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310816608*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"77a2c49e-4a06-48f8-a12d-fe6f86c86af0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "86", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X42 inv\"\>"}],
  
  SequenceForm["i=", 86, " ", "X42 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310818109*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3fdaf1e6-8ff3-45a1-a96d-1e868e1d3083"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310819559*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"637968ff-15a0-4076-9f03-7ae756a43f45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310849917*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"281fcad1-78c9-4a34-82f4-19699d3c6c59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310852043*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"38048d1f-f64b-4021-8c7a-13e4472c3c85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310853486*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f078be1a-9ec7-420a-bbe7-26c910f1b58a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403108549013`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d336b906-3172-4c6e-90ef-9eff07fa48f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031085633*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b47319bc-676d-45f8-b42c-ab4362cc1966"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310857767*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"97fe14cf-276b-4b84-b14e-3db9b9f8e2f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031085929*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a40ec768-fca6-478a-b946-2d0c2a511af0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403108612823`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"50f6da40-dab9-47ea-b32f-876689142276"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310862999*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b4078653-b5cb-46f6-8e1f-812e796f3005"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "87", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X43 inv\"\>"}],
  
  SequenceForm["i=", 87, " ", "X43 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310864606*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f8fe0902-a8f0-42b6-91e4-d37ee4c1c5b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310866098*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1654e0f5-f8a6-4d2a-a41a-0638b260f42d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310901209*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0775debf-8eca-41cf-90ae-c4d855d75e6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310903194*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e8435812-b740-4b90-8aad-a7a7856d3217"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403109047117`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"79793263-7f93-465a-8ac3-847aad671dc3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310906206*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ea774c4c-f227-4a6a-ab69-12f728085ea7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031090777*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"22e10c6b-e1d2-4c95-8a83-2aee7995930c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310909362*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"49a42963-a3bb-4f70-9752-d39ded501f06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031091159*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"028ac416-ce40-45f0-983d-d0c3a4317904"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310913336*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4b63b765-bc7d-4570-b949-dbcb0d74aefc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403109151*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d86d92f7-c759-49ef-bad0-b15afa6a516d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "88", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X44 inv\"\>"}],
  
  SequenceForm["i=", 88, " ", "X44 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310916719*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"85cba44b-b037-458d-bae4-8ef0f7fb6907"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403109182377`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5b2d39d6-cd14-44ac-8e5a-b8dd300c46e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310954337*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8bd48d93-b398-4d98-a2c8-7876381459fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310956262*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2bf40628-83f4-4eed-b379-a8d14e6262c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310957753*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6fc98df7-1e5f-4193-a358-1ef514f72c4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310959256*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"39b6fb7c-efbf-4326-add0-f23fa9a332ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310961458*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7e4a9413-ba07-4a2a-b753-298c4f3b4d23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031096392*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"47472507-2b03-4490-ab68-7f82ab732fbe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310965769*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1eae20b6-008d-4fb8-a490-4098656ad43f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310967382*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"de5e8293-26a8-4589-8ce8-58fa8e10593f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310969099*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"60da430f-5415-40c4-b05f-766942691446"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "89", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X45 inv\"\>"}],
  
  SequenceForm["i=", 89, " ", "X45 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640310970572*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"974a1061-0c7a-4775-b66f-4cb0f89e03ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031097198*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c7b11516-c123-46fe-8275-d086a0cfd676"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311012684*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"112e1f03-6601-4e01-9596-f91a2e60dea1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031101477*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"449c623f-0e74-425e-9d57-9c834fdf3e00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311016369*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5877f09b-497c-4aeb-9130-b4ad954e4892"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403110179033`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"13d36ae1-d525-42cb-8b18-92f0820bbe2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403110194807`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fe3bcbc9-2df1-4c4f-aa97-7c571f14e2b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031102125*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d48d42e4-0eaa-48c4-a5dd-e5cb63518442"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311023172*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"85bf95ba-90a8-4454-9ec9-87f9c9cb6830"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311024931*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b7b2be23-07d0-43b1-b251-6052d4e3410d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311026752*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"06ecd63e-f5c8-42a6-8095-44191760ce9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "90", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X46 inv\"\>"}],
  
  SequenceForm["i=", 90, " ", "X46 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311028234*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"35041033-a0ba-4bd4-9110-6ce9bde78ca1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311057898*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"91ad3239-3dfb-450c-bebc-d827f0820e63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311144114*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"98ce1f50-9386-45b4-aaf4-480250fe5adc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311146091*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bdd9d6b8-b4a4-4598-982d-bb8f3e3b4bf1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311147613*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5101c081-fee7-4ed1-ac98-31169acdb012"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403111491213`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"86622360-e948-4a02-8ad7-ae34a3809030"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311150732*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aafc60fd-c4fd-4675-ad1c-173ed8f4f197"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403111522913`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"93d75944-bf53-43db-a05e-82d0edb45760"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403111540613`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"44818169-fd92-4638-bc13-b131346bc32f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031115595*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9acfc522-b47f-4471-b5fc-c31db313befa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311157938*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f681b43e-ce1c-4aad-8e78-38b0c420d49a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "91", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X47 inv\"\>"}],
  
  SequenceForm["i=", 91, " ", "X47 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311159531*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"781bcb77-1572-4a84-9e79-52bb3fe38ae5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311166984*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c95a0421-2b7b-4ad2-a107-e0c3bc93444e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311251237*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c68d4fab-f2dd-451f-883b-f68b1c3cffeb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403112588243`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cc4ddef2-4c6b-437a-857e-7d64fce42251"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403112607203`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ad9611d9-7f9d-4d9e-a600-fd65f066c7e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403112622433`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"87159d15-4ab4-426e-93ec-9f4ddd51a081"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311263844*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aa430cf9-3192-435c-9c3f-b2053f185e09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311265429*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d5778655-0eac-4a1d-8915-ffc2a97ba78c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311267016*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"05610a40-6591-4f70-be3c-d688748d7cd1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403112685757`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e1ef173a-ef03-4314-a4cc-3f68e16da7f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311270149*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d6fc85af-197c-45c2-8c90-0c6a9c0ab471"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "92", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X48 inv\"\>"}],
  
  SequenceForm["i=", 92, " ", "X48 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031127181*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"68baad1c-619a-4da2-a99f-f1496d0b255d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311273295*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"252bcc2f-ef92-4a1e-96fd-afbbb50b311a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311315195*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ab0b432d-2d19-4195-b83c-552553567f6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311317225*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"328fb18a-789c-4379-8d1e-a6f32a92c5dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311318746*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"27f73465-4905-471a-9a1e-0b78e553893b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311320414*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8a90652b-6525-4050-856d-a65b6938e4c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311322047*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"81971bac-41de-44bf-a306-cd0882289ad4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311323697*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d6d0e9e5-439d-421e-8a7d-559f598c059b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403113253727`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"23e1a66f-1880-48a4-b827-81a2a061603e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311327092*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c80fa4fe-5a32-463e-9187-d8994e3bed3c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311328723*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7ccf35f3-45f8-4708-8e42-22eb32af7459"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "93", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X49 inv\"\>"}],
  
  SequenceForm["i=", 93, " ", "X49 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311330365*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a3bf47b6-78c1-4be8-8587-644f9c20c3f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311359315*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"46cdd806-d6b0-4637-a9f5-287c56656f3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311464322*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d4d00da7-e845-4097-8b54-6bb853006369"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311471796*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ff675fdc-e56c-47ec-ae03-69be72e05ccc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403114736958`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9b3b42a0-007e-4d74-a843-a4f851c070c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311475256*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8155af98-d0f0-4497-9674-95a9721414fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031147683*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dcb14ac4-b325-4977-a150-e7882c073c71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311478428*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aeaadb81-b109-44c2-a035-b5a69cc9ec52"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403114801407`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e00fa4aa-6870-435e-8500-e35e107c335d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311482297*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"210952b6-62ac-4ef0-9039-59455e2a324a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311484085*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"63c4b4d2-c204-4172-8b6d-6fe87753a795"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "94", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X50 inv\"\>"}],
  
  SequenceForm["i=", 94, " ", "X50 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311485869*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ee3d5e4e-2040-4c96-937b-ac28e14a6a85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311516136*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"499bba34-375d-4e12-85ad-b10d91ae7a85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403115910378`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c481075d-3e2e-40fd-9584-ddd78a12172b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403115984898`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1bcbb7f2-54f5-4ac5-be2e-a1085f958198"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311600484*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b0a0adfd-f854-41fa-a07f-3b7d8510fee0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311601988*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"69015c9a-ec57-438f-97d1-83558d693761"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311603566*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f2430e70-6c46-4862-afbf-89e635b1b5ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311605123*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4a8c316e-2cc1-4ed6-b9bd-3a2e2215bf4f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311607058*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"82720f83-cf0c-4947-9545-2d1889890dc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311608934*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aa2d12c1-1404-4712-8418-f38d8ce68f59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311610546*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"620785a4-52fa-4dc8-904c-af79da36c601"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "95", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Centroid of orthic triangle inv\"\>"}],
  SequenceForm["i=", 95, " ", "Centroid of orthic triangle inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311612131*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"86176a1c-fc9b-4b3a-9064-d957eaf502f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311641592*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d3c2e3b0-e0a6-4165-93e7-09994814af0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311672069*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"633830b1-a9f1-4d93-b8c8-ba65b1e9ae11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311680284*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"923b7a8b-46e7-4e4a-a338-4ca858222fe8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031168224*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e40ad8e8-c23a-47f8-b7e3-7c50308fc19e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311683793*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"da23d74e-dc9c-4a10-b1c4-764cb12cfc98"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311685423*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c5da540a-5a0f-4b3b-ad00-6b53bb826d89"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311688361*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"be2d3d00-c040-44c3-a5e0-63140a4cb0fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311690384*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c3a879fc-021f-4a2f-af37-c7cd8898f3d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311692274*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0c223b41-efa6-422c-9cbc-d691e6dfad47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311694083*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"08890745-fd1b-4931-9ee4-e213897a42e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "96", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Orthocenter of orthic triangle inv\"\>"}],
  SequenceForm["i=", 96, " ", "Orthocenter of orthic triangle inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311695664*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2f440f2e-1982-4d81-98ab-4bd0ce269784"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403117251177`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8e9d37e3-06bc-4d48-b65c-756ba78f582e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311841193*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c6501a05-ce61-49c0-8059-3393dc654d93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311848753*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7826bab9-2ff5-4b1a-b3da-f1a0ec76795e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311850697*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a1d80e08-77ad-4381-a669-36defe235e95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311852253*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e72bc371-6fcc-4662-8f1f-6b4c439ca478"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311853984*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a8826971-c8bb-4d5a-abe6-6c30166fc0bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403118555517`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8dc34edc-2374-46c8-a2da-b85021fd6e90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311857113*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ff45bf08-6176-4e0e-ab0a-52cbbbbbe374"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311858725*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fa18e637-7c19-404a-af42-fbb85a8a7768"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403118603477`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ce52f194-f67c-4b52-99a0-909322176e4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "97", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Symmedian point of orthic triangle inv\"\>"}],
  SequenceForm["i=", 97, " ", "Symmedian point of orthic triangle inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311862028*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6fdcfd01-11cd-4764-b857-81f7bcc83377"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311892153*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c21d5e7f-7eef-4431-b22e-f32dce93db7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311968199*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ce8dab0e-9014-4878-a862-93825ff82187"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311975922*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5771b2cd-f43f-414a-be0b-da114d4c4bb8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311977841*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d3f9eb64-8a57-4e07-93f3-081ee46c7df6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311979363*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2d665c21-0f09-4b11-8d68-4a1dadd9e5df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311980957*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"84139d67-8b7e-4458-afc2-fea0cdc2778d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311982624*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"21bbe291-9b20-4028-bf0a-5bdec02e0d91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031198437*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"74b40bf4-46e5-441b-aa2f-fe1c28cb7847"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311986085*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f2fdbecd-57c1-4224-9ff8-3b3fb31fe3d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311987729*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bc4ebfa4-4909-47ed-804e-ba08e026a5f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "98", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Tarry point\"\>"}],
  SequenceForm["i=", 98, " ", "Tarry point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403119894743`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"718002cd-0a81-4dee-aecf-3531df5d3597"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640311991274*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bb03b764-ebb3-4f71-8996-5c50a271bef1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312034374*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9c0f8f95-0403-48cf-a9e5-3a842a95c389"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312042132*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e5eb65db-2be5-4873-b4af-1afefa2915a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312044207*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7b8b4b82-f3db-49db-9109-a4c48787721e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312046073*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d48ffba4-0bdd-4e08-8edc-1871f5e489e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312048057*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2431b5d9-170a-477c-a1c8-ae1d08dbe885"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403120496902`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c8436e48-d167-40ea-b066-dd82f654fa48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312051527*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4d215391-cb11-485d-b53b-b969c2bf0ef7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312053121*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b1bf3c5a-a2a6-4fbc-86a9-4bb5a2323945"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403120546703`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"460f3031-0e9e-432b-bf96-012833b0a7bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "99", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Steiner point\"\>"}],
  SequenceForm["i=", 99, " ", "Steiner point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403120561323`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d144fe47-a0f9-4ef5-a785-1e4412549ee1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312057622*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"51d29457-5ed3-45ef-81fb-9c867080485b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312096849*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9bc1ce6e-ded5-4c71-a172-1f98d44a451e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312099238*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4e64fcdd-0a9f-457e-96a8-15dda8015312"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312100963*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"05eced32-dd6c-4205-950c-43695a9945a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403121025867`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"63010cac-87bf-4504-9834-ea5730a8176e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403121044292`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"55fe33a1-c515-4311-a289-dac14e361067"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031210614*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"428ec412-e621-4a86-bdab-119e76caeb87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312108018*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"679dc1f1-70f4-46f7-a3c7-1ebd6e0e64e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312109777*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8123fdc5-1da1-49fd-84c8-40f73978c428"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312111347*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3fab3c21-3c42-47b5-aa17-0e5a430f558e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "100", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X100\"\>"}],
  SequenceForm["i=", 100, " ", "X100"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312112844*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cc8c6de0-59ca-4584-8bae-073cad1e9282"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312114349*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3ad72497-4287-47de-a466-f34937ed3c24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403121453733`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6b70562b-6bb4-4bd4-9538-7f4c59ef9cbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403121476707`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8693a2a2-14d7-4c83-a40e-184a7967b482"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312149321*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f6bf1959-85a3-4a62-b25a-1bec91047fc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312151122*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7c00e5d3-1f74-4d12-b932-def911e3b2c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312152726*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9ad1add3-85ac-4ac9-9468-309144c5ce9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312154273*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a6470d6e-6ddd-480b-973e-2fc2fcca142a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312155879*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6919c49b-9a89-4ff1-b5c3-05239b7d5b29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312157558*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"34951311-9cf0-40f8-84fc-9eb9890a1463"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312159259*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d312149e-07ce-4046-ba95-f7a8f81d90e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "101", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X101\"\>"}],
  SequenceForm["i=", 101, " ", "X101"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031216117*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c1d00faf-5eb6-4550-b691-68347e73ec9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312162895*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6d018dd0-431f-4e76-ac8d-874cc11552d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312193864*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5a5c738e-2785-4561-bf83-5f8a0ad43a30"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312196189*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a1d8f965-79c5-4f74-a13c-a619514376e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312197834*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"065cf3dc-5c3a-4b07-8e14-5be338708f28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312199563*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"119ca0fe-7afd-40b3-bb7e-f1cf8de0972a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403122012243`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"470d0365-5551-4e5a-a4e3-804b80f4c7e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312202903*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f371bee2-a3db-4258-ad79-7cbd8e3fe01e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312204525*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8633ee75-eceb-4e2e-be5f-de44aa103073"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312206121*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"43700818-f0a7-41d2-aef8-18607eb41c48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312207703*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1e76b130-5d5b-42ee-aa41-2d5b1d59f85b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "102", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X102\"\>"}],
  SequenceForm["i=", 102, " ", "X102"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312209303*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"83d55935-993d-475e-9fb7-ae1b7606feb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403122113647`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"749e611d-3e5e-4d85-b72d-c54a0cf3257e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403122415524`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"18e7120c-1fc1-4bd4-811f-e83941479830"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403122443867`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"03f4e0b1-89b5-4ed1-8e6c-2b5e38c7c614"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312246654*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"580a15cc-ff34-4278-a454-33dbd1d097b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403122485247`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"375b56a5-c171-4394-91dc-325721765876"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312250367*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5f4f18ae-506b-422a-9133-43528eb54ae6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312252249*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"23ebf6b0-4265-45a7-b0d9-bbed8e5a80f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403122538567`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"65562cbc-1f29-4db4-b101-288f82fbec73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312255446*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"31206230-5166-44a6-9a61-85eded64bfe8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312257196*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"71f278c8-79ba-47d9-83ea-f8cb6f54326b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "103", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X103\"\>"}],
  SequenceForm["i=", 103, " ", "X103"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312258861*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"49c1a502-f5c0-45ef-af40-1a39aa09dc5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312288742*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"21dfd499-4f6c-46e6-aeb2-7e3b517e8fcb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312332987*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e2910b61-a669-48ab-b6c4-bd552e236fc7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312335026*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d1ca0dad-c12a-4e99-a53e-6fdb0720e0f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "104", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X104\"\>"}],
  SequenceForm["i=", 104, " ", "X104"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312336833*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"93accc89-58c9-4845-adb2-b2788d808872"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403123666677`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ce1d06e6-4806-437a-ba36-dcd299a41a00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312415552*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"985e0bb5-5b52-45bc-8633-9914e80d26fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403124177427`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"96c5e61c-b13f-4376-8b1d-a68d78a13caa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "105", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X105\"\>"}],
  SequenceForm["i=", 105, " ", "X105"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312419578*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0428ab11-dcc6-40c5-bd86-9c1541285a15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403124500427`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a5e33a94-4318-43ac-8f95-d6332e59c123"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312483385*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4cd12470-0589-4e5d-a874-c45d037c0e71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403124854107`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1e015110-406b-4271-a29d-e1f8b92937dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312486944*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7013e45a-95b8-4d1e-9f43-58cff89309de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312488496*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d32bd064-7405-4435-8b6b-4af67cec1d84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312490168*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"36b8ef4d-8e54-4dd7-aa5d-39913fd8cff5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312491807*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b67d20e1-7b80-4f8e-8539-943376248080"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031249347*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f17d778a-44d9-47d4-addf-27b5f5df78e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403124955473`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dcf95c2d-57bd-4fcb-90fc-b0b6cb35e03e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312497365*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f5d1c0a7-0e44-4541-9880-2ed8c557f0d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "106", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X106\"\>"}],
  SequenceForm["i=", 106, " ", "X106"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312499036*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f792e555-ed0e-40e0-a504-c8450ccc3559"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312500703*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d13e9ff2-60cd-4890-9263-b90170009678"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312502521*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"abd03448-949d-432d-a56f-3ca94f04ad91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312505292*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9959bbb6-abda-4ab6-9c1a-b946cd0ccf77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312507395*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"73f33646-84ce-48e5-ab7f-d35f2e926976"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403125093727`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b8dc7dd1-1f87-4227-adbd-95551232b66c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312511314*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d1411664-d2d2-4c90-b2b7-cf53f502d488"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312513056*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6ce792f7-607d-481a-a35e-646033027752"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403125150833`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3e55c5e5-9623-462c-971a-aa162cabc114"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403125169563`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"57e73ffb-3b81-4d3f-b92d-503051f5a4b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403125185843`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0ff7a324-5c01-4629-9067-6a7f9504862f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "107", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X107\"\>"}],
  SequenceForm["i=", 107, " ", "X107"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403125201473`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"72ac7eb3-5e6e-46f0-9810-bda41bc928e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312521715*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a7cd7785-5397-4d04-8c1a-25d278962aef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312552017*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b9d06ce9-12a4-408b-ad6a-45f9206309c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403125540953`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"155efae8-537b-4e32-bee0-3d279b0a8493"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312555846*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"910fd06a-4ee7-4ae7-8b9a-0971828eb219"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312557396*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"53c2fdc8-7474-4fb0-b79d-c9238150be1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403125589657`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dfc45157-d20b-42a3-9d24-17cfded0e5b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312560739*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2dff74cb-572d-4405-9551-7de3632ee3d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312562729*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"45915433-e165-4ff4-8ff2-e709482e562a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312564563*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7926dbc3-6860-42e7-9333-fa5ec5764ccb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403125663223`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9aa5ea74-aaaa-4eb4-b8b3-74935afc7665"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "108", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X108\"\>"}],
  SequenceForm["i=", 108, " ", "X108"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312567973*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"eb31b200-e5bc-4b10-918d-7e80a3a2ea70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312569577*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"589b4faa-6d92-49e4-b172-ff52af469d5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312599457*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"918dc6e4-b010-4085-ab14-e2ce79234231"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312601486*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7505a596-0379-4adb-a5a7-cce2bd617600"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312603026*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"796cb553-edbd-42c0-a8fa-5a3130ab344b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312604607*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3576db1b-cd51-45df-99e9-6c2b5a1a186e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403126062517`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d8fa753d-f1b6-4430-97dc-324fab5319ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403126078653`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6af08a70-b681-45c4-a369-0e6d9ff92bac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031260956*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3cc396fa-4acb-4551-92ea-4853ea93ddc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312611691*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"89eb18fc-7a0d-436e-ac5c-7d2af0f0192c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312613625*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3a50c2f6-6ece-4b6d-88d9-4d697702676c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "109", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X109\"\>"}],
  SequenceForm["i=", 109, " ", "X109"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312615384*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c943630b-ba77-4757-a557-aed0ad7edc07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312617052*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d2b6a188-be43-4b61-8d35-8ca2887b0fc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312618699*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"023c0aba-e629-496c-b6e1-045ae9506caa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403126203413`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"80522b84-95c3-4344-90fe-7772646ff746"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031262226*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b3ff59af-381f-4992-b095-7af3059c4d48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312623928*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c2837711-f5cc-41f4-93cb-1137315910d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403126259947`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"66bc4f27-4c04-484f-8494-84fb477087a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031262777*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e086eb32-4725-4076-a421-e541a1c79ca3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312629507*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"faca5caf-01bc-4f2d-8ad7-e7307a55a36a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403126314383`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"321b4441-405a-4a06-b0eb-0580d148dd60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312633093*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e9569878-17b7-42f6-94c5-23110a361c0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "110", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X110\"\>"}],
  SequenceForm["i=", 110, " ", "X110"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312634635*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4394d3ec-1461-40b7-8fff-7e47fd2ef7ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312636174*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1da2e110-b43f-43e2-8ade-d57bc2217c0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312667143*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"493fecae-47ad-4409-a756-51f84dd6774a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312674823*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2bb64cf4-288b-40d4-bb56-04bc68879b20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312677246*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6e3e75d9-1981-465f-af48-1fe89cd3ab48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312679167*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3034a1ad-1b17-4c8b-8965-2d7705efe0ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312681403*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2e397743-d4b2-454b-9803-7834398b8cb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312683157*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e0d5144c-8316-4752-a0f2-6815bcfdbd59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312684965*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"124db792-8316-40be-88be-e19c7a8eb6ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403126866217`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"61673fdd-bdc0-4109-8871-1195df785ca8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403126883297`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3f5bb9dc-a579-4361-992e-e6252719778c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "111", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X111\"\>"}],
  SequenceForm["i=", 111, " ", "X111"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403126899633`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2048f28f-7c50-4ab5-b209-214c7133a126"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312691846*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aaa39ec4-a76f-40e1-9787-40398fc00a40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312693964*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7f496a89-82bb-481c-b382-7361bfb9ca94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312695959*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3c9a92e0-fd91-43fa-bfeb-122bdae1f0b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312697598*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"40e1193f-2b3b-401c-857d-39dc7cc0f927"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312699574*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"febbdc95-1405-415f-98a8-2c2a3642d61c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312701284*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"59603731-29a4-4358-bc57-ffa7b695e970"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312702919*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8f4e3a97-0b78-4f85-acf4-0a0d9335aee0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312704565*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c5d3ce29-b2a6-4ac0-985d-7b1902cf9d31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312706229*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fa85e670-f186-438c-9cf4-948e37868d43"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312707884*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9064ae31-cc58-46ae-92ae-0d84663197cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "112", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X112\"\>"}],
  SequenceForm["i=", 112, " ", "X112"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312709544*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d9ed5940-49ee-44b4-8d65-e219aa69b1e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312711178*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e7612753-30ab-4760-9169-2f9f9cb914fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312741354*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"65a6245c-c754-4cd8-9903-6d620956c936"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403127436867`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fa31bfee-e6ee-41fe-b447-8365aa55c5fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312745583*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5a2ed7aa-6f57-4245-bb46-20722bb81e76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312747389*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5754648f-f7c2-428e-9a3b-f604b519914c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403127490997`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1ecf4c1a-e71d-4661-ab57-37e0187ffe2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312751137*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ca071234-1cb5-469f-99b9-e04197b6a73c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312752843*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c20ccb3a-670c-4ce4-990b-449c57aea3c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403127544537`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"491fe8d2-00af-433e-a806-6518396176d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403127560577`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7ca54427-9377-46a4-b809-106112e49dfa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "113", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X113\"\>"}],
  SequenceForm["i=", 113, " ", "X113"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312757622*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cc648baa-a5b8-4a78-8e78-36c40101c6a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312759386*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d1fbc793-a8ca-4b29-922a-952b3e780df8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312761096*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c3013dfb-32c4-4087-8945-07ff3ad09a7a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312762733*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bcdc08b2-bede-415e-b186-8b3c9ed99850"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403127643538`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f23ba476-2f3a-4e81-9346-6ac64401bdef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312766082*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e5f98148-e5a9-4f8c-91fb-641ddd750256"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312767828*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e12cddc9-c193-4d97-a517-51645ec505f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312769559*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"47288549-0a10-42ca-8b98-77f803a1168f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312771474*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ae1cc3a7-a86a-4aae-91aa-4c23e58b0384"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312773163*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7cc60a22-9df8-42fd-a8de-e22109da077f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312774819*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"26bd35b0-6dfc-47d2-b87b-f932f1e3ee5e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "114", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X114\"\>"}],
  SequenceForm["i=", 114, " ", "X114"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403127764072`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"60a55f3c-9260-4993-aa49-87d587a9f961"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312777993*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f24084e3-49ae-426a-8b5e-25d58bf5d42b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312815854*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2c31801d-4d7c-4655-966a-b7d33bf3c85c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312818087*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c4d132d1-7822-4a37-9a1d-25d8791d6dfb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312819757*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bab13e1c-f3b5-4229-b451-2f9faa85fe6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312821409*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"993512c6-83dc-446c-9402-4bf98a426cf2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312823303*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"54ab88a1-b9a7-4405-8b8c-44ad0882f31a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403128250513`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"44585be2-0502-4363-b609-4c46473ec175"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403128269863`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"34c73d22-a267-4a06-a48a-293e75a9553e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312828741*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c21d6c3d-2430-401b-820b-3a0400615f8a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312830387*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"86d772a1-636e-482b-833e-3bace08e9d72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "115", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X115\"\>"}],
  SequenceForm["i=", 115, " ", "X115"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312832066*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"736e1b39-6030-4722-a9b6-86de5bc19af3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312833696*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"59bbc67c-3b51-4df0-b2c9-8ac7a0dd9f44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031286462*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1c82892a-262e-4566-8046-ec201b4a53db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403128668003`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e03f9dca-af86-4efa-a06e-7d550fa4ba1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031286852*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ddc41765-b4bf-4a76-a4d9-3ff987abb2ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031287043*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dc6f056a-5c32-441c-910c-143151e06d19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403128722677`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"58e768ee-8c44-4816-b497-5061c68df17f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312873934*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e8f3b29e-d4c8-4679-8baa-dec6ae665403"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312875608*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"77cc82b7-b801-416c-b3ec-1e3fea1cf1c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031287782*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fdb27c1e-a4e6-4bfb-ab26-b0c8d63f3223"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312879731*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"91fd69bd-87fc-4a35-a88c-fc65aefc65c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "116", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X116\"\>"}],
  SequenceForm["i=", 116, " ", "X116"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403128815002`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ca065135-a6dd-4dd6-baf7-6773743195e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312883286*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e4722b6c-3b1e-4250-8f88-d91dbf1382c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031291741*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"38c7b55d-2698-4328-8aeb-45b37f6fc570"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312919566*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6bcf4b5c-5b0a-4e0e-8c82-e99bbd5f4fe9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312921303*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5d2f3680-2e71-486f-a722-98d070ce1896"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403129230013`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"771aae08-341a-4232-bcf0-215174ec9500"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312924796*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"89ae89d7-5222-444e-ae9f-5f076cf38b58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312926738*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f1bf5e34-27b5-4e19-b4d3-e57742650c3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312929324*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b1770cd5-2c4b-4b09-80dd-021b8256947c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403129314013`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"60fbd4d3-4b0d-4f4b-9f78-b77bb1f721c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312933167*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"97c8a54a-8380-4a4c-8c5d-7a57a5a28fa8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "117", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X117\"\>"}],
  SequenceForm["i=", 117, " ", "X117"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312934906*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0719923f-603a-4a6d-817f-b6527baef1a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312936564*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6ba99ab2-6e61-42ac-827e-c0c49364e7bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312967125*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9dd0a185-9b32-4e5f-84df-6bc206bf60a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403129692507`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"75001f2b-e10a-4206-84bd-0bb200027fd1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403129709*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"65394dd7-ca8b-4605-b7fe-7720ac01e0da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312972558*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d20a662d-e77f-49c7-8fdc-413bd6062f95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403129744577`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a8e9888f-c324-47dc-8c30-5ab9b9f314f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312976219*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cb9e8839-4a5b-4603-82f0-e9ebdcbcf99f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403129783993`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9f9cc15c-c448-4d99-b101-1508b60db549"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312980365*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"72479690-3170-4ae7-aeda-cac881545412"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312982251*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b4ade13b-5c31-494d-93e0-5a74aa151e15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "118", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"r-power point\"\>"}],
  SequenceForm["i=", 118, " ", "r-power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403129841833`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4fe8c8fe-d37b-42d6-9dc9-9e06409f0e93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312985935*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ec9945bc-2a9d-46df-b44f-21d252ae6753"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031298779*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1566cf9a-44f5-47bf-9f93-5aac17820ab1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312989551*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"125c349d-ce1c-4e04-af01-d11ac6824102"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312991271*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c1ee45fd-ec49-4d3b-ab0f-c990c35f8424"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312993185*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"040ecd72-76a4-462e-b3c5-0a8ca9d82663"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312994997*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fe7139f5-a172-4c46-9b98-37db9db7e803"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312996673*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8b3c49cb-bcc3-4306-b573-998b27fdcff3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640312998354*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b04d1a40-7ec3-4397-803c-05e3a97a445b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313000073*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"54e4ae40-fd29-4d8a-93f5-53eeeff5012a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313001807*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6d847572-0c91-4ff1-8928-e64e8cbaae93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "119", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"r2-power point\"\>"}],
  SequenceForm["i=", 119, " ", "r2-power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313003634*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3fd01582-840f-4eae-9ce3-e9f4f59b0463"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403130061703`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e444219b-554f-4f25-9524-1860c4964a86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313014513*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bb92253d-df9e-41b0-bd83-8833bef06462"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313016667*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"35a78c81-dd5c-4f6c-a9f8-2808d52b6edc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313018412*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"452a4124-cc32-4f93-9fd7-baff3bd8ec9e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313020632*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9450d2f0-f581-486e-a37a-d48881c8f646"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403130225887`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1e958a41-1c40-4acc-8067-b9f96bcbfbf7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313024412*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a568faba-ac77-4c85-b053-76feafee33ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313026433*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d6dd1df6-a6db-4055-be6a-c807574d404f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313028248*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"08e6fa33-9d30-4304-9e05-121c9069d069"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313029928*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5ced5c45-7f11-4fcc-a64e-a8f15b2f984b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "120", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"r3-power point\"\>"}],
  SequenceForm["i=", 120, " ", "r3-power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403130315638`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2557c1db-3808-4ae5-b590-9200825c66cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313033207*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d565a389-6d60-41e9-8139-8f9d1be6c939"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313062788*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d8845c8a-af2d-4af4-b01f-43ef1e365de3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313065144*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b041e938-6926-4f1e-9bae-9eae5609c44b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403130667963`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"edaad52a-608f-4063-9f61-92dee1d942cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313068386*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d0a3a2e5-f9b3-410b-8b94-cf70bfab6ac4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313070058*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d8c581ee-b382-4d99-b158-bebe104ffa9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403130717497`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f5366072-7d51-431a-b301-635e8907cbbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031307343*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7cacb2f1-2c38-4cf7-9573-fbc19a331188"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313075115*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"be0f27c4-800b-457a-af31-18222bba4218"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031307686*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b210bb70-dc93-49c6-ab7e-247876f53c03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "121", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z1\"\>"}],
  SequenceForm["i=", 121, " ", "Z1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313078939*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e3d61bf8-3027-4014-b2aa-193d4519f9f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031308083*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6c6daf3f-de4d-4361-ab12-65101804d263"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403131107693`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1b30ec86-329d-4f40-8a82-48ff2647827a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313112935*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ff051ea8-827a-43ae-982c-0253b7493813"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313114893*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fa0f36e0-bd36-4b88-94f0-3971b5f5eceb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313116789*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7890d7bf-488e-4eee-93e7-8b98f07089d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313118699*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e9bd37c8-75d5-4af0-8aae-59a5f4289642"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313120585*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5a158d69-daaa-4c2e-9460-c0e8ec4d0292"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313122357*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3ec0dbf4-8649-48b3-870e-0c7661644ea6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403131243134`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0f2f3c3d-d714-4b5c-b0c7-58ee520fda3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403131260653`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ab3960f5-c08a-4714-80fd-2e37d7041401"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "122", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z2\"\>"}],
  SequenceForm["i=", 122, " ", "Z2"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403131281843`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"25b8d354-378c-40c2-aece-ac16cb747032"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313129994*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a403e412-6638-49b4-8bd8-d146e78440cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403131701107`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7172cee9-3e08-48a4-b7d0-94d07abd8ae0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031317242*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8a4ae953-96c1-49be-8249-3422646c8197"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403131742764`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4dbcd1d9-3770-4e35-b147-730b19fecae4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403131764183`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"72c948ec-2966-4487-9d1b-3e6d035e088c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313178838*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"56173482-a2a5-4ff1-b214-e5421b0656ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313180935*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"81963513-6472-47a7-82a4-0d7e3b6b81fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403131828527`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"51c45308-6cf9-478c-96fc-8dc844b9f96e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313184723*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6708a4d6-d1d3-43e5-8bf4-764eac95136b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313186757*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f31df282-4e2b-4fbd-81a9-ed95d4c46d74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "123", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z3\"\>"}],
  SequenceForm["i=", 123, " ", "Z3"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313188449*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"513c7edd-a11c-42fc-bb4f-c0495a282254"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313190164*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"220d9962-6b42-4e33-a1d6-6aca8ee6c1e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313238467*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1acf072b-c914-47e3-b8ac-9fcca7f7392a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313240787*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c4447b87-6b85-4ef3-b965-cd432a7c04fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313242846*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b64c9fa3-faf7-46df-af37-5692206472a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403132448273`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"67eda690-a0e8-4d4c-aca8-b2cee0cdfbac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313246702*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fccc59a0-aed7-40a1-bce7-f7a9eb0a3cff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313248781*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"77e1d41f-baca-4f93-bb62-f6df44626c70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313250944*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"325abeb0-bbbd-4efe-9cb5-a350d73b03c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313252782*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"281ffb8c-d1c1-48ae-bb1b-1fc3cf684946"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313254746*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"283d5036-3829-4f0e-a9cf-282089450b12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "124", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z4\"\>"}],
  SequenceForm["i=", 124, " ", "Z4"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403132566032`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"930d7acf-adcf-47dc-b0fa-894270f234b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313258305*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ba9a063b-1950-410e-90ff-a9d31453cf58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403133139067`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6519900b-7a4c-4429-ab0b-c63ecce7bb73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313316173*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"62353a82-899b-4cdc-ba1e-f711d9e24097"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313318067*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cc590536-532b-4930-bbdd-a1c2248833d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313320204*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c44dbaa3-a4e5-48d7-82cc-923c9e401ba2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031332205*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e3420604-58e8-4c5e-b80b-ec72b180c881"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031332393*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6cf9194e-a913-4a31-8ef7-e41f15c2e5eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313325817*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1009359b-514b-4613-8dc6-561850b04402"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403133276567`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ac535f8d-97ad-4508-842c-16b2becb8b0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313329496*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9d9f9ad7-6ba5-4ceb-b7e5-b361298cb322"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "125", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z5\"\>"}],
  SequenceForm["i=", 125, " ", "Z5"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403133313637`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"09edc52b-4915-42ab-869f-3e1bff1680f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403133331327`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0161c84f-b2dc-498a-a9ed-f7ee7bd6f317"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313379692*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f1b7a88d-4e6c-4f03-ba27-333fc26556c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313382045*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f324f809-2038-4724-adf2-fde0fac737d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403133838797`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6a7eab23-296e-454e-8f52-de07cd8eca3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313386037*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d182fc8f-fe62-4e3f-becd-4b66fbb68029"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313387924*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"015e7445-3c3f-461c-913a-b04466152234"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313389791*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"493aa411-ccbd-4fc3-9001-977cb5b2200c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403133915854`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"52b7ccba-93b4-4fa9-8954-9d5c3d79c617"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313393488*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"915d60ea-0e67-4414-b9ab-ab6e5a2cdbea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313395419*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e12bca27-6501-40c0-8ff0-c92909420352"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "126", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z6\"\>"}],
  SequenceForm["i=", 126, " ", "Z6"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031339713*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"96f2c59a-6d4c-407c-b535-ac3ef049d530"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313398776*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"90951315-fa53-41a4-94d7-5926503dde49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313444768*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ed72a2b2-7e20-4762-9a2e-8d6736522c78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313447206*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9c41f503-8f88-4d7d-b510-67582d86453d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403134491*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"35853a0d-cb0e-401d-b771-999c94164cc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313451193*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0b580d5f-e9ef-465f-9fe3-baaa13a7eb25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313453187*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5f1b23b3-9bfc-4f21-a73c-774038ffd628"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313455367*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bd4ab72a-d052-43f0-bbd7-0e649973964d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313457354*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2ac062c6-b25b-490e-9439-56953fe2e0e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313459229*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d58a8088-89fb-425f-be01-8902bf52411e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313461196*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9fd5dda5-de63-4419-b1dc-b3d10766e23e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "127", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z7\"\>"}],
  SequenceForm["i=", 127, " ", "Z7"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313463077*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"54f81747-9d61-48f2-9452-928a0583b3bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313464796*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"05db837b-a9a2-478e-a553-bdf550327b42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313528729*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"74e3d6b6-1a30-4033-bc5d-52ed92fa5767"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313531005*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"30a8c295-f5b2-4dd8-b3be-c34ce0df1757"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313532796*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6d7cbc79-60eb-4197-8f9e-528921a1d995"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403135349407`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"27fefd3e-0b10-400a-954f-46bd80df85d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313536811*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d7a63dbe-071a-476a-8fd8-1a1554a95933"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403135388317`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1c8329bc-1597-4e36-ada3-a44ba190c089"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313540756*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"62571fb4-6a49-427f-aa13-22b9adff274d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403135429363`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cd168c8d-34a7-47df-959d-ada3e86f4537"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313544945*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"68f999fa-8219-421c-97d4-d5bd2c59b448"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "128", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z8\"\>"}],
  SequenceForm["i=", 128, " ", "Z8"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313546822*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f4d45aa5-d5c7-47ac-ae37-0dc926b2becc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313548572*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"71c87f8e-5294-4f8d-88f3-e79aec532f15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313581011*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"03706821-33b1-4a2b-98c6-18c18d863f2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313583346*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"98b6685a-fde3-4640-b192-a0fcdf7a715d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403135851593`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1354b225-3310-49ca-a313-7a9d8f7da43b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313586953*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7684b20e-3ba5-453d-aa20-d38626e6041c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403135887833`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d6e790e1-07d1-4efd-980a-96ef088f3aec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313591*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8da6c432-9b12-445b-b7ce-29858e341957"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031359309*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"47c9266d-6317-4ef4-bb0e-0d6e2fcaa4cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313595276*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3672cb7c-09e1-4024-8dfe-ad05b7dcf92f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313597522*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bd668d7e-6ae5-43fb-ba83-9028f2ee2c15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "129", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"r4-power point\"\>"}],
  SequenceForm["i=", 129, " ", "r4-power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313599332*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"fc6980b1-872f-4d30-a621-765daf9c518e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313601431*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"79896ae4-834a-4782-9234-8360f4d13639"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313632937*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f634fa7b-dbaa-4ac8-9e5f-3a802db2d91f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313635109*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"02c89f2e-0956-4517-8a2a-5853ab4b36b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403136368093`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f8db0ce9-70f5-4feb-a4aa-576bf484ae9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313638535*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3c198efc-97df-40e1-be68-485b96b947e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403136403303`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2185d607-ce77-47d2-882b-6f2191adca0a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313642284*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"55340318-5c84-46cb-9ca6-93b94b187753"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403136446533`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5acd01fc-f20d-479f-84da-45660685cb40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313646677*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a6d0c616-b6a7-42bd-8650-e69989c3d8b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313648637*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bc3aca19-2f91-490b-92ad-17fcbc84fc59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "130", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"arbitrary center\"\>"}],
  SequenceForm["i=", 130, " ", "arbitrary center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313650386*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"905da045-6c66-4d25-a434-c25dd89e0749"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians have same length.\"\>"}],
  SequenceForm["  ", "Cevians have same length."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313652196*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"46c7709c-8cd1-489d-9fdf-023bbd4a685c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isosceles.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isosceles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403136539593`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a7724190-b44b-4688-8b78-5add3a531a4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403136557493`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"563cdc1c-2756-47f7-976c-3a7cbf69873e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313657468*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9557ec89-3c23-4414-a911-54f5194f3fa6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403136594276`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3f9f2030-ef6e-4450-9494-bff56058bca2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313661458*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b7fbfddb-3690-45ea-921a-7955a4fd6d72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Monge point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564031366354*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"60252bf7-f3b9-40ad-b192-cb256ea3ed8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "incenter", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313665411*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cc3e1326-4a9f-4b89-a580-10352d069a61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "Euler point", " coincides with reference ", "centroid", 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313667227*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7cd3ee50-2f1b-446d-8988-0028fb170af2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313669031*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1d0baef0-b18d-4d12-a614-f3cc005f96ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "131", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"areal center\"\>"}],
  SequenceForm["i=", 131, " ", "areal center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403136708508`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"49a30ae1-b772-49ec-949e-7de8717bd369"],

Cell[BoxData["\<\"  --> Some pairs of edges have same length.\"\>"], "Print",
 CellChangeTimes->{3.805640313678629*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bb0930d2-8923-4c29-b2fd-5012b0071a9d"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.805640313771327*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"af548061-54f7-425a-8a4f-0fd0346de6f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CASE \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"Circumscriptible Tetrahedron\"\>"}],
  SequenceForm["CASE ", 3, ": ", "Circumscriptible Tetrahedron"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313773616*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"50c2b5f6-c3bf-41b8-adec-26eddd5811a4"],

Cell[BoxData["\<\"------\"\>"], "Print",
 CellChangeTimes->{3.805640313775302*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"10220929-13d8-4a8e-8d5e-02914b3792a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>"}],
  SequenceForm["i=", 1, " ", "incenter"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313782714*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6e9b8ccc-6ed6-420f-84c1-d8dbef720a5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640313814205*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"40539411-b449-4804-985a-b90c8a20b5d9"],

Cell[BoxData["\<\"    4th coordinate of point of intersection is:\"\>"], \
"Print",
 CellChangeTimes->{3.8056403146295652`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c663b24e-f629-4431-939c-8dbfa5885060"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a1", "-", "a2", "-", "a3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a1", "+", "a2", "-", "a3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a1", "-", "a2", "+", "a3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "100"}], " ", 
       SuperscriptBox["a1", "2"]}], "+", 
      SuperscriptBox["a1", "3"], "+", 
      RowBox[{"200", " ", "a1", " ", "a2"}], "-", 
      RowBox[{
       SuperscriptBox["a1", "2"], " ", "a2"}], "-", 
      RowBox[{"100", " ", 
       SuperscriptBox["a2", "2"]}], "-", 
      RowBox[{"a1", " ", 
       SuperscriptBox["a2", "2"]}], "+", 
      SuperscriptBox["a2", "3"], "+", 
      RowBox[{"200", " ", "a1", " ", "a3"}], "-", 
      RowBox[{
       SuperscriptBox["a1", "2"], " ", "a3"}], "+", 
      RowBox[{"200", " ", "a2", " ", "a3"}], "-", 
      RowBox[{"2", " ", "a1", " ", "a2", " ", "a3"}], "-", 
      RowBox[{
       SuperscriptBox["a2", "2"], " ", "a3"}], "-", 
      RowBox[{"100", " ", 
       SuperscriptBox["a3", "2"]}], "-", 
      RowBox[{"a1", " ", 
       SuperscriptBox["a3", "2"]}], "-", 
      RowBox[{"a2", " ", 
       SuperscriptBox["a3", "2"]}], "+", 
      SuperscriptBox["a3", "3"]}], ")"}]}]}],
  SequenceForm[
  "    ", ($CellContext`a1 - $CellContext`a2 - $CellContext`a3) \
($CellContext`a1 + $CellContext`a2 - $CellContext`a3) ($CellContext`a1 - \
$CellContext`a2 + $CellContext`a3) ((-100) $CellContext`a1^2 + \
$CellContext`a1^3 + 
    200 $CellContext`a1 $CellContext`a2 - $CellContext`a1^2 $CellContext`a2 - 
    100 $CellContext`a2^2 - $CellContext`a1 $CellContext`a2^2 + \
$CellContext`a2^3 + 
    200 $CellContext`a1 $CellContext`a3 - $CellContext`a1^2 $CellContext`a3 + 
    200 $CellContext`a2 $CellContext`a3 - 
    2 $CellContext`a1 $CellContext`a2 $CellContext`a3 - $CellContext`a2^2 \
$CellContext`a3 - 
    100 $CellContext`a3^2 - $CellContext`a1 $CellContext`a3^2 - \
$CellContext`a2 $CellContext`a3^2 + $CellContext`a3^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640314632399*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"23255cf0-8720-4a09-8591-a6d787a9802a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Normals concur.\"\>"}],
  SequenceForm["  ", "Normals concur."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403146344223`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"824cc23d-3ee8-495a-b841-90aaa464da75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>"}],
  SequenceForm["i=", 2, " ", "centroid"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640314636269*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"abaa31c8-bee6-43a1-8101-42b109843c26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Faces are parallel.\"\>"}],
  SequenceForm["  ", "Faces are parallel."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640314643868*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f192fb97-25d1-4262-b41e-7ca217792f7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Coordinates of intersection point:  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["    Coordinates of intersection point:  ", {1, 1, 1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640314646089*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e73595cf-a615-4c67-a524-f22277cef1a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm["    Point coincides with ", "centroid", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640314647786*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2e3c2399-9332-4f7b-a3c1-aa41fef2dafc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", "\<\"Intersection point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on reference Euler line (at \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    ", "Intersection point", " lies on reference Euler line (at ", 1, ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640314678048*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"45bdce21-c03c-4e9a-ac36-f1f03beafe6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Cevians concur.\"\>"}],
  SequenceForm["  ", "Cevians concur."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403146804953`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c252256d-c36c-468f-9a86-48810c849def"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is circumscriptible.\"\>"}],
  SequenceForm["  ", "Tetrahedron is circumscriptible."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640314682439*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c637e46e-eaf8-4c6e-8692-f399eb86d7d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640314684248*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a3742c0d-8be8-4e03-af27-9d7616baf887"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403146859818`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bdc9977b-602e-45b7-8943-02de3fbd5c6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra are similar.\"\>"}],
  SequenceForm["  ", "Tetrahedra are similar."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640314687763*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e382c03f-2137-4b92-a992-196d3ffe1fbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640314689513*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"31ffb113-890b-4b27-ba07-5bcc76893b60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"circumcenter\"\>",
    "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"Euler point\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "circumcenter", " coincides with reference ", "Euler point",
    "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640314726534*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f8e1ed72-ceab-49d0-b9ae-61a4f2a51c09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", "\<\"Central Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on reference Euler line (at \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["2", "3"], "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    ", "Central Monge point", " lies on reference Euler line (at ", 
   Rational[2, 3], ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640314920917*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f371eb5a-8434-4c3b-8b5d-2ad1a8a74954"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", "\<\"Central Euler point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on reference Euler line (at \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["8", "9"], "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    ", "Central Euler point", " lies on reference Euler line (at ", 
   Rational[8, 9], ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640315274436*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dcdb85ec-0b3d-454a-a683-026782b65418"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Reference \"\>", 
   "\[InvisibleSpace]", "\<\"circumcenter\"\>", 
   "\[InvisibleSpace]", "\<\" lies on central Euler line (at \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    Reference ", "circumcenter", " lies on central Euler line (at ", 4, 
   ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640315411502*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a1e5e457-c34d-4691-a75b-6f2bff910f81"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Reference \"\>", 
   "\[InvisibleSpace]", "\<\"Monge point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on central Euler line (at \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "2"}], "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    Reference ", "Monge point", " lies on central Euler line (at ", -2, 
   ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403155204277`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1aee4ac6-7151-400f-a10c-84f601966fb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640315582295*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5488016e-dd95-4ef1-8f65-395cd1613d78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"circumcenter\"\>"}],
  SequenceForm["i=", 3, " ", "circumcenter"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640315584786*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"85fbea3e-fb7f-4200-89d6-77fd5e3f7633"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"circumcenter\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm[
  "    Point coincides with ", "circumcenter", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640322612177*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"73934049-73fc-4ec5-a913-85927aa1e2e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", "\<\"Intersection point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on reference Euler line (at \"\>", 
   "\[InvisibleSpace]", "0", "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    ", "Intersection point", " lies on reference Euler line (at ", 0, ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640322673614*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b3b84a81-4ec7-4349-b5ce-b4163e9d03ff"],

Cell[BoxData["\<\"    4th coordinate of point of intersection is:\"\>"], \
"Print",
 CellChangeTimes->{3.805640322676095*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7fac583e-c24b-4c53-8e2c-4b0ffbe638f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"10000", " ", 
     SuperscriptBox["a1", "4"]}], "-", 
    RowBox[{"200", " ", 
     SuperscriptBox["a1", "5"]}], "+", 
    SuperscriptBox["a1", "6"], "-", 
    RowBox[{"20000", " ", 
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a2", "2"]}], "+", 
    RowBox[{"200", " ", 
     SuperscriptBox["a1", "3"], " ", 
     SuperscriptBox["a2", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a1", "4"], " ", 
     SuperscriptBox["a2", "2"]}], "+", 
    RowBox[{"200", " ", 
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a2", "3"]}], "+", 
    RowBox[{"10000", " ", 
     SuperscriptBox["a2", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a2", "4"]}], "-", 
    RowBox[{"200", " ", 
     SuperscriptBox["a2", "5"]}], "+", 
    SuperscriptBox["a2", "6"], "-", 
    RowBox[{"20000", " ", 
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a3", "2"]}], "+", 
    RowBox[{"200", " ", 
     SuperscriptBox["a1", "3"], " ", 
     SuperscriptBox["a3", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a1", "4"], " ", 
     SuperscriptBox["a3", "2"]}], "-", 
    RowBox[{"20000", " ", 
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["a3", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["a3", "2"]}], "+", 
    RowBox[{"200", " ", 
     SuperscriptBox["a2", "3"], " ", 
     SuperscriptBox["a3", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a2", "4"], " ", 
     SuperscriptBox["a3", "2"]}], "+", 
    RowBox[{"200", " ", 
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a3", "3"]}], "+", 
    RowBox[{"200", " ", 
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["a3", "3"]}], "+", 
    RowBox[{"10000", " ", 
     SuperscriptBox["a3", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a3", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["a3", "4"]}], "-", 
    RowBox[{"200", " ", 
     SuperscriptBox["a3", "5"]}], "+", 
    SuperscriptBox["a3", "6"]}]}],
  SequenceForm[
  "    ", 10000 $CellContext`a1^4 - 200 $CellContext`a1^5 + $CellContext`a1^6 - 
   20000 $CellContext`a1^2 $CellContext`a2^2 + 
   200 $CellContext`a1^3 $CellContext`a2^2 - $CellContext`a1^4 \
$CellContext`a2^2 + 200 $CellContext`a1^2 $CellContext`a2^3 + 
   10000 $CellContext`a2^4 - $CellContext`a1^2 $CellContext`a2^4 - 
   200 $CellContext`a2^5 + $CellContext`a2^6 - 
   20000 $CellContext`a1^2 $CellContext`a3^2 + 
   200 $CellContext`a1^3 $CellContext`a3^2 - $CellContext`a1^4 \
$CellContext`a3^2 - 20000 $CellContext`a2^2 $CellContext`a3^2 + 
   2 $CellContext`a1^2 $CellContext`a2^2 $CellContext`a3^2 + 
   200 $CellContext`a2^3 $CellContext`a3^2 - $CellContext`a2^4 \
$CellContext`a3^2 + 200 $CellContext`a1^2 $CellContext`a3^3 + 
   200 $CellContext`a2^2 $CellContext`a3^3 + 
   10000 $CellContext`a3^4 - $CellContext`a1^2 $CellContext`a3^4 - \
$CellContext`a2^2 $CellContext`a3^4 - 
   200 $CellContext`a3^5 + $CellContext`a3^6],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640322678616*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c4535632-738d-42c0-8217-138f2b853ab6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Normals concur.\"\>"}],
  SequenceForm["  ", "Normals concur."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640322681635*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"77bfb34f-5db8-47b4-8b55-571c3a914f14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"orthocenter\"\>"}],
  SequenceForm["i=", 4, " ", "orthocenter"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640322683651*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"91778b61-710d-43be-bc32-6aa190060eaf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"nine point center\"\>"}],
  SequenceForm["i=", 5, " ", "nine point center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640322715534*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6775c7f1-4a13-4c46-9a8a-14edb0481b01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"symmedian point\"\>"}],
  SequenceForm["i=", 6, " ", "symmedian point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640322774279*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c2bfb837-115e-4ae1-8c99-90b00dc12e04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640322806712*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"199c1c9d-e7fd-4682-ac21-2cb377d10ea6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Gergonne point\"\>"}],
  SequenceForm["i=", 7, " ", "Gergonne point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403228089952`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"710822d7-b581-4e3b-8c10-7cb8d32da00b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Coordinates of intersection point:  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a1", "+", "a2", "-", "a3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a1", "-", "a2", "+", "a3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "200"}], "+", "a1", "+", "a2", "+", "a3"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"a1", "-", "a2", "-", "a3"}], ")"}]}], " ", 
      RowBox[{"(", 
       RowBox[{"a1", "+", "a2", "-", "a3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "200"}], "+", "a1", "+", "a2", "+", "a3"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"a1", "-", "a2", "-", "a3"}], ")"}]}], " ", 
      RowBox[{"(", 
       RowBox[{"a1", "-", "a2", "+", "a3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "200"}], "+", "a1", "+", "a2", "+", "a3"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a1", "-", "a2", "-", "a3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a1", "+", "a2", "-", "a3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a1", "-", "a2", "+", "a3"}], ")"}]}]}], "}"}]}],
  SequenceForm[
  "    Coordinates of intersection point:  ", {($CellContext`a1 + \
$CellContext`a2 - $CellContext`a3) ($CellContext`a1 - $CellContext`a2 + \
$CellContext`a3) (-200 + $CellContext`a1 + $CellContext`a2 + \
$CellContext`a3), -($CellContext`a1 - $CellContext`a2 - $CellContext`a3) \
($CellContext`a1 + $CellContext`a2 - $CellContext`a3) (-200 + $CellContext`a1 + \
$CellContext`a2 + $CellContext`a3), -($CellContext`a1 - $CellContext`a2 - \
$CellContext`a3) ($CellContext`a1 - $CellContext`a2 + $CellContext`a3) (-200 + \
$CellContext`a1 + $CellContext`a2 + $CellContext`a3), ($CellContext`a1 - \
$CellContext`a2 - $CellContext`a3) ($CellContext`a1 + $CellContext`a2 - \
$CellContext`a3) ($CellContext`a1 - $CellContext`a2 + $CellContext`a3)}],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564032284081*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2b4dbd3d-a5f0-4e62-88d7-8437dccbda91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Cevians concur.\"\>"}],
  SequenceForm["  ", "Cevians concur."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640322872799*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e913b4d8-51a6-4fa4-bea2-2c4772a9ad81"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640322874995*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"039b6ad9-1f2b-464c-bb85-908c0393cff9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Nagel point\"\>"}],
  SequenceForm["i=", 8, " ", "Nagel point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564032287716*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"db654629-69ac-4b52-8e87-c15a10e65534"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Coordinates of intersection point:  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "a1"}], "+", "a2", "+", "a3"}], ",", 
     RowBox[{"a1", "-", "a2", "+", "a3"}], ",", 
     RowBox[{"a1", "+", "a2", "-", "a3"}], ",", 
     RowBox[{"200", "-", "a1", "-", "a2", "-", "a3"}]}], "}"}]}],
  SequenceForm[
  "    Coordinates of intersection point:  ", {-$CellContext`a1 + \
$CellContext`a2 + $CellContext`a3, $CellContext`a1 - $CellContext`a2 + \
$CellContext`a3, $CellContext`a1 + $CellContext`a2 - $CellContext`a3, 
    200 - $CellContext`a1 - $CellContext`a2 - $CellContext`a3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640322885887*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a6b3129e-7c45-4671-8a32-047e34397081"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Cevians concur.\"\>"}],
  SequenceForm["  ", "Cevians concur."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403229164753`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f0e6815f-4650-47a4-9e87-49d34effb054"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403229188147`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"93399ba4-9072-45c7-b7d5-950eaad5aae8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Mittenpunkt\"\>"}],
  SequenceForm["i=", 9, " ", "Mittenpunkt"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640322920898*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"094949ce-57b5-4dc0-90a3-12e4047f6522"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403229544353`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b0c63927-83c1-4d00-af08-fd30352bca5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Spieker center\"\>"}],
  SequenceForm["i=", 10, " ", "Spieker center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403229567432`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"80b7180a-e456-4a33-88cf-412d45d14b08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Feuerbach point\"\>"}],
  SequenceForm["i=", 11, " ", "Feuerbach point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403229649267`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9b8cb6a8-9dc2-4b64-964a-1802d38c06b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Points are coplanar.\"\>"}],
  
  SequenceForm["  ", "Points are coplanar."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403229976673`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b0971e74-dc48-4436-b193-911810f94ec6"],

Cell[BoxData["\<\"  --> Some pairs of edges have same length.\"\>"], "Print",
 CellChangeTimes->{3.8056403230002832`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"58ad8f9c-f4bc-48f3-97b8-e9eb91ae26ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640323002372*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d9bcff50-eb1c-4691-a11e-069a4a3a7cc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X12\"\>"}],
  SequenceForm["i=", 12, " ", "X12"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640323004219*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"572e1714-c711-4eae-b1c6-abd12314f3da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"1st isogonic center (Fermat point)\"\>"}],
  SequenceForm["i=", 13, " ", "1st isogonic center (Fermat point)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640323037538*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a05fb4ad-a786-4385-99f1-2a59fff47e0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Isogonic center\"\>"}],
  SequenceForm["i=", 14, " ", "2nd Isogonic center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640323608972*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"093d86f1-178c-4602-aa8c-609be560e761"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"1st Isodynamic point\"\>"}],
  SequenceForm["i=", 15, " ", "1st Isodynamic point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640324122053*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"02a8a471-2bb3-46dc-a104-93d589e70221"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Isodynamic point\"\>"}],
  SequenceForm["i=", 16, " ", "2nd Isodynamic point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640324434066*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2ad4346d-3b96-4548-92e0-b048d701b3e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"1st Napoleon point\"\>"}],
  SequenceForm["i=", 17, " ", "1st Napoleon point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640324765308*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1b9ce7f4-c7f0-47c8-b469-340cf5f13be3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Napoleon point\"\>"}],
  SequenceForm["i=", 18, " ", "2nd Napoleon point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640325511573*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a64febd9-9a07-4216-8bd5-2b88f67d0735"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Crucial point\"\>"}],
  SequenceForm["i=", 19, " ", "Crucial point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640326134646*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cbc7a76d-97c9-4e73-a378-02ccf4784341"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"De Longchamps point\"\>"}],
  SequenceForm["i=", 20, " ", "De Longchamps point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403261897717`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2c3e25cf-921f-4ba2-aaa7-11d1fae02823"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Schiffler point\"\>"}],
  SequenceForm["i=", 21, " ", "Schiffler point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640326271611*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f7e341cc-feb2-40b2-9985-c0dec491bb62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Exeter point\"\>"}],
  SequenceForm["i=", 22, " ", "Exeter point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640326308201*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2d740f81-102f-44b6-8783-82362f0b4b8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"far out point\"\>"}],
  SequenceForm["i=", 23, " ", "far out point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640326359432*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5d928892-6876-4ef9-81e6-7d7d772267b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X24\"\>"}],
  SequenceForm["i=", 24, " ", "X24"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403264152517`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"abb73491-ba14-4d97-a81c-daa25465ca44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X25\"\>"}],
  SequenceForm["i=", 25, " ", "X25"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640326567498*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"799f0dfe-9bc6-4535-bb5f-138631403c55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Circumcenter of tangential triangle\"\>"}],
  SequenceForm["i=", 26, " ", "Circumcenter of tangential triangle"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403266192513`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"899c38a0-5874-4fae-a98d-b8152bfddfc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X27\"\>"}],
  SequenceForm["i=", 27, " ", "X27"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640326885188*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4b58861d-ea07-40db-811c-927ab53f114b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X28\"\>"}],
  SequenceForm["i=", 28, " ", "X28"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640326952141*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"672aab8a-ba5e-4615-a9e6-8d8cc283c510"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X29\"\>"}],
  SequenceForm["i=", 29, " ", "X29"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640327006415*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"894c7c69-eee7-4d61-b6c0-30323724979f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X30\"\>"}],
  SequenceForm["i=", 30, " ", "X30"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640327057564*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"93b27b07-6a7a-43d1-88d4-6e4faff017b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640327090208*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ac84bb2a-ea2d-40dd-ba10-34da8b351a08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403270926657`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1c59e883-23ce-4dff-9619-641ad24b3d33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640328330361*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ec014d3b-9b23-4742-ab21-a4c7ccf9b24c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd power point\"\>"}],
  SequenceForm["i=", 31, " ", "2nd power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640328332717*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"312e659e-e920-43e7-9f2c-3347f69976a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403283632603`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e03d8b12-771a-444e-808f-30dc0a6f9e1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"3rd power point\"\>"}],
  SequenceForm["i=", 32, " ", "3rd power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403283659277`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9d9c795c-61d6-40b0-8a8e-d34109b66f27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640328373906*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aac1f939-c780-431f-9ea0-ffc18d4763eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X33\"\>"}],
  SequenceForm["i=", 33, " ", "X33"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640328376808*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c4932297-851b-4d5d-b89b-dd859937a24a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X34\"\>"}],
  SequenceForm["i=", 34, " ", "X34"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640328429262*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d6f3a01d-0e0a-4dee-b83b-dec7b693dc20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X35\"\>"}],
  SequenceForm["i=", 35, " ", "X35"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403284860888`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b8c6ef4f-a557-4dae-8a3c-324cd1e40ba2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Property \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" failed in general,\"\>", 
   "\[InvisibleSpace]", "\<\" but numeric example succeeded.\"\>"}],
  SequenceForm[
  "  Property ", 17, " failed in general,", " but numeric example succeeded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403285981913`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e16e56e9-efb8-449c-bc48-b3d30bf3fd49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X36\"\>"}],
  SequenceForm["i=", 36, " ", "X36"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640328606655*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"964b82b1-9ec8-4e1b-949a-4f10f7bdc190"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Property \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" failed in general,\"\>", 
   "\[InvisibleSpace]", "\<\" but numeric example succeeded.\"\>"}],
  SequenceForm[
  "  Property ", 17, " failed in general,", " but numeric example succeeded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640328711255*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"81184445-3405-42f8-97a5-286bacbfa7e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X37\"\>"}],
  SequenceForm["i=", 37, " ", "X37"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640328720016*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2f10f616-cb33-4ae3-91e5-bc0f2baad1aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X38\"\>"}],
  SequenceForm["i=", 38, " ", "X38"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640328751285*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5d3e865b-fdd6-4c9f-9c02-07f6d4018cf3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "39", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Brocard midpoint\"\>"}],
  SequenceForm["i=", 39, " ", "Brocard midpoint"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403287885036`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"61f353e9-2d13-4b03-a83f-8ea3228de6a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X40\"\>"}],
  SequenceForm["i=", 40, " ", "X40"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640328821974*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"759c3be8-c141-4a68-9236-7368aec67418"],

Cell[BoxData["\<\"    4th coordinate of point of intersection is:\"\>"], \
"Print",
 CellChangeTimes->{3.805640337075593*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6b43a04c-4247-411d-8048-264624be20a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"20000", " ", 
     SuperscriptBox["a1", "4"]}], "-", 
    RowBox[{"300", " ", 
     SuperscriptBox["a1", "5"]}], "+", 
    SuperscriptBox["a1", "6"], "-", 
    RowBox[{"300", " ", 
     SuperscriptBox["a1", "4"], " ", "a2"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a1", "5"], " ", "a2"}], "-", 
    RowBox[{"40000", " ", 
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a2", "2"]}], "+", 
    RowBox[{"600", " ", 
     SuperscriptBox["a1", "3"], " ", 
     SuperscriptBox["a2", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a1", "4"], " ", 
     SuperscriptBox["a2", "2"]}], "+", 
    RowBox[{"600", " ", 
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a2", "3"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a1", "3"], " ", 
     SuperscriptBox["a2", "3"]}], "+", 
    RowBox[{"20000", " ", 
     SuperscriptBox["a2", "4"]}], "-", 
    RowBox[{"300", " ", "a1", " ", 
     SuperscriptBox["a2", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a2", "4"]}], "-", 
    RowBox[{"300", " ", 
     SuperscriptBox["a2", "5"]}], "+", 
    RowBox[{"2", " ", "a1", " ", 
     SuperscriptBox["a2", "5"]}], "+", 
    SuperscriptBox["a2", "6"], "-", 
    RowBox[{"300", " ", 
     SuperscriptBox["a1", "4"], " ", "a3"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a1", "5"], " ", "a3"}], "+", 
    RowBox[{"400", " ", 
     SuperscriptBox["a1", "3"], " ", "a2", " ", "a3"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a1", "4"], " ", "a2", " ", "a3"}], "-", 
    RowBox[{"200", " ", 
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a2", "2"], " ", "a3"}], "+", 
    RowBox[{"400", " ", "a1", " ", 
     SuperscriptBox["a2", "3"], " ", "a3"}], "-", 
    RowBox[{"300", " ", 
     SuperscriptBox["a2", "4"], " ", "a3"}], "-", 
    RowBox[{"2", " ", "a1", " ", 
     SuperscriptBox["a2", "4"], " ", "a3"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a2", "5"], " ", "a3"}], "-", 
    RowBox[{"40000", " ", 
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a3", "2"]}], "+", 
    RowBox[{"600", " ", 
     SuperscriptBox["a1", "3"], " ", 
     SuperscriptBox["a3", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a1", "4"], " ", 
     SuperscriptBox["a3", "2"]}], "-", 
    RowBox[{"200", " ", 
     SuperscriptBox["a1", "2"], " ", "a2", " ", 
     SuperscriptBox["a3", "2"]}], "-", 
    RowBox[{"40000", " ", 
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["a3", "2"]}], "-", 
    RowBox[{"200", " ", "a1", " ", 
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["a3", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["a3", "2"]}], "+", 
    RowBox[{"600", " ", 
     SuperscriptBox["a2", "3"], " ", 
     SuperscriptBox["a3", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a2", "4"], " ", 
     SuperscriptBox["a3", "2"]}], "+", 
    RowBox[{"600", " ", 
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a3", "3"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a1", "3"], " ", 
     SuperscriptBox["a3", "3"]}], "+", 
    RowBox[{"400", " ", "a1", " ", "a2", " ", 
     SuperscriptBox["a3", "3"]}], "+", 
    RowBox[{"600", " ", 
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["a3", "3"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a2", "3"], " ", 
     SuperscriptBox["a3", "3"]}], "+", 
    RowBox[{"20000", " ", 
     SuperscriptBox["a3", "4"]}], "-", 
    RowBox[{"300", " ", "a1", " ", 
     SuperscriptBox["a3", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["a1", "2"], " ", 
     SuperscriptBox["a3", "4"]}], "-", 
    RowBox[{"300", " ", "a2", " ", 
     SuperscriptBox["a3", "4"]}], "-", 
    RowBox[{"2", " ", "a1", " ", "a2", " ", 
     SuperscriptBox["a3", "4"]}], "-", 
    RowBox[{
     SuperscriptBox["a2", "2"], " ", 
     SuperscriptBox["a3", "4"]}], "-", 
    RowBox[{"300", " ", 
     SuperscriptBox["a3", "5"]}], "+", 
    RowBox[{"2", " ", "a1", " ", 
     SuperscriptBox["a3", "5"]}], "+", 
    RowBox[{"2", " ", "a2", " ", 
     SuperscriptBox["a3", "5"]}], "+", 
    SuperscriptBox["a3", "6"]}]}],
  SequenceForm[
  "    ", 20000 $CellContext`a1^4 - 300 $CellContext`a1^5 + $CellContext`a1^6 - 
   300 $CellContext`a1^4 $CellContext`a2 + 
   2 $CellContext`a1^5 $CellContext`a2 - 
   40000 $CellContext`a1^2 $CellContext`a2^2 + 
   600 $CellContext`a1^3 $CellContext`a2^2 - $CellContext`a1^4 \
$CellContext`a2^2 + 600 $CellContext`a1^2 $CellContext`a2^3 - 
   4 $CellContext`a1^3 $CellContext`a2^3 + 20000 $CellContext`a2^4 - 
   300 $CellContext`a1 $CellContext`a2^4 - $CellContext`a1^2 \
$CellContext`a2^4 - 300 $CellContext`a2^5 + 
   2 $CellContext`a1 $CellContext`a2^5 + $CellContext`a2^6 - 
   300 $CellContext`a1^4 $CellContext`a3 + 
   2 $CellContext`a1^5 $CellContext`a3 + 
   400 $CellContext`a1^3 $CellContext`a2 $CellContext`a3 - 
   2 $CellContext`a1^4 $CellContext`a2 $CellContext`a3 - 
   200 $CellContext`a1^2 $CellContext`a2^2 $CellContext`a3 + 
   400 $CellContext`a1 $CellContext`a2^3 $CellContext`a3 - 
   300 $CellContext`a2^4 $CellContext`a3 - 
   2 $CellContext`a1 $CellContext`a2^4 $CellContext`a3 + 
   2 $CellContext`a2^5 $CellContext`a3 - 
   40000 $CellContext`a1^2 $CellContext`a3^2 + 
   600 $CellContext`a1^3 $CellContext`a3^2 - $CellContext`a1^4 \
$CellContext`a3^2 - 200 $CellContext`a1^2 $CellContext`a2 $CellContext`a3^2 - 
   40000 $CellContext`a2^2 $CellContext`a3^2 - 
   200 $CellContext`a1 $CellContext`a2^2 $CellContext`a3^2 + 
   2 $CellContext`a1^2 $CellContext`a2^2 $CellContext`a3^2 + 
   600 $CellContext`a2^3 $CellContext`a3^2 - $CellContext`a2^4 \
$CellContext`a3^2 + 600 $CellContext`a1^2 $CellContext`a3^3 - 
   4 $CellContext`a1^3 $CellContext`a3^3 + 
   400 $CellContext`a1 $CellContext`a2 $CellContext`a3^3 + 
   600 $CellContext`a2^2 $CellContext`a3^3 - 
   4 $CellContext`a2^3 $CellContext`a3^3 + 20000 $CellContext`a3^4 - 
   300 $CellContext`a1 $CellContext`a3^4 - $CellContext`a1^2 \
$CellContext`a3^4 - 300 $CellContext`a2 $CellContext`a3^4 - 
   2 $CellContext`a1 $CellContext`a2 $CellContext`a3^4 - $CellContext`a2^2 \
$CellContext`a3^4 - 300 $CellContext`a3^5 + 
   2 $CellContext`a1 $CellContext`a3^5 + 
   2 $CellContext`a2 $CellContext`a3^5 + $CellContext`a3^6],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640337079*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5b0b3e2d-2bd5-4bac-89e0-1d449e6f8063"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Normals concur.\"\>"}],
  SequenceForm["  ", "Normals concur."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640337081955*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"580978a5-23e3-45aa-b57a-2f3495baa666"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X41\"\>"}],
  SequenceForm["i=", 41, " ", "X41"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640337084498*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"64a85afa-2973-4301-a66e-184447bc5d95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640337115382*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3b620d53-f6ac-470e-a695-11271d0bd024"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X42\"\>"}],
  SequenceForm["i=", 42, " ", "X42"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640337118083*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"84aee96d-0f41-4249-bc0b-82f5b91020a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "43", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X43\"\>"}],
  SequenceForm["i=", 43, " ", "X43"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403371492443`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"336ea870-7bf9-45c6-952a-83a27fb43d78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "44", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X44\"\>"}],
  SequenceForm["i=", 44, " ", "X44"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403371860332`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"289b27b8-9724-4845-8811-6fd884e2c584"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "45", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X45\"\>"}],
  SequenceForm["i=", 45, " ", "X45"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403372192907`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5afb92ff-7515-4914-930d-54fbdf4a4983"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "46", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X46\"\>"}],
  SequenceForm["i=", 46, " ", "X46"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640337258965*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e63de566-fd17-415c-a1ce-35294149abb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Property \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" failed in general,\"\>", 
   "\[InvisibleSpace]", "\<\" but numeric example succeeded.\"\>"}],
  SequenceForm[
  "  Property ", 17, " failed in general,", " but numeric example succeeded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403374357452`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"589de357-9ec1-49da-a09b-b9ce68f80aee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "47", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X47\"\>"}],
  SequenceForm["i=", 47, " ", "X47"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640337444373*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a6f6551b-c2bc-4183-b016-b05580515c83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "48", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X48\"\>"}],
  SequenceForm["i=", 48, " ", "X48"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403375232058`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cd6fe7b7-d72d-44e2-8434-2fe1f9fcc16b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "49", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X49\"\>"}],
  SequenceForm["i=", 49, " ", "X49"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403375627413`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c6bab34c-e993-4ea2-aaac-c77fbec1862c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "50", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X50\"\>"}],
  SequenceForm["i=", 50, " ", "X50"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640337690248*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3a0bc06f-98d2-4603-a0d4-358936f9a1e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "51", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Centroid of orthic triangle\"\>"}],
  SequenceForm["i=", 51, " ", "Centroid of orthic triangle"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640337776643*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"21f2efad-5c3c-491b-a259-104eb580f476"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "52", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Orthocenter of orthic triangle\"\>"}],
  SequenceForm["i=", 52, " ", "Orthocenter of orthic triangle"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640337856824*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"347dc0b2-dc9b-4b01-9f93-05ebbf005e47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "53", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Symmedian point of orthic triangle\"\>"}],
  SequenceForm["i=", 53, " ", "Symmedian point of orthic triangle"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640338020544*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7ac56204-a562-4090-b9d8-d7d13ba7277d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "54", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Nine point inv\"\>"}],
  SequenceForm["i=", 54, " ", "Nine point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640338183134*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0c36f72c-f241-44c9-81bf-bec84020ee54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "55", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Gergonne inv\"\>"}],
  SequenceForm["i=", 55, " ", "Gergonne inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640338340619*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0539d524-b261-444b-adb2-b2e00909cf8a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640338372109*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b4f16152-a8dc-4fd1-ace1-80f262eabec4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Property \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" failed in general,\"\>", 
   "\[InvisibleSpace]", "\<\" but numeric example succeeded.\"\>"}],
  SequenceForm[
  "  Property ", 17, " failed in general,", " but numeric example succeeded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564033838347*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bd1c8b07-1bff-4a19-91fb-ab4b2f3e22f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "56", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Nagel inv\"\>"}],
  SequenceForm["i=", 56, " ", "Nagel inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564033841591*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9824ed21-e967-4776-9322-0089666e622b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640338419018*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1acd5cad-1a46-463a-858f-1bf2b6f0cf46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Property \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" failed in general,\"\>", 
   "\[InvisibleSpace]", "\<\" but numeric example succeeded.\"\>"}],
  SequenceForm[
  "  Property ", 17, " failed in general,", " but numeric example succeeded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403384953947`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a845b694-e117-4217-832f-abc950e1ac92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "57", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Mittenpunkt inv\"\>"}],
  SequenceForm["i=", 57, " ", "Mittenpunkt inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640338504401*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c877fb61-0400-4215-add6-f22bc4051608"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640338535761*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8632eb06-6a2f-49ac-aceb-7075427d9e30"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Property \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" failed in general,\"\>", 
   "\[InvisibleSpace]", "\<\" but numeric example succeeded.\"\>"}],
  SequenceForm[
  "  Property ", 17, " failed in general,", " but numeric example succeeded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403385750017`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8f8b6f0a-c0cc-4e02-bba3-eac9367bd60e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "58", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Spieker inv\"\>"}],
  SequenceForm["i=", 58, " ", "Spieker inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640338578052*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0b3b9c7f-79c9-480f-8f9e-e6981d930243"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "59", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Feuerbach inv\"\>"}],
  SequenceForm["i=", 59, " ", "Feuerbach inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640338610618*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"443354ab-5b9f-4010-9738-18acdc23abf4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640338645153*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"db7c44dd-92cb-493d-82d3-63336574eaa5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "60", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X12 inv\"\>"}],
  
  SequenceForm["i=", 60, " ", "X12 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640338654866*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f4caed17-940d-47cd-9cf0-cf9bca50a28f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "61", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"1st Napoleon point inv\"\>"}],
  SequenceForm["i=", 61, " ", "1st Napoleon point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403387037687`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"590a8cb2-ff33-4fd9-9c22-8325cd624897"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "62", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd Napoleon point inv\"\>"}],
  SequenceForm["i=", 62, " ", "2nd Napoleon point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640339157179*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7d89116d-640d-4019-a20e-65bed72cea3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "63", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Crucial point inv\"\>"}],
  SequenceForm["i=", 63, " ", "Crucial point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640339571093*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9c205daa-cc06-41fa-9e34-c7990f20769f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"De Longchamps point inv\"\>"}],
  SequenceForm["i=", 64, " ", "De Longchamps point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564033960189*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f1c1f1a1-392b-4924-8d3b-add3b3e5265a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Schiffler point inv\"\>"}],
  SequenceForm["i=", 65, " ", "Schiffler point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403398702383`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0eb70a86-bcd9-4242-afa3-81bf25344d66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Property \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" failed in general,\"\>", 
   "\[InvisibleSpace]", "\<\" but numeric example succeeded.\"\>"}],
  SequenceForm[
  "  Property ", 17, " failed in general,", " but numeric example succeeded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640339941486*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"722f14ec-3e7f-46d0-be92-32243a2d02b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "66", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Exeter point inv\"\>"}],
  SequenceForm["i=", 66, " ", "Exeter point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403399439507`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0439cfff-627a-4f9c-882d-cfc7605f3cc7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"far out point inv\"\>"}],
  SequenceForm["i=", 67, " ", "far out point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403400215816`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"13c1094f-b8db-400e-a432-742e6e7cb479"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "68", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X24 inv\"\>"}],
  
  SequenceForm["i=", 68, " ", "X24 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640340126004*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"45d9d331-7799-4d4f-ac50-22dff6dc140a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "69", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X25 inv\"\>"}],
  
  SequenceForm["i=", 69, " ", "X25 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640340249385*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ecdd4227-1969-451d-ad35-12530d671a1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "70", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Circumcenter of tangential triangle inv\"\>"}],
  SequenceForm["i=", 70, " ", "Circumcenter of tangential triangle inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640340284102*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e46df4a6-a241-4cc9-87b1-a57df066eac8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "71", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X27 inv\"\>"}],
  
  SequenceForm["i=", 71, " ", "X27 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640340563696*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4271adaf-d09f-458d-b148-c7da1009eba6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "72", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X28 inv\"\>"}],
  
  SequenceForm["i=", 72, " ", "X28 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640340600115*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"44da8bea-34fd-4a3e-bc66-bb5be15e2a1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "73", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X29 inv\"\>"}],
  
  SequenceForm["i=", 73, " ", "X29 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403406353273`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a1706af9-12b4-4f95-8aae-5e852e217376"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "74", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X30 inv\"\>"}],
  
  SequenceForm["i=", 74, " ", "X30 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640340677205*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"eb4b05ea-964d-4772-aabf-6600325c9de3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "75", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2nd power point inv\"\>"}],
  SequenceForm["i=", 75, " ", "2nd power point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640340940751*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b7c76995-cb94-429c-9485-0976f2beaedc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640340974125*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d6a9fa5a-fc17-492f-acb1-b50e74f7e46f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "76", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"3rd power point inv\"\>"}],
  SequenceForm["i=", 76, " ", "3rd power point inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640340976521*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"34453a0e-a328-4f40-a50a-6203466f996c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564034097847*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7e392964-3d3b-4726-bcab-8c66548487ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "77", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X33 inv\"\>"}],
  
  SequenceForm["i=", 77, " ", "X33 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640340980378*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7b6f4d01-15a8-4efd-a8d0-d1ce13f313e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "78", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X34 inv\"\>"}],
  
  SequenceForm["i=", 78, " ", "X34 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341025524*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7a043a46-68d9-4e98-ae3d-9b229fce3d46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "79", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X35 inv\"\>"}],
  
  SequenceForm["i=", 79, " ", "X35 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341059298*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d49a7ed0-8f2d-41b0-b912-5f15c0dfc218"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "80", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X36 inv\"\>"}],
  
  SequenceForm["i=", 80, " ", "X36 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341111247*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b394b7cc-62bc-4f95-a68d-d333321d4b36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "81", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X37 inv\"\>"}],
  
  SequenceForm["i=", 81, " ", "X37 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341168294*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e3d4e99b-c86a-4adc-aaef-fc4b19938c70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "82", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X38 inv\"\>"}],
  
  SequenceForm["i=", 82, " ", "X38 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341203621*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8e679355-71fb-425b-a4d4-f60593c9f75b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "83", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Brocard midpoint inv\"\>"}],
  SequenceForm["i=", 83, " ", "Brocard midpoint inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341246159*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"79ff6ae6-4029-4a36-8ca6-c9d61d0bcdad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "84", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X40 inv\"\>"}],
  
  SequenceForm["i=", 84, " ", "X40 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341280686*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9f046a07-10fa-40db-b9d0-4483a234cd78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "85", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X41 inv\"\>"}],
  
  SequenceForm["i=", 85, " ", "X41 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341404808*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6d6228c8-e3ad-420e-b045-b062fd126a72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341439394*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"5fcdb67c-e11a-4440-ab9c-42c967666934"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "86", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X42 inv\"\>"}],
  
  SequenceForm["i=", 86, " ", "X42 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341441884*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a22e6a5d-12ff-465d-abd5-3cddad1592a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "87", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X43 inv\"\>"}],
  
  SequenceForm["i=", 87, " ", "X43 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341478869*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4d30c886-3800-452d-9016-03f1b1b058c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "88", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X44 inv\"\>"}],
  
  SequenceForm["i=", 88, " ", "X44 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341535088*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"08709555-da0e-49bd-8604-6338a42730ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "89", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X45 inv\"\>"}],
  
  SequenceForm["i=", 89, " ", "X45 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341569948*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e1052810-b7ba-4276-b278-13a32b92c513"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "90", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X46 inv\"\>"}],
  
  SequenceForm["i=", 90, " ", "X46 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341611803*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"65483eb6-1aab-4791-9c1b-5b98f576d46a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "91", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X47 inv\"\>"}],
  
  SequenceForm["i=", 91, " ", "X47 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341749173*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"3660cedf-caf7-406d-ac6f-8188b7e184d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "92", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X48 inv\"\>"}],
  
  SequenceForm["i=", 92, " ", "X48 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640341904303*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"870320dd-ceb2-4b24-9c06-9a326c646031"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "93", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X49 inv\"\>"}],
  
  SequenceForm["i=", 93, " ", "X49 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403419751883`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2351bf37-29a8-4398-a485-cf08a89d7249"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "94", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X50 inv\"\>"}],
  
  SequenceForm["i=", 94, " ", "X50 inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403422495127`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"dbce596a-4136-40d8-b6a5-6b280b1da3c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "95", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Centroid of orthic triangle inv\"\>"}],
  SequenceForm["i=", 95, " ", "Centroid of orthic triangle inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640342417891*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"851e63d5-0431-420e-b2e3-de20cb359fef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "96", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Orthocenter of orthic triangle inv\"\>"}],
  SequenceForm["i=", 96, " ", "Orthocenter of orthic triangle inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640342556815*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"45530a8c-19f6-4824-85a2-1d73670a2eab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "97", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Symmedian point of orthic triangle inv\"\>"}],
  SequenceForm["i=", 97, " ", "Symmedian point of orthic triangle inv"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640342910005*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f3e36d59-0d29-40b9-b7fe-d716dee2b4ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "98", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Tarry point\"\>"}],
  SequenceForm["i=", 98, " ", "Tarry point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343070224*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"95b2a8cb-6ea8-4707-96f1-3bd0c8029bfa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "99", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"Steiner point\"\>"}],
  SequenceForm["i=", 99, " ", "Steiner point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343187151*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9649ea6a-e933-4df2-aa65-586e039f6dfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "100", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X100\"\>"}],
  SequenceForm["i=", 100, " ", "X100"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343220389*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a5147702-1062-4205-93f7-ccaf5e7b908f"],

Cell[BoxData["\<\"  --> Some pairs of edges have same sum.\"\>"], "Print",
 CellChangeTimes->{3.805640343231885*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"99425815-a1a7-4dc1-9e84-a1baa24fba8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "101", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X101\"\>"}],
  SequenceForm["i=", 101, " ", "X101"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343265868*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"93e281f7-50d8-4fe7-98c0-fc16f4e6924a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "102", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X102\"\>"}],
  SequenceForm["i=", 102, " ", "X102"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343268382*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"9b7a3915-b5a4-4912-bf2c-6f4c4f01c3d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "103", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X103\"\>"}],
  SequenceForm["i=", 103, " ", "X103"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403433416557`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4f30e02d-428a-4982-8d85-cc1606c46d46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "104", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X104\"\>"}],
  SequenceForm["i=", 104, " ", "X104"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343377252*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"77db6406-e088-4a72-ba38-fa235d61d46f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "105", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X105\"\>"}],
  SequenceForm["i=", 105, " ", "X105"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564034341083*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8697c825-5aa1-4d47-a96f-9f878cc8ebbe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "106", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X106\"\>"}],
  SequenceForm["i=", 106, " ", "X106"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564034344575*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c82befcc-7aca-4397-88a1-e932b20cb8eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "107", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X107\"\>"}],
  SequenceForm["i=", 107, " ", "X107"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343454772*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"300a26a3-0ba2-422f-a24a-9e34fd3b58de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "108", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X108\"\>"}],
  SequenceForm["i=", 108, " ", "X108"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343491427*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b85c4269-d1fe-4832-83c0-31bfbfcdc493"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "109", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X109\"\>"}],
  SequenceForm["i=", 109, " ", "X109"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343539712*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"7e050477-9044-4ff6-a130-129a5504a8f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "110", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X110\"\>"}],
  SequenceForm["i=", 110, " ", "X110"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343577663*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"358c95b6-a36e-4f61-b252-023c9bccdcd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "111", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X111\"\>"}],
  SequenceForm["i=", 111, " ", "X111"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403436327353`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1b1207c7-6dd1-44a3-ac61-b7e3700f48af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "112", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X112\"\>"}],
  SequenceForm["i=", 112, " ", "X112"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343665205*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a9f32ef1-55a9-4fee-a331-736294e677bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "113", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X113\"\>"}],
  SequenceForm["i=", 113, " ", "X113"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403436989937`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f41a28c8-e4a6-4cb5-a852-0abb4ee0ff60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "114", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X114\"\>"}],
  SequenceForm["i=", 114, " ", "X114"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564034373316*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"cc7e2850-6585-4310-9de3-d66c57d3797b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "115", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X115\"\>"}],
  SequenceForm["i=", 115, " ", "X115"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343742402*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a786b6dd-6f9c-4b2d-ad28-eeaa611ea37a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "116", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X116\"\>"}],
  SequenceForm["i=", 116, " ", "X116"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403437738657`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ae42ecdb-d7cd-4b42-b4aa-c82a5f606840"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "117", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"X117\"\>"}],
  SequenceForm["i=", 117, " ", "X117"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343811593*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"b4ee6e8c-a8bc-414b-b53a-23e6e9e01a99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "118", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"r-power point\"\>"}],
  SequenceForm["i=", 118, " ", "r-power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403438476973`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"046303e0-fd23-4a57-8039-3941c9b1701f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343882082*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"0f3314eb-bac6-430b-9e65-01a0a6062eaf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "119", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"r2-power point\"\>"}],
  SequenceForm["i=", 119, " ", "r2-power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343884486*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ff7a3613-7f63-42a5-af19-580daa472360"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "120", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"r3-power point\"\>"}],
  SequenceForm["i=", 120, " ", "r3-power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564034391707*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"024d774b-c6af-4082-845a-152cd712bd8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "121", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z1\"\>"}],
  SequenceForm["i=", 121, " ", "Z1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640343950452*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2a1a24fb-8838-4c96-a731-c4b623b0561d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "122", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z2\"\>"}],
  SequenceForm["i=", 122, " ", "Z2"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640344007139*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ac967315-932e-4465-99dd-be21c357e701"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "123", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z3\"\>"}],
  SequenceForm["i=", 123, " ", "Z3"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640344045062*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"c5b09e50-a122-4fde-a80c-3965da633798"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564034408119*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"bf336c9f-fd66-4939-bd1a-b8c87b155dcb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "124", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z4\"\>"}],
  SequenceForm["i=", 124, " ", "Z4"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403441152477`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a97e196c-40b7-4d6c-9e26-d47717137589"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "125", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z5\"\>"}],
  SequenceForm["i=", 125, " ", "Z5"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564034414815*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2cadf0b4-22a0-4bfb-b673-043160d84a54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "126", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z6\"\>"}],
  SequenceForm["i=", 126, " ", "Z6"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640344216425*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4c49ffac-44ca-4237-8570-e08ba6830d75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "127", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z7\"\>"}],
  SequenceForm["i=", 127, " ", "Z7"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640344270252*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"ab55da03-d16d-4ac4-9ca9-f881e435081b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "128", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"Z8\"\>"}],
  SequenceForm["i=", 128, " ", "Z8"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640344336543*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8b9f76b0-e3b1-4ef5-91bc-05d34335eef1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "129", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"r4-power point\"\>"}],
  SequenceForm["i=", 129, " ", "r4-power point"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640344374248*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"25740787-1860-462f-842d-6e35e54a3ebf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640344411104*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"a127f724-7a6d-4dfe-9ced-ff812899737f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" coincides with reference \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    Central ", "centroid", " coincides with reference ", "centroid", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640344419153*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f00b77cd-206f-4995-9caa-32688729405e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have centers in common.\"\>"}],
  SequenceForm["  ", "Tetrahedra have centers in common."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640381225296*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"930c0e1b-0c86-41dc-a8f5-1e45e222febe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "130", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"arbitrary center\"\>"}],
  SequenceForm["i=", 130, " ", "arbitrary center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640381228244*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"308f8ee3-50a9-49d0-86ee-7e71049a02d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "131", 
   "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"areal center\"\>"}],
  SequenceForm["i=", 131, " ", "areal center"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640381261093*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"acbfb327-cf09-4a0e-b5e4-78ec1f84687f"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.805640381934917*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1455ff7d-1291-4c8d-851a-f11e5326b329"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CASE \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"Isodynamic Tetrahedron\"\>"}],
  SequenceForm["CASE ", 4, ": ", "Isodynamic Tetrahedron"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403819372272`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"aa574963-d9da-486f-b382-b7cb14fe587e"],

Cell[BoxData["\<\"------\"\>"], "Print",
 CellChangeTimes->{3.805640381939004*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"e937d4d4-125c-43aa-894c-385b6ffc12c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"incenter\"\>"}],
  SequenceForm["i=", 1, " ", "incenter"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640381946603*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"8c2d7371-4bbf-410b-9878-0b001ee96f45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Coordinates of intersection point:  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"100", " ", "a1"}], ",", 
     RowBox[{"100", " ", "a2"}], ",", 
     RowBox[{"100", " ", "a3"}], ",", 
     RowBox[{"a1", " ", "a2", " ", "a3"}]}], "}"}]}],
  SequenceForm[
  "    Coordinates of intersection point:  ", {
   100 $CellContext`a1, 100 $CellContext`a2, 
    100 $CellContext`a3, $CellContext`a1 $CellContext`a2 $CellContext`a3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640381979816*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"d6714415-f699-4b8d-9441-df3192941e9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Cevians concur.\"\>"}],
  SequenceForm["  ", "Cevians concur."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640381988661*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1a3c89d1-758c-4774-8842-bcde49e8b5f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640381991106*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6d901acf-1fee-4f7c-98f4-7824c7c05c45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>"}],
  SequenceForm["i=", 2, " ", "centroid"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640382022553*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"4406555b-2eb4-446c-be4f-d8e987be74c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Faces are parallel.\"\>"}],
  SequenceForm["  ", "Faces are parallel."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403820248957`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6676e934-5cfb-444d-83e7-28b04629a8da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Coordinates of intersection point:  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["    Coordinates of intersection point:  ", {1, 1, 1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640382026751*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"6ae7110d-5de6-4d36-8d9f-1392f48550a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Point coincides with \"\>", 
   "\[InvisibleSpace]", "\<\"centroid\"\>", 
   "\[InvisibleSpace]", "\<\" of tetrahedron.\"\>"}],
  SequenceForm["    Point coincides with ", "centroid", " of tetrahedron."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640382028582*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"18135d76-542d-4a54-ba5b-d34bc1140295"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \"\>", "\[InvisibleSpace]", "\<\"Intersection point\"\>", 
   "\[InvisibleSpace]", "\<\" lies on reference Euler line (at \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm[
  "    ", "Intersection point", " lies on reference Euler line (at ", 1, ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403820306273`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"63a41945-b3c0-4352-921a-6e71c35ab3ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", "\<\"Cevians concur.\"\>"}],
  SequenceForm["  ", "Cevians concur."],
  Editable->False]], "Print",
 CellChangeTimes->{3.80564038203305*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"1fda6d6b-9c0c-4e35-8846-e98de5f646e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedron is isodynamic.\"\>"}],
  SequenceForm["  ", "Tetrahedron is isodynamic."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403820351267`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f635b5e2-65aa-4feb-a5bf-1fd469166409"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra have same centroid.\"\>"}],
  SequenceForm["  ", "Tetrahedra have same centroid."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056403820371313`*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"f5c83972-e598-4630-b0c9-1b8df2882628"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Cevians form a hyperbolic group.\"\>"}],
  SequenceForm["  ", "Cevians form a hyperbolic group."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640382039007*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"74ccf150-3d5e-44cf-9360-410d56b4cf20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", 
   "\[InvisibleSpace]", "\<\"Tetrahedra are similar.\"\>"}],
  SequenceForm["  ", "Tetrahedra are similar."],
  Editable->False]], "Print",
 CellChangeTimes->{3.805640382040821*^9},
 CellLabel->
  "During evaluation of \
In[346]:=",ExpressionUUID->"2029b766-daf0-4446-bf19-169548d0dee8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Central \"\>", "\[InvisibleSpace]", "\<\"centroid\"\>", 
